/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.common.ScaCommonPlugin;
import org.eclipse.stp.sca.common.internal.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class ScaProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private WizardNewProjectCreationPage page;
    private IConfigurationElement configurationElement;

    public ScaProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new WizardNewProjectCreationPage(Messages.ScaProjectWizard_7);
        this.page.setTitle(Messages.ScaProjectWizard_8);
        this.page.setDescription(Messages.ScaProjectWizard_9);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        String projectName = this.page.getProjectName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        ScaProjectWizard.this.doFinish(projectName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ScaProjectWizard_0, (String)realException.getMessage());
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
        return true;
    }

    private void doFinish(String projectName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)Messages.ScaProjectWizard_1, (Object)projectName), 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject scaProject = root.getProject(projectName);
        if (scaProject.exists()) {
            Status status = new Status(4, "org.eclipse.stp.sca.common", 0, NLS.bind((String)Messages.ScaProjectWizard_3, (Object)projectName), null);
            ScaCommonPlugin.getDefault().getLog().log((IStatus)status);
            return;
        }
        try {
            String[] subFolders;
            scaProject.create(monitor);
            scaProject.open(monitor);
            String[] stringArray = subFolders = new String[]{"composites"};
            int n = subFolders.length;
            int n2 = 0;
            while (n2 < n) {
                String subFolder = stringArray[n2];
                IFolder modelFolder = scaProject.getFolder((IPath)new Path(subFolder));
                if (!modelFolder.exists()) {
                    modelFolder.create(false, true, monitor);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.stp.sca.common", 0, NLS.bind((String)Messages.ScaProjectWizard_10, (Object)projectName), (Throwable)e);
            ScaCommonPlugin.getDefault().getLog().log((IStatus)status);
            return;
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.ScaProjectWizard_6);
        IProjectDescription description = scaProject.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "org.eclipse.stp.sca.common.scaNature";
        description.setNatureIds(newNatures);
        scaProject.setDescription(description, monitor);
        monitor.worked(1);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configurationElement = config;
    }

    static /* synthetic */ void access$0(ScaProjectWizard scaProjectWizard, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        scaProjectWizard.doFinish(string, iProgressMonitor);
    }
}

