/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.diagram.extension.edit.part;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.BindingInformationImpl;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.ElementInformation;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.ElementType;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.ImplementationInformationImpl;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.InterfaceInformationImpl;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.Messages;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.Utils;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.VisualIDRegistryBase;
import org.eclipse.stp.sca.csa.diagram.extension.view.factories.BindingViewFactory;
import org.eclipse.stp.sca.csa.diagram.extension.view.factories.ImplementationViewFactory;
import org.eclipse.stp.sca.csa.diagram.extension.view.factories.InterfaceViewFactory;

class ElementInformationFactory {
    private String typeId;
    private EStructuralFeature elementLiteral;
    private String visualId;
    private String iconPath;

    ElementInformationFactory() {
    }

    ElementInformation createElementInformation(ElementType type) {
        ElementInformation result = null;
        switch (type) {
            case BINDING: {
                result = this.createElementInformation(new BindingInformationImpl(), BindingViewFactory.class);
                break;
            }
            case IMPLEMENTATION: {
                result = this.createElementInformation(new ImplementationInformationImpl(), ImplementationViewFactory.class);
                break;
            }
            case INTERFACE: {
                result = this.createElementInformation(new InterfaceInformationImpl(), InterfaceViewFactory.class);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ElementInformation createElementInformation(ElementInformation elementInformation, Class clazz) throws IllegalStateException {
        int visualId;
        IElementType elementType = ElementTypeRegistry.getInstance().getType(this.getTypeId());
        if (elementType == null) {
            throw new IllegalStateException(Messages.ElementInformationFactory_0);
        }
        if (this.getVisualId() == null) {
            if (!IHintedType.class.isInstance(elementType)) throw new IllegalStateException(Messages.ElementInformationFactory_2);
            IHintedType hintedType = (IHintedType)IHintedType.class.cast(elementType);
            String semanticHint = hintedType.getSemanticHint();
            try {
                visualId = Utils.getVisualID(semanticHint);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(Messages.ElementInformationFactory_1, e);
            }
        } else {
            visualId = Utils.getVisualID(this.getVisualId());
        }
        SimpleVisualIDRegistry visualIDRegistry = new SimpleVisualIDRegistry(elementType.getEClass(), visualId);
        String iconPath = null;
        if (this.getIconPath() != null) {
            iconPath = this.getIconPath();
        }
        if (this.getElementLiteral() == null) {
            throw new IllegalStateException(Messages.ElementInformationFactory_3);
        }
        elementInformation.setElementType(elementType);
        elementInformation.setElementLiteral(this.getElementLiteral());
        elementInformation.setVisualID(visualId);
        elementInformation.setVisualIDRegistry(visualIDRegistry);
        elementInformation.setViewFactoryClass(clazz);
        elementInformation.setIconPath(iconPath);
        return elementInformation;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public String getVisualId() {
        return this.visualId;
    }

    public void setVisualId(String visualId) {
        this.visualId = visualId;
    }

    public EStructuralFeature getElementLiteral() {
        return this.elementLiteral;
    }

    public void setElementLiteral(EStructuralFeature bindingLiteral) {
        this.elementLiteral = bindingLiteral;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    private static class SimpleVisualIDRegistry
    extends VisualIDRegistryBase {
        private EClass eclass;
        private int visualId;

        public SimpleVisualIDRegistry(EClass eclass, int visuald) {
            this.eclass = eclass;
            this.visualId = visuald;
        }

        EClass getEClass() {
            return this.eclass;
        }

        int getVisualID() {
            return this.visualId;
        }
    }
}

