/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.diagram.dnd;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.stp.sca.csa.diagram.dnd.IDragDropHandler;
import org.eclipse.stp.sca.csa.diagram.dnd.Messages;
import org.eclipse.stp.sca.csa.diagram.part.CsaDiagramEditorPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnyExtensionDDProvider {
    public static final AnyExtensionDDProvider INSTANCE = new AnyExtensionDDProvider();
    private static final String DRAG_AND_DROP_ANY_EXTENSION_EXTENSION_POINT = "org.eclipse.stp.sca.diagram.DragAndDropAnyExtension";
    private static final String TAG_ENGINE = "DragDropAnyExtension";
    private Collection<IDragDropHandler> anyExtensionsDD = new HashSet<IDragDropHandler>();

    private AnyExtensionDDProvider() {
    }

    public Collection<IDragDropHandler> getAnyExtensionImplementationDD() {
        if (this.anyExtensionsDD.isEmpty()) {
            this.loadExtensions();
        }
        return this.anyExtensionsDD;
    }

    private void loadExtensions() {
        this.parseExtensionMetadata();
    }

    private void parseExtensionMetadata() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(DRAG_AND_DROP_ANY_EXTENSION_EXTENSION_POINT);
            if (extensionPoint != null) {
                int cfr_ignored_0 = extensionPoint.getExtensions().length;
            }
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IDragDropHandler desc = this.parseEngine(configElements[j]);
                    if (desc != null) {
                        this.anyExtensionsDD.add(desc);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private IDragDropHandler parseEngine(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_ENGINE)) {
            return null;
        }
        IDragDropHandler desc = null;
        try {
            desc = (IDragDropHandler)configElement.createExecutableExtension("class");
        }
        catch (CoreException e) {
            CsaDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.stp.sca.csa.diagram", String.valueOf(Messages.DragDropAnyExtensionEditPolicy_0) + configElement.getAttribute("class"), (Throwable)e));
        }
        return desc;
    }
}

