/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.diagram.part;

import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.csa.diagram.part.CsaDiagramEditorPlugin;
import org.eclipse.stp.sca.csa.diagram.part.CsaDiagramEditorUtil;
import org.eclipse.stp.sca.csa.diagram.part.CsaVisualIDRegistry;
import org.eclipse.stp.sca.csa.diagram.part.Messages;
import org.eclipse.stp.sca.csa.diagram.part.ModelElementSelectionPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class CsaNewDiagramFileWizard
extends Wizard {
    private WizardNewFileCreationPage myFileCreationPage;
    private ModelElementSelectionPage diagramRootElementSelectionPage;
    private TransactionalEditingDomain myEditingDomain;

    public CsaNewDiagramFileWizard(URI domainModelURI, EObject diagramRoot, TransactionalEditingDomain editingDomain) {
        Path filePath;
        assert (domainModelURI != null) : "Domain model uri must be specified";
        assert (diagramRoot != null) : "Doagram root element must be specified";
        assert (editingDomain != null) : "Editing domain must be specified";
        this.myFileCreationPage = new WizardNewFileCreationPage(Messages.CsaNewDiagramFileWizard_CreationPageName, (IStructuredSelection)StructuredSelection.EMPTY);
        this.myFileCreationPage.setTitle(Messages.CsaNewDiagramFileWizard_CreationPageTitle);
        this.myFileCreationPage.setDescription(NLS.bind((String)Messages.CsaNewDiagramFileWizard_CreationPageDescription, (Object)"Csa"));
        String fileName = domainModelURI.trimFileExtension().lastSegment();
        if (domainModelURI.isPlatformResource()) {
            filePath = new Path(domainModelURI.trimSegments(1).toPlatformString(true));
        } else if (domainModelURI.isFile()) {
            filePath = new Path(domainModelURI.trimSegments(1).toFileString());
        } else {
            throw new IllegalArgumentException("Unsupported URI: " + domainModelURI);
        }
        this.myFileCreationPage.setContainerFullPath((IPath)filePath);
        this.myFileCreationPage.setFileName(CsaDiagramEditorUtil.getUniqueFileName((IPath)filePath, fileName, "composite_diagram"));
        this.diagramRootElementSelectionPage = new DiagramRootElementSelectionPage(Messages.CsaNewDiagramFileWizard_RootSelectionPageName);
        this.diagramRootElementSelectionPage.setTitle(Messages.CsaNewDiagramFileWizard_RootSelectionPageTitle);
        this.diagramRootElementSelectionPage.setDescription(Messages.CsaNewDiagramFileWizard_RootSelectionPageDescription);
        this.diagramRootElementSelectionPage.setModelElement(diagramRoot);
        this.myEditingDomain = editingDomain;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.myFileCreationPage);
    }

    public boolean performFinish() {
        LinkedList<IFile> affectedFiles = new LinkedList<IFile>();
        IFile diagramFile = this.myFileCreationPage.createNewFile();
        CsaDiagramEditorUtil.setCharset(diagramFile);
        affectedFiles.add(diagramFile);
        URI diagramModelURI = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true);
        ResourceSet resourceSet = this.myEditingDomain.getResourceSet();
        final Resource diagramResource = resourceSet.createResource(diagramModelURI);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(this.myEditingDomain, Messages.CsaNewDiagramFileWizard_InitDiagramCommand, affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int diagramVID = CsaVisualIDRegistry.getDiagramVisualID(CsaNewDiagramFileWizard.this.diagramRootElementSelectionPage.getModelElement());
                if (diagramVID != 1000) {
                    return CommandResult.newErrorCommandResult((String)Messages.CsaNewDiagramFileWizard_IncorrectRootError);
                }
                Diagram diagram = ViewService.createDiagram((EObject)CsaNewDiagramFileWizard.this.diagramRootElementSelectionPage.getModelElement(), (String)"Csa", (PreferencesHint)CsaDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                diagramResource.getContents().add((Object)diagram);
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            diagramResource.save(CsaDiagramEditorUtil.getSaveOptions());
            CsaDiagramEditorUtil.openDiagram(diagramResource);
        }
        catch (ExecutionException e) {
            CsaDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        catch (IOException ex) {
            CsaDiagramEditorPlugin.getInstance().logError("Save operation failed for: " + diagramModelURI, ex);
        }
        catch (PartInitException ex) {
            CsaDiagramEditorPlugin.getInstance().logError("Unable to open editor", ex);
        }
        return true;
    }

    private static class DiagramRootElementSelectionPage
    extends ModelElementSelectionPage {
        protected DiagramRootElementSelectionPage(String pageName) {
            super(pageName);
        }

        protected String getSelectionTitle() {
            return Messages.CsaNewDiagramFileWizard_RootSelectionPageSelectionTitle;
        }

        protected boolean validatePage() {
            if (this.selectedModelElement == null) {
                this.setErrorMessage(Messages.CsaNewDiagramFileWizard_RootSelectionPageNoSelectionMessage);
                return false;
            }
            boolean result = ViewService.getInstance().provides((IOperation)new CreateDiagramViewOperation((IAdaptable)new EObjectAdapter(this.selectedModelElement), "Csa", CsaDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT));
            this.setErrorMessage(result ? null : Messages.CsaNewDiagramFileWizard_RootSelectionPageInvalidSelectionMessage);
            return result;
        }
    }
}

