/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.diagram.router.lib;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.stp.sca.csa.diagram.edit.parts.ComponentReferenceEditPart;
import org.eclipse.stp.sca.csa.diagram.edit.parts.ComponentServiceEditPart;
import org.eclipse.stp.sca.csa.diagram.edit.parts.ReferenceEditPart;
import org.eclipse.stp.sca.csa.diagram.edit.parts.ServiceEditPart;
import org.eclipse.stp.sca.csa.diagram.router.api.IModelAwareAnchor;
import org.eclipse.stp.sca.csa.diagram.router.api.IModelAwareAnchorSupport;

public class ScaAwareAnchorSupport
implements IModelAwareAnchorSupport {
    public static final ScaAwareAnchorSupport INSTANCE = new ScaAwareAnchorSupport();

    public Point getLocation(IModelAwareAnchor anchor, Point reference) {
        if (anchor.getConnectionType() == null || anchor.getAnchorPositionningStyle() == 0) {
            return this.returnDefaultLocation(anchor, reference);
        }
        if (anchor.getConnectionType().startsWith(String.valueOf(true))) {
            if (anchor.isSourceAnchor() == 2) {
                return this.returnDefaultLocation(anchor, reference);
            }
            Rectangle thisBox = this.getOwnerBounds(anchor);
            anchor.getOwner().translateToAbsolute((Translatable)thisBox);
            Point thisCenter = thisBox.getCenter();
            Point res = new Point();
            if (!anchor.getConnectionType().equals(true)) {
                res.x = thisCenter.x;
                res.y = thisCenter.y + thisBox.height / 2;
            } else {
                res.x = anchor.isSourceAnchor() == 0 ? thisCenter.x + thisBox.width / 2 : thisCenter.x - thisBox.width / 2;
                if (anchor.getCount() > 0 && anchor.getOrderNumber() != -1) {
                    int height = thisBox.height;
                    res.y = thisCenter.y - height / 2 + height / (anchor.getCount() + 1) * (anchor.getOrderNumber() + 1);
                } else {
                    res.y = thisCenter.y;
                }
            }
            return res;
        }
        if (anchor.getConnectionType().startsWith(String.valueOf(true))) {
            if (anchor.getOwner() == null || anchor.getConnectionOwner() == null || anchor.isSourceAnchor() == 2) {
                return this.returnDefaultLocation(anchor, reference);
            }
            Connection conn = anchor.getConnectionOwner();
            Rectangle thisBox = this.getOwnerBounds(anchor);
            anchor.getOwner().translateToAbsolute((Translatable)thisBox);
            Point thisCenter = thisBox.getCenter();
            Point otherCenter = null;
            if (anchor.isSourceAnchor() == 0) {
                if (conn.getTargetAnchor().getOwner() == null) {
                    otherCenter = conn.getTargetAnchor().getReferencePoint();
                } else {
                    otherCenter = conn.getTargetAnchor().getOwner().getBounds().getCenter();
                    conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)otherCenter);
                }
            } else if (conn.getSourceAnchor().getOwner() == null) {
                otherCenter = conn.getSourceAnchor().getReferencePoint();
            } else {
                otherCenter = conn.getSourceAnchor().getOwner().getBounds().getCenter();
                conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)otherCenter);
            }
            Point res = new Point();
            res.y = thisCenter.y > otherCenter.y ? thisCenter.y - thisBox.height / 2 : thisCenter.y + thisBox.height / 2;
            if (anchor.getCount() > 0 && anchor.getOrderNumber() != -1) {
                int width = thisBox.width;
                res.x = thisCenter.x - width / 2 + width / (anchor.getCount() + 1) * (anchor.getOrderNumber() + 1);
            } else {
                res.x = thisCenter.x;
            }
            return res;
        }
        if (reference == null) {
            Point thisCenter = anchor.getOwner().getBounds().getCenter();
            anchor.getOwner().translateToAbsolute((Translatable)thisCenter);
            return thisCenter;
        }
        return anchor.getDefaultLocation(reference);
    }

    private Point returnDefaultLocation(IModelAwareAnchor anchor, Point reference) {
        if (reference == null && anchor.getOwner() != null) {
            Point thisCenter = this.getOwnerBounds(anchor).getCenter();
            anchor.getOwner().translateToAbsolute((Translatable)thisCenter);
            return thisCenter;
        }
        return anchor.getDefaultLocation(reference);
    }

    private Rectangle getOwnerBounds(IModelAwareAnchor anchor) {
        for (Object child : anchor.getOwner().getChildren()) {
            if (!(child instanceof ComponentServiceEditPart.ServiceFigure) && !(child instanceof ComponentReferenceEditPart.ReferenceFigure) && !(child instanceof ServiceEditPart.ServiceFigure) && !(child instanceof ReferenceEditPart.ReferenceFigure)) continue;
            return ((IFigure)child).getBounds().getCopy();
        }
        return anchor.getOwner().getBounds().getCopy();
    }
}

