/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.introspection;

import java.util.HashMap;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.stp.sca.csa.Component;
import org.eclipse.stp.sca.csa.ComponentReference;
import org.eclipse.stp.sca.csa.ComponentService;
import org.eclipse.stp.sca.csa.Composite;
import org.eclipse.stp.sca.csa.CsaFactory;
import org.eclipse.stp.sca.csa.CsaPackage;
import org.eclipse.stp.sca.csa.Interface;
import org.eclipse.stp.sca.csa.Property;
import org.eclipse.stp.sca.csa.PropertyValue;
import org.eclipse.stp.sca.csa.Reference;
import org.eclipse.stp.sca.csa.SCAImplementation;
import org.eclipse.stp.sca.csa.Service;
import org.eclipse.stp.sca.csa.introspection.Resolver;

public class CompositeImplementationResolver
implements Resolver {
    public void resolveServices(Component component, Composite composite) {
        for (Service service : composite.getService()) {
            this.setService(component, service);
        }
    }

    public void resolveReferences(Component component, Composite composite) {
        for (Reference reference : composite.getReference()) {
            this.setReference(component, reference);
        }
    }

    public void resolveProperties(Component component, Composite composite) {
        HashMap propertyMap = new HashMap();
        HashMap<String, Property> missingPropertyMap = new HashMap<String, Property>();
        EList newPropertyList = composite.getProperty();
        for (Property property : newPropertyList) {
            if (propertyMap.containsValue(property.getName())) continue;
            String pName = property.getName();
            missingPropertyMap.put(pName, property);
        }
        Set propertySet = missingPropertyMap.keySet();
        for (String key : propertySet) {
            PropertyValue p = CsaFactory.eINSTANCE.createPropertyValue();
            p.setName(key);
            p.setType(((Property)missingPropertyMap.get(key)).getType());
            component.getProperty().add((Object)p);
        }
    }

    public Composite resolve(Composite composite) {
        for (Component component : composite.getComponent()) {
            this.resolve(component);
        }
        return composite;
    }

    private void resolve(Component component) {
        Object compositeFile;
        if (!(component.getImplementation() instanceof SCAImplementation)) {
            return;
        }
        SCAImplementation scaImplem = (SCAImplementation)component.getImplementation();
        QName compositeName = scaImplem.getName();
        if (compositeName == null || (compositeFile = null) != null) {
            // empty if block
        }
    }

    private void setService(Component component, Service service) {
        ComponentService componentService = CsaFactory.eINSTANCE.createComponentService();
        componentService.setName(service.getName());
        if (service.getInterface() != null) {
            this.setInterface(componentService.getInterfaceGroup(), CsaPackage.Literals.CONTRACT__INTERFACE_GROUP, service.getInterfaceGroup().getEStructuralFeature(0), service.getInterface());
        } else if (service.getPromote() != null && service.getPromote().getInterface() != null) {
            this.setInterface(componentService.getInterfaceGroup(), CsaPackage.Literals.CONTRACT__INTERFACE_GROUP, service.getPromote().getInterfaceGroup().getEStructuralFeature(0), service.getPromote().getInterface());
        }
        component.getService().add((Object)componentService);
    }

    private void setInterface(FeatureMap interfaceGroup, EAttribute interfaceGroupLiteral, EStructuralFeature eStructuralFeature, Interface interfac) {
        ((FeatureMap.Internal)interfaceGroup).clear();
        ((FeatureMap.Internal)interfaceGroup).add((EStructuralFeature)interfaceGroupLiteral, (Object)FeatureMapUtil.createEntry((EStructuralFeature)eStructuralFeature, (Object)interfac));
    }

    private void setReference(Component component, Reference reference) {
        ComponentReference componentReference = CsaFactory.eINSTANCE.createComponentReference();
        componentReference.setName(reference.getName());
        if (reference.getInterface() != null) {
            this.setInterface(componentReference.getInterfaceGroup(), CsaPackage.Literals.CONTRACT__INTERFACE_GROUP, reference.getInterfaceGroup().getEStructuralFeature(0), reference.getInterface());
        }
        for (ComponentReference cr : reference.getPromote()) {
            if (cr.getInterface() == null) continue;
            this.setInterface(componentReference.getInterfaceGroup(), CsaPackage.Literals.CONTRACT__INTERFACE_GROUP, cr.getInterfaceGroup().getEStructuralFeature(0), cr.getInterface());
        }
        component.getReference().add((Object)componentReference);
    }
}

