/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.introspection;

import java.util.Iterator;
import org.eclipse.stp.sca.csa.Component;
import org.eclipse.stp.sca.csa.ComponentReference;
import org.eclipse.stp.sca.csa.ComponentService;
import org.eclipse.stp.sca.csa.Composite;
import org.eclipse.stp.sca.csa.CsaFactory;
import org.eclipse.stp.sca.csa.Reference;
import org.eclipse.stp.sca.csa.Service;
import org.eclipse.stp.sca.csa.Wire;
import org.eclipse.stp.sca.csa.introspection.Resolver;

public class PromoteResolver
implements Resolver {
    public Composite resolve(Composite composite) {
        this.promoteServices(composite);
        this.promoteReferences(composite);
        return composite;
    }

    private void promoteReferences(Composite composite) {
        for (Component component : composite.getComponent()) {
            for (ComponentReference cr : component.getReference()) {
                if (this.isComponentReferenceUsed(composite, cr)) continue;
                Reference reference = CsaFactory.eINSTANCE.createReference();
                reference.setName(cr.getName());
                reference.getPromote().add((Object)cr);
                composite.getReference().add((Object)reference);
            }
        }
    }

    private boolean isComponentReferenceUsed(Composite composite, ComponentReference cr) {
        boolean used = false;
        boolean bl = used = cr.getTarget() != null;
        if (!used) {
            for (Wire wire : composite.getWire()) {
                if (!wire.getSource2().equals(cr)) continue;
                used = true;
                break;
            }
        }
        if (!used) {
            Iterator it = composite.getReference().iterator();
            while (!used && it.hasNext()) {
                Reference reference = (Reference)it.next();
                used = reference.getPromote().contains((Object)cr);
            }
        }
        return used;
    }

    private void promoteServices(Composite composite) {
        for (Component component : composite.getComponent()) {
            for (ComponentService cs : component.getService()) {
                if (this.isComponentServiceUsed(composite, cs)) continue;
                Service service = CsaFactory.eINSTANCE.createService();
                service.setName(cs.getName());
                service.setPromote(cs);
                composite.getService().add((Object)service);
            }
        }
    }

    private boolean isComponentServiceUsed(Composite composite, ComponentService cs) {
        boolean used = false;
        if (!used) {
            for (Wire wire : composite.getWire()) {
                if (!wire.getTarget2().equals(cs)) continue;
                used = true;
                break;
            }
        }
        Iterator it = composite.getService().iterator();
        while (!used && it.hasNext()) {
            Service service = (Service)it.next();
            used = service.getPromote().equals(cs);
        }
        if (!used) {
            Iterator it1 = composite.getComponent().iterator();
            while (!used && it1.hasNext()) {
                Component component = (Component)it1.next();
                Iterator it2 = component.getReference().iterator();
                while (!used && it2.hasNext()) {
                    ComponentReference ref = (ComponentReference)it2.next();
                    used = ref.getTarget().contains((Object)cs);
                }
            }
        }
        return used;
    }
}

