/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.util;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CsaResourceImpl
extends XMLResourceImpl {
    public CsaResourceImpl(URI uri) {
        super(uri);
        CsaResourceImpl.prepareCompositeFile(uri);
    }

    public static void prepareCompositeFile(URI uri) {
        try {
            IPath path = Platform.getLocation();
            File file = new File(String.valueOf(path.toString()) + uri.toPlatformString(true));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            CsaResourceImpl.computeTargetReferences(doc);
            CsaResourceImpl.computePromoteReferences(doc);
            CsaResourceImpl.computePromoteServices(doc);
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            Transformer idTransform = xformFactory.newTransformer();
            DOMSource input = new DOMSource(doc);
            FileOutputStream fos = new FileOutputStream(file);
            StreamResult output = new StreamResult(fos);
            idTransform.transform(input, output);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void computePromoteServices(Document doc) {
        Element fstElmnt;
        Node fstNode;
        ArrayList<Node> promoteToCompute = new ArrayList<Node>();
        NodeList nodeLst = doc.getElementsByTagName("service");
        int s = 0;
        while (s < nodeLst.getLength()) {
            Node promoteRef;
            fstNode = nodeLst.item(s);
            if (fstNode.getNodeType() == 1 && (promoteRef = (fstElmnt = (Element)fstNode).getAttributes().getNamedItem("promote")) != null && !promoteRef.getNodeValue().contains("/")) {
                promoteToCompute.add(promoteRef);
            }
            ++s;
        }
        nodeLst = doc.getElementsByTagName("component");
        s = 0;
        while (s < nodeLst.getLength()) {
            fstNode = nodeLst.item(s);
            if (fstNode.getNodeType() == 1) {
                String componentName;
                fstElmnt = (Element)fstNode;
                NodeList fstNmElmntLst = fstElmnt.getElementsByTagName("service");
                int fstNmElmntLstSize = fstNmElmntLst.getLength();
                if (fstNmElmntLstSize == 0) {
                    for (Node n : promoteToCompute) {
                        componentName = n.getNodeValue();
                        if (!componentName.equals(fstElmnt.getAttribute("name"))) continue;
                        if (fstNmElmntLstSize == 0) {
                            Element defaultService = doc.createElement("service");
                            defaultService.setAttribute("name", "DefaultService");
                            fstElmnt.appendChild(defaultService);
                            ++fstNmElmntLstSize;
                        }
                        n.setNodeValue(String.valueOf(n.getNodeValue()) + "/DefaultService");
                    }
                }
                if (fstNmElmntLstSize == 1) {
                    for (Node n : promoteToCompute) {
                        componentName = n.getNodeValue();
                        if (!componentName.equals(fstElmnt.getAttribute("name"))) continue;
                        n.setNodeValue(String.valueOf(n.getNodeValue()) + "/" + fstNmElmntLst.item(0).getAttributes().getNamedItem("name").getNodeValue());
                    }
                }
            }
            ++s;
        }
    }

    private static void computePromoteReferences(Document doc) {
        Element fstElmnt;
        Node fstNode;
        ArrayList<Node> promoteToCompute = new ArrayList<Node>();
        NodeList nodeLst = doc.getElementsByTagName("reference");
        int s = 0;
        while (s < nodeLst.getLength()) {
            Node promoteRef;
            fstNode = nodeLst.item(s);
            if (fstNode.getNodeType() == 1 && (promoteRef = (fstElmnt = (Element)fstNode).getAttributes().getNamedItem("promote")) != null) {
                String[] split = promoteRef.getNodeValue().split(" ");
                boolean found = false;
                int ii = 0;
                while (!found && ii < split.length) {
                    if (!split[ii].contains("/")) {
                        found = true;
                        promoteToCompute.add(promoteRef);
                    }
                    ++ii;
                }
            }
            ++s;
        }
        nodeLst = doc.getElementsByTagName("component");
        s = 0;
        while (s < nodeLst.getLength()) {
            fstNode = nodeLst.item(s);
            if (fstNode.getNodeType() == 1) {
                int suf;
                int pre;
                String result;
                int ii;
                String[] split;
                fstElmnt = (Element)fstNode;
                NodeList fstNmElmntLst = fstElmnt.getElementsByTagName("reference");
                int fstNmElmntLstSize = fstNmElmntLst.getLength();
                if (fstNmElmntLstSize == 0) {
                    for (Node n : promoteToCompute) {
                        split = n.getNodeValue().split(" ");
                        ii = 0;
                        while (ii < split.length) {
                            if (split[ii].equals(fstElmnt.getAttribute("name"))) {
                                if (fstNmElmntLstSize == 0) {
                                    Element defaultService = doc.createElement("reference");
                                    defaultService.setAttribute("name", "DefaultRef");
                                    fstElmnt.appendChild(defaultService);
                                    ++fstNmElmntLstSize;
                                }
                                result = "";
                                pre = 0;
                                while (pre < ii) {
                                    result = String.valueOf(result) + split[pre] + " ";
                                    ++pre;
                                }
                                result = String.valueOf(result) + " " + split[ii] + "/DefaultRef ";
                                suf = ii + 1;
                                while (suf < split.length) {
                                    result = String.valueOf(result) + split[suf] + " ";
                                    ++suf;
                                }
                                result.trim();
                                n.setNodeValue(result);
                            }
                            ++ii;
                        }
                    }
                }
                if (fstNmElmntLstSize == 1) {
                    for (Node n : promoteToCompute) {
                        split = n.getNodeValue().split(" ");
                        ii = 0;
                        while (ii < split.length) {
                            if (split[ii].equals(fstElmnt.getAttribute("name"))) {
                                result = "";
                                pre = 0;
                                while (pre < ii) {
                                    result = String.valueOf(result) + split[pre] + " ";
                                    ++pre;
                                }
                                result = String.valueOf(result) + " " + split[ii] + "/" + fstNmElmntLst.item(0).getAttributes().getNamedItem("name").getNodeValue() + " ";
                                suf = ii + 1;
                                while (suf < split.length) {
                                    result = String.valueOf(result) + split[suf] + " ";
                                    ++suf;
                                }
                                result.trim();
                                n.setNodeValue(result);
                            }
                            ++ii;
                        }
                    }
                }
            }
            ++s;
        }
    }

    private static void computeTargetReferences(Document doc) {
        int ii;
        NodeList fstNmElmntLst;
        Element fstElmnt;
        Node fstNode;
        NodeList nodeLst = doc.getElementsByTagName("component");
        ArrayList<Node> missingServices = new ArrayList<Node>();
        ArrayList<Node> missingServicesTmp = new ArrayList<Node>();
        int s = 0;
        while (s < nodeLst.getLength()) {
            fstNode = nodeLst.item(s);
            if (fstNode.getNodeType() == 1) {
                fstElmnt = (Element)fstNode;
                fstNmElmntLst = fstElmnt.getElementsByTagName("reference");
                int i = 0;
                while (i < fstNmElmntLst.getLength()) {
                    Node targetRef = fstNmElmntLst.item(i).getAttributes().getNamedItem("target");
                    if (targetRef != null && targetRef.getNodeValue() != null) {
                        String[] split = targetRef.getNodeValue().split(" ");
                        boolean found = false;
                        ii = 0;
                        while (!found && ii < split.length) {
                            if (!split[ii].contains("/")) {
                                found = true;
                                missingServices.add(targetRef);
                                missingServicesTmp.add(targetRef);
                            }
                            ++ii;
                        }
                    }
                    ++i;
                }
            }
            ++s;
        }
        s = 0;
        while (s < nodeLst.getLength()) {
            fstNode = nodeLst.item(s);
            if (fstNode.getNodeType() == 1) {
                int suf;
                int pre;
                String result;
                fstElmnt = (Element)fstNode;
                fstNmElmntLst = fstElmnt.getElementsByTagName("service");
                int fstNmElmntLstSize = fstNmElmntLst.getLength();
                if (fstNmElmntLstSize == 0) {
                    for (Node n : missingServicesTmp) {
                        String[] split = n.getNodeValue().split(" ");
                        ii = 0;
                        while (ii < split.length) {
                            if (split[ii].equals(fstElmnt.getAttribute("name"))) {
                                if (fstNmElmntLstSize == 0) {
                                    Element defaultService = doc.createElement("service");
                                    defaultService.setAttribute("name", "DefaultService");
                                    fstElmnt.appendChild(defaultService);
                                    ++fstNmElmntLstSize;
                                }
                                result = "";
                                pre = 0;
                                while (pre < ii) {
                                    result = String.valueOf(result) + split[pre] + " ";
                                    ++pre;
                                }
                                result = String.valueOf(result) + " " + split[ii] + "/DefaultService ";
                                suf = ii + 1;
                                while (suf < split.length) {
                                    result = String.valueOf(result) + split[suf] + " ";
                                    ++suf;
                                }
                                result.trim();
                                n.setNodeValue(result);
                            }
                            ++ii;
                        }
                    }
                }
                if (fstNmElmntLstSize == 1) {
                    for (Node n : missingServicesTmp) {
                        String[] split = n.getNodeValue().split(" ");
                        ii = 0;
                        while (ii < split.length) {
                            if (split[ii].equals(fstElmnt.getAttribute("name"))) {
                                result = "";
                                pre = 0;
                                while (pre < ii) {
                                    result = String.valueOf(result) + split[pre] + " ";
                                    ++pre;
                                }
                                result = String.valueOf(result) + " " + split[ii] + "/" + fstNmElmntLst.item(0).getAttributes().getNamedItem("name").getNodeValue() + " ";
                                suf = ii + 1;
                                while (suf < split.length) {
                                    result = String.valueOf(result) + split[suf] + " ";
                                    ++suf;
                                }
                                result.trim();
                                n.setNodeValue(result);
                            }
                            ++ii;
                        }
                    }
                }
            }
            ++s;
        }
    }
}

