/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.deployment.launch;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.common.java.utils.JDTUtils;
import org.eclipse.stp.sca.deployment.Messages;
import org.eclipse.stp.sca.deployment.ScaDeploymentPlugin;
import org.eclipse.stp.sca.deployment.Utils;
import org.eclipse.stp.sca.deployment.preferences.ScaMasterLaunchConfigDesc;
import org.eclipse.stp.sca.deployment.preferences.ScaRuntimePreferencePage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ScaLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        try {
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                Object o = ((IStructuredSelection)selection).getFirstElement();
                IFile compositeFile = (IFile)o;
                List<String> configurations = ScaRuntimePreferencePage.getMasterLaunchConfigurationNames();
                if (configurations.size() == 0) {
                    PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)new Shell(), (String)"org.eclipse.stp.sca.deployment.runDebug", null, null);
                    dlg.open();
                    return;
                }
                String selectedMasterConfiguration = null;
                if (configurations.size() == 1) {
                    selectedMasterConfiguration = configurations.get(0);
                } else {
                    ElementListSelectionDialog dlg = new ElementListSelectionDialog(new Shell(), (ILabelProvider)new LabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ILaunchConfiguration) {
                                return ((ILaunchConfiguration)element).getName();
                            }
                            return super.getText(element);
                        }
                    });
                    dlg.setElements(configurations.toArray());
                    dlg.setIgnoreCase(true);
                    dlg.setMessage(Messages.ScaLaunchShortcut_1);
                    dlg.setTitle(Messages.ScaLaunchShortcut_2);
                    dlg.setMultipleSelection(false);
                    if (dlg.open() == 0) {
                        selectedMasterConfiguration = (String)dlg.getResult()[0];
                    } else {
                        return;
                    }
                }
                ILaunchConfiguration launchConfig = this.getLaunchWorkingCopy(compositeFile, selectedMasterConfiguration);
                if (launchConfig == null) {
                    return;
                }
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                monitor.beginTask(Messages.ScaLaunchShortcut_3, 100);
                                launchConfig.launch(mode, monitor);
                                monitor.done();
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ILaunchConfiguration getLaunchWorkingCopy(IFile compositeFile, String selectedMasterConfiguration) throws CoreException {
        String launchName = Utils.createScaLaunchConfigurationName(compositeFile, selectedMasterConfiguration);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.stp.sca.deployment.scaLaunchConfiguration");
        ILaunchConfiguration config = null;
        ILaunchConfiguration[] iLaunchConfigurationArray = launchManager.getLaunchConfigurations(launchConfigurationType);
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration c = iLaunchConfigurationArray[n2];
            if (c.getName().equals(launchName)) {
                config = c;
                break;
            }
            ++n2;
        }
        if (config == null) {
            ScaMasterLaunchConfigDesc desc = ScaRuntimePreferencePage.getMasterLaunchConfiguration(selectedMasterConfiguration);
            if (desc == null) {
                Status status = new Status(4, "org.eclipse.stp.sca.deployment", NLS.bind((String)Messages.ScaLaunchShortcut_4, (Object)compositeFile.getProjectRelativePath()));
                ScaDeploymentPlugin.getDefault().getLog().log((IStatus)status);
                MessageDialog.openError((Shell)new Shell(), (String)Messages.ScaLaunchShortcut_6, (String)Messages.ScaLaunchShortcut_7);
                return null;
            }
            ILaunchConfigurationWorkingCopy newConfig = launchConfigurationType.newInstance(null, launchName);
            newConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, compositeFile.getProject().getName());
            newConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, desc.getMainClass());
            newConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            String args = this.replaceScaVariablesInArguments(desc.getProgramArguments(), compositeFile);
            newConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
            ArrayList<String> classpath = new ArrayList<String>();
            for (String path : desc.getClasspath()) {
                IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(path));
                entry.setClasspathProperty(3);
                classpath.add(entry.getMemento());
            }
            Path systemLibsPath = new Path(JavaRuntime.JRE_CONTAINER);
            IRuntimeClasspathEntry systemLibsEntry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)systemLibsPath, (int)1);
            classpath.add(systemLibsEntry.getMemento());
            IJavaProject jp = JDTUtils.getJavaProject((IProject)compositeFile.getProject());
            if (jp != null) {
                IRuntimeClasspathEntry entry = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)jp);
                entry.setClasspathProperty(3);
                classpath.add(entry.getMemento());
            }
            newConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
            newConfig.doSave();
            config = newConfig;
        }
        return config;
    }

    public void launch(IEditorPart editor, String mode) {
    }

    public String replaceScaVariablesInArguments(String args, IFile compositeFile) {
        if (args == null) {
            return null;
        }
        args = args.replaceAll(Pattern.quote("${composite_path}"), compositeFile.getLocation().toString());
        args = args.replaceAll(Pattern.quote("${composite_name}"), compositeFile.getName());
        return args;
    }
}

