/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.extension.edit.part;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.ui.services.icon.GetIconOperation;
import org.eclipse.gmf.runtime.common.ui.services.icon.IIconProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.stp.sca.diagram.extension.edit.part.ElementInformation;
import org.eclipse.stp.sca.diagram.extension.edit.part.ElementInformationRegistry;
import org.eclipse.stp.sca.diagram.extension.edit.part.ElementType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ElementIconProvider
extends AbstractProvider
implements IIconProvider {
    private static ImageRegistry imageRegistry;
    private ElementType type = null;

    public ElementIconProvider(ElementType type) {
        this.type = type;
    }

    public Image getIcon(IAdaptable hint, int flags) {
        IElementType type = (IElementType)hint.getAdapter(IElementType.class);
        if (type != null) {
            for (ElementInformation elementInformation : ElementInformationRegistry.getInstance().getAllElementInformations(this.type)) {
                if (!elementInformation.isKnownElementType(type)) continue;
                return ElementIconProvider.getImage(elementInformation.getIconPath());
            }
        }
        return null;
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof GetIconOperation) {
            return ((GetIconOperation)operation).execute((IProvider)this) != null;
        }
        return false;
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static Image getImage(String iconPath) {
        Image image = ElementIconProvider.getImageRegistry().get(iconPath);
        if (image == null) {
            ImageDescriptor imageDescriptor = null;
            Path p = new Path(iconPath);
            if (p.isAbsolute() && p.segmentCount() > 1) {
                imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(0), (String)p.removeFirstSegments(1).makeAbsolute().toString());
            }
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            ElementIconProvider.getImageRegistry().put(iconPath, imageDescriptor);
            image = ElementIconProvider.getImageRegistry().get(iconPath);
        }
        return image;
    }
}

