/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.compositeshell;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.sca.common.utils.CompositeShellGenerator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class CompositeShellWizard
extends Wizard
implements INewWizard {
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("composite".split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = "composite".replaceAll("\\s*,\\s*", ", ");
    protected SCACompositeShellModelWizardNewFileCreationPage newFileCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("Create a new SCA Composite Shell");
    }

    public boolean performFinish() {
        IFile destFile;
        block6: {
            try {
                final IFile initialFile = (IFile)this.selection.getFirstElement();
                destFile = this.getModelFile();
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor progressMonitor) {
                        try {
                            try {
                                CompositeShellGenerator generator = new CompositeShellGenerator(initialFile, destFile);
                                generator.createCompositeShell();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                progressMonitor.done();
                            }
                        }
                        finally {
                            progressMonitor.done();
                        }
                    }
                };
                this.getContainer().run(false, false, (IRunnableWithProgress)operation);
                if (destFile.getLocation().toFile().exists()) break block6;
                MessageDialog.openError((Shell)this.getShell(), (String)"Generation Error", (String)"The initial composite file is invalid. The generation could not be performed.");
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)destFile);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        try {
            page.openEditor((IEditorInput)new FileEditorInput(destFile), this.workbench.getEditorRegistry().getDefaultEditor(destFile.getFullPath().toString()).getId());
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"_UI_OpenEditorError_label", (String)exception.getMessage());
            return false;
        }
        return true;
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new SCACompositeShellModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle("New SCA Composite Shell");
        this.newFileCreationPage.setDescription("Create a new SCA composite shell.");
        this.newFileCreationPage.setFileName("defaultFileName." + FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = "defaultFileName";
                String defaultModelFilenameExtension = FILE_EXTENSIONS.get(0);
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public class SCACompositeShellModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public SCACompositeShellModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                    this.setErrorMessage("The file name must end in \".composite\"");
                    return false;
                }
                return true;
            }
            return false;
        }

        private IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

