/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.edit.parts;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.sca.Property;
import org.eclipse.stp.sca.diagram.common.figures.FigureUtils;
import org.eclipse.stp.sca.diagram.common.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.stp.sca.diagram.edit.parts.PropertyNameEditPart;
import org.eclipse.stp.sca.diagram.edit.policies.PropertyItemSemanticEditPolicy;
import org.eclipse.stp.sca.diagram.part.ScaVisualIDRegistry;
import org.eclipse.swt.graphics.Color;

public class PropertyEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 3011;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    static final Color THIS_FORE = new Color(null, 102, 102, 102);
    static final Color THIS_BACK = new Color(null, 255, 255, 0);

    public PropertyEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new PropertyItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        PropertyFigure figure = new PropertyFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public PropertyFigure getPrimaryShape() {
        return (PropertyFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof PropertyNameEditPart) {
            ((PropertyNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigurePropertyNameFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return super.getContentPaneFor(editPart);
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(25), this.getMapMode().DPtoLP(20));
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(ScaVisualIDRegistry.getType(5003));
    }

    public class PropertyFigure
    extends RectangleFigure {
        private WrapLabel fFigurePropertyNameFigure;
        private boolean myUseLocalCoordinates = false;

        public PropertyFigure() {
            this.setForegroundColor(THIS_FORE);
            this.setBackgroundColor(THIS_BACK);
            this.setPreferredSize(new Dimension(PropertyEditPart.this.getMapMode().DPtoLP(25), PropertyEditPart.this.getMapMode().DPtoLP(20)));
            this.setMaximumSize(new Dimension(PropertyEditPart.this.getMapMode().DPtoLP(25), PropertyEditPart.this.getMapMode().DPtoLP(20)));
            this.setMinimumSize(new Dimension(PropertyEditPart.this.getMapMode().DPtoLP(25), PropertyEditPart.this.getMapMode().DPtoLP(20)));
            this.createContents();
        }

        public IFigure getToolTip() {
            String l = "???";
            Property property = (Property)PropertyEditPart.this.resolveSemanticElement();
            if (property != null) {
                l = property.getName();
            }
            Label toolTip = new Label(" " + l + " ");
            return toolTip;
        }

        private void createContents() {
            this.setOutline(false);
            this.fFigurePropertyNameFigure = new WrapLabel();
            this.fFigurePropertyNameFigure.setText("");
            this.add((IFigure)this.fFigurePropertyNameFigure);
        }

        public WrapLabel getFigurePropertyNameFigure() {
            return this.fFigurePropertyNameFigure;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        protected void fillShape(Graphics graphics) {
            FigureUtils.setBGPattern((Graphics)graphics, (Color)this.getBackgroundColor(), (Rectangle)this.getBounds());
            graphics.fillRectangle(this.getBounds());
        }
    }
}

