/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.providers;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.AbstractContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.stp.sca.diagram.part.ScaDiagramEditorPlugin;
import org.eclipse.stp.sca.diagram.part.ScaVisualIDRegistry;
import org.eclipse.stp.sca.diagram.part.ValidateAction;

public class ScaValidationProvider
extends AbstractContributionItemProvider {
    private static boolean constraintsActive = false;

    public static boolean shouldConstraintsBePrivate() {
        return false;
    }

    public static void runWithConstraints(TransactionalEditingDomain editingDomain, Runnable operation) {
        final Runnable op = operation;
        Runnable task = new Runnable(){

            public void run() {
                try {
                    constraintsActive = true;
                    op.run();
                }
                finally {
                    constraintsActive = false;
                }
            }
        };
        if (editingDomain != null) {
            try {
                editingDomain.runExclusive(task);
            }
            catch (Exception e) {
                ScaDiagramEditorPlugin.getInstance().logError("Validation failed", e);
            }
        } else {
            task.run();
        }
    }

    protected IAction createAction(String actionId, IWorkbenchPartDescriptor partDescriptor) {
        if ("validateAction".equals(actionId)) {
            return new ValidateAction(partDescriptor);
        }
        return super.createAction(actionId, partDescriptor);
    }

    static boolean isInDefaultEditorContext(Object object) {
        if (ScaValidationProvider.shouldConstraintsBePrivate() && !constraintsActive) {
            return false;
        }
        if (object instanceof View) {
            return constraintsActive && "Sca".equals(ScaVisualIDRegistry.getModelID((View)object));
        }
        return true;
    }
}

