/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.introspection.ui;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.ScaPackage;
import org.eclipse.stp.sca.common.java.classloader.ScaJdtClassLoader;
import org.eclipse.stp.sca.introspection.ComponentTypeResolver;
import org.eclipse.stp.sca.introspection.JavaInterfaceResolver;
import org.eclipse.stp.sca.introspection.PromoteResolver;
import org.eclipse.stp.sca.introspection.ReferenceResolver;
import org.eclipse.stp.sca.introspection.ui.IntrospectionUIPlugin;
import org.eclipse.stp.sca.introspection.ui.Messages;
import org.eclipse.stp.sca.util.ScaResourceFactoryImpl;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class IntrospectionAction
implements IObjectActionDelegate {
    private IFile compositeFile;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IJavaProject javaProject = this.getAssociatedJavaProject();
        if (javaProject == null) {
            return;
        }
        ScaJdtClassLoader scaJdtClassLoader = new ScaJdtClassLoader(javaProject, this.getClass().getClassLoader());
        Resource resource = this.getEMFResource();
        if (resource == null) {
            return;
        }
        Composite composite = ((DocumentRoot)resource.getContents().get(0)).getComposite();
        JavaInterfaceResolver javaInterfaceResolver = new JavaInterfaceResolver((ClassLoader)scaJdtClassLoader);
        composite = javaInterfaceResolver.resolve(composite);
        ComponentTypeResolver componentTypeResolver = new ComponentTypeResolver(this.compositeFile.getProject());
        composite = componentTypeResolver.resolve(composite);
        ReferenceResolver referenceResolver = new ReferenceResolver((ClassLoader)scaJdtClassLoader);
        composite = referenceResolver.resolve(composite);
        PromoteResolver promoteResolver = new PromoteResolver();
        composite = promoteResolver.resolve(composite);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.stp.sca.introspection.ui", e.getMessage(), (Throwable)e);
            IntrospectionUIPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private Resource getEMFResource() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ScaResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.osoa.org/xmlns/sca/1.0", (Object)ScaPackage.eINSTANCE);
        Resource resource = null;
        try {
            URI uri = URI.createPlatformResourceURI((String)this.compositeFile.getFullPath().toString(), (boolean)true);
            resource = resourceSet.getResource(uri, true);
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "org.eclipse.stp.sca.introspection.ui", String.valueOf(Messages.IntrospectionAction_0) + this.compositeFile.getLocationURI(), (Throwable)e);
            IntrospectionUIPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
        return resource;
    }

    private IJavaProject getAssociatedJavaProject() {
        IProject project = this.compositeFile.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            String msg = String.valueOf(Messages.IntrospectionAction_1) + this.compositeFile.getName();
            Status status = new Status(4, "org.eclipse.stp.sca.introspection.ui", msg);
            IntrospectionUIPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
        return javaProject;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        if (!(((IStructuredSelection)selection).getFirstElement() instanceof IFile)) {
            return;
        }
        this.compositeFile = (IFile)((IStructuredSelection)selection).getFirstElement();
        action.setEnabled(true);
    }
}

