/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.eclipse.stp.ui.xef.schema.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaValueType {
    private final XSSimpleTypeDefinition ctx;
    private List<String> allowedValues;

    SchemaValueType(XSSimpleTypeDefinition typeDefinition) {
        this.ctx = typeDefinition;
    }

    public ValueType getType() {
        switch (this.ctx.getBuiltInKind()) {
            case 2: {
                StringList enumeration = this.ctx.getLexicalEnumeration();
                if (enumeration.getLength() > 0) {
                    this.readAllowedValues(enumeration);
                    return ValueType.ENUMERATION;
                }
                return ValueType.STRING;
            }
            case 4: 
            case 5: 
            case 6: {
                return ValueType.FLOATING_POINT;
            }
            case 30: {
                return ValueType.INTEGER;
            }
            case 34: {
                return ValueType.INT;
            }
            case 33: {
                return ValueType.LONG;
            }
            case 35: {
                return ValueType.SHORT;
            }
            case 36: {
                return ValueType.BYTE;
            }
            case 38: {
                return ValueType.ULONG;
            }
            case 39: {
                return ValueType.UINT;
            }
            case 40: {
                return ValueType.USHORT;
            }
            case 41: {
                return ValueType.UBYTE;
            }
            case 32: {
                return ValueType.NEGATIVE_INTEGER;
            }
            case 42: {
                return ValueType.POSITIVE_INTEGER;
            }
            case 37: {
                return ValueType.NON_NEGATIVE_INTEGER;
            }
            case 31: {
                return ValueType.NON_POSITIVE_INTEGER;
            }
            case 3: {
                return ValueType.BOOLEAN;
            }
            case 26: {
                return ValueType.NCNAME;
            }
            case 19: {
                return ValueType.QNAME;
            }
        }
        return ValueType.STRING;
    }

    private synchronized void readAllowedValues(StringList enumeration) {
        this.allowedValues = new ArrayList<String>(enumeration.getLength());
        int i = 0;
        while (i < enumeration.getLength()) {
            this.allowedValues.add(enumeration.item(i));
            ++i;
        }
        this.allowedValues = this.allowedValues.size() == 0 ? null : Collections.unmodifiableList(this.allowedValues);
    }

    public List<String> getAllowedValues() {
        if (this.allowedValues == null) {
            this.readAllowedValues(this.ctx.getLexicalEnumeration());
        }
        return this.allowedValues;
    }
}

