/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.stp.ui.xef.schema.SchemaRegistry;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.ISchemaProviderExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtSchemaProviderDelegate
implements ISchemaProviderExt {
    private ISchemaProvider schemaProvider;
    private Map<String, Collection<String>> cache = new HashMap<String, Collection<String>>();

    public ExtSchemaProviderDelegate(ISchemaProvider sp) {
        this.schemaProvider = sp;
    }

    public Collection<String> listElements(String namespace) {
        Collection<String> cached = this.cache.get(namespace);
        if (cached != null) {
            return cached;
        }
        try {
            String xml = this.getSchema(namespace);
            List<String> els = xml == null ? Collections.emptyList() : SchemaRegistry.getEntryElementsFromXML(xml, namespace, this.schemaProvider);
            this.cache.put(namespace, els);
            return els;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getSchema(String namespace) {
        return this.schemaProvider.getSchema(namespace);
    }

    public String getSnippet(String name) {
        return this.schemaProvider.getSnippet(name);
    }

    public Collection<String> listSchemaNamespaces(String filter) {
        return this.schemaProvider.listSchemaNamespaces(filter);
    }

    public Collection<String> listSnippets(String filter) {
        return this.schemaProvider.listSnippets(filter);
    }

    public void refresh() {
        this.cache.clear();
        this.schemaProvider.refresh();
    }
}

