/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class JavaHLMergeOperation
extends AbstractFileOperation {
    protected IRepositoryResource from1;
    protected IRepositoryResource from2;
    protected boolean dryRun;
    protected ISVNNotificationCallback notify;

    public JavaHLMergeOperation(File localTo, IRepositoryResource from1, IRepositoryResource from2, boolean dryRun, ISVNNotificationCallback notify) {
        super("Operation_JavaHLMergeFile", SVNMessages.class, new File[]{localTo});
        this.from1 = from1;
        this.from2 = from2;
        this.dryRun = dryRun;
        this.notify = notify;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File file = this.operableData()[0];
        IRepositoryLocation location = this.from1.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        proxy.setTouchUnresolved(true);
        if (this.notify != null) {
            SVNUtility.addSVNNotifyListener(proxy, this.notify);
        }
        try {
            proxy.merge(SVNUtility.getEntryRevisionReference(this.from1), SVNUtility.getEntryRevisionReference(this.from2), file.getAbsolutePath(), 3, this.dryRun ? 1024L : 0L, (ISVNProgressMonitor)new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            if (this.notify != null) {
                SVNUtility.removeSVNNotifyListener(proxy, this.notify);
            }
            proxy.setTouchUnresolved(false);
            location.releaseSVNProxy(proxy);
        }
    }
}

