/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class BranchTagOperation
extends AbstractWorkingCopyOperation {
    protected IRepositoryResource destination;
    protected String message;

    public BranchTagOperation(String operationName, IResource[] resources, IRepositoryResource destination, String message) {
        super("Operation_" + operationName, SVNMessages.class, resources);
        this.destination = destination;
        this.message = message;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        Object[] resources = this.operableData();
        ProgressMonitorUtility.setTaskInfo(monitor, this, FileUtility.getNamesListAsString(resources));
        IRepositoryLocation location = this.destination.getRepositoryLocation();
        final ISVNConnector proxy = location.acquireSVNProxy();
        try {
            final String destinationUrl = SVNUtility.encodeURL(this.destination.getUrl());
            int i = 0;
            while (i < resources.length) {
                final String wcPath = FileUtility.getWorkingCopyPath((IResource)resources[i]);
                ISVNNotificationCallback notify = new ISVNNotificationCallback(){

                    public void notify(SVNNotification info) {
                        if (info.revision != -1L) {
                            String message = SVNMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(info.revision)});
                            BranchTagOperation.this.writeToConsole(1, message);
                        }
                    }
                };
                SVNUtility.addSVNNotifyListener(proxy, notify);
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        BranchTagOperation.this.writeToConsole(0, "svn copy \"" + wcPath + "\" \"" + destinationUrl + "\" -r " + SVNRevision.WORKING + " -m \"" + BranchTagOperation.this.message + "\"" + FileUtility.getUsernameParam(BranchTagOperation.this.destination.getRepositoryLocation().getUsername()) + "\n");
                        SVNEntryRevisionReference[] src = new SVNEntryRevisionReference[]{new SVNEntryRevisionReference(wcPath, SVNRevision.WORKING, SVNRevision.WORKING)};
                        proxy.copy(src, destinationUrl, BranchTagOperation.this.message, 8L, null, new SVNProgressMonitor(BranchTagOperation.this, monitor, null));
                    }
                }, monitor, resources.length);
                SVNUtility.removeSVNNotifyListener(proxy, notify);
                ++i;
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }
}

