/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.synchronize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.local.IRemoteStatusOperation;
import org.eclipse.team.svn.core.operation.local.RemoteStatusOperation;
import org.eclipse.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.eclipse.team.svn.core.resource.IChangeStateProvider;
import org.eclipse.team.svn.core.resource.ICommentProvider;
import org.eclipse.team.svn.core.resource.IFileChange;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSubscriber;
import org.eclipse.team.svn.core.synchronize.UpdateSyncInfo;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class UpdateSubscriber
extends AbstractSVNSubscriber {
    private static UpdateSubscriber instance = null;
    protected Map<SVNRevision, String> comments = new HashMap<SVNRevision, String>();

    public static synchronized UpdateSubscriber instance() {
        if (instance == null) {
            instance = new UpdateSubscriber();
        }
        return instance;
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        this.comments.clear();
        super.refresh(resources, depth, monitor);
    }

    protected IRemoteStatusOperation addStatusOperation(CompositeOperation op, IResource[] resources, int depth) {
        RemoteStatusOperation rStatus = new RemoteStatusOperation(resources);
        op.add(rStatus);
        return rStatus;
    }

    protected SyncInfo getSVNSyncInfo(ILocalResource localStatus, IResourceChange remoteStatus) {
        return new UpdateSyncInfo(localStatus, remoteStatus, this.getResourceComparator());
    }

    protected IResourceChange handleResourceChange(IRemoteStatusOperation rStatusOp, SVNEntryStatus status) {
        final SVNChangeStatus current = (SVNChangeStatus)status;
        if (current.textStatus == 13) {
            return null;
        }
        final IResource[] scope = rStatusOp.getScope();
        IChangeStateProvider provider = new IChangeStateProvider(){

            public long getChangeDate() {
                return current.reposLastCmtRevision == -1L ? current.lastChangedDate : current.reposLastCmtDate;
            }

            public String getChangeAuthor() {
                return current.reposLastCmtRevision == -1L ? current.lastCommitAuthor : current.reposLastCmtAuthor;
            }

            public SVNRevision.Number getChangeRevision() {
                long changeRev = current.reposLastCmtRevision == -1L ? current.lastChangedRevision : current.reposLastCmtRevision;
                return changeRev == -1L ? null : SVNRevision.fromNumber(changeRev);
            }

            public int getTextChangeType() {
                return current.repositoryTextStatus;
            }

            public int getPropertiesChangeType() {
                return current.repositoryPropStatus;
            }

            public int getNodeKind() {
                int kind = SVNUtility.getNodeKind(current.path, current.nodeKind, true);
                return kind == 0 ? SVNUtility.getNodeKind(current.path, current.reposKind, true) : kind;
            }

            public String getLocalPath() {
                return current.path;
            }

            public String getComment() {
                return null;
            }

            public boolean isCopied() {
                return current.isCopied;
            }

            public boolean isSwitched() {
                return current.isSwitched;
            }

            public IResource getExact(IResource[] set) {
                return FileUtility.selectOneOf(scope, set);
            }

            public SVNConflictDescriptor getTreeConflictDescriptor() {
                return current.treeConflictDescriptor;
            }

            public boolean hasTreeConflict() {
                return current.hasTreeConflict;
            }
        };
        if (provider.getNodeKind() == 0) {
            return null;
        }
        IResourceChange resourceChange = SVNRemoteStorage.instance().asResourceChange(provider, true);
        if (resourceChange == null || resourceChange.getRevision() == -1L) {
            return null;
        }
        IResourceChange checkForReplacement = null;
        try {
            checkForReplacement = SVNRemoteStorage.instance().resourceChangeFromBytes(this.statusCache.getBytes(resourceChange.getResource()));
        }
        catch (TeamException e) {
            LoggedOperation.reportError(this.getClass().getName(), e);
        }
        if (checkForReplacement != null) {
            if (IStateFilter.SF_ADDED.accept(checkForReplacement)) {
                if (IStateFilter.SF_DELETED.accept(resourceChange)) {
                    checkForReplacement.treatAsReplacement();
                }
                return checkForReplacement;
            }
            if (IStateFilter.SF_DELETED.accept(checkForReplacement) && IStateFilter.SF_ADDED.accept(resourceChange)) {
                resourceChange.treatAsReplacement();
            }
        }
        rStatusOp.setPegRevision(resourceChange);
        IRepositoryResource originator = SVNRemoteStorage.instance().asRepositoryResource(resourceChange.getResource());
        if (originator != null) {
            IRepositoryResource tOriginator;
            String url = SVNUtility.decodeURL(current.url);
            IRepositoryResource iRepositoryResource = tOriginator = resourceChange instanceof IFileChange ? originator.asRepositoryFile(url, true) : originator.asRepositoryContainer(url, true);
            if (tOriginator != null) {
                originator = tOriginator;
            }
            originator.setSelectedRevision(SVNRevision.fromNumber(resourceChange.getRevision()));
            originator.setPegRevision(resourceChange.getPegRevision());
            resourceChange.setOriginator(originator);
        }
        resourceChange.setCommentProvider(new ICommentProvider(){

            public String getComment(IResource resource, SVNRevision rev, SVNRevision peg) {
                if (!UpdateSubscriber.this.comments.containsKey(rev)) {
                    this.cacheComments(resource, rev, peg);
                }
                return UpdateSubscriber.this.comments.get(rev);
            }

            public void cacheComments(IResource resource, SVNRevision rev, SVNRevision peg) {
                if (rev == SVNRevision.INVALID_REVISION || peg != null && peg == SVNRevision.INVALID_REVISION) {
                    return;
                }
                IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resource).getRoot();
                remote.setSelectedRevision(rev);
                remote.setPegRevision(peg);
                GetLogMessagesOperation op = new GetLogMessagesOperation(remote);
                op.setLimit(20L);
                op.setDiscoverPaths(false);
                ProgressMonitorUtility.doTaskExternalDefault(op, (IProgressMonitor)new NullProgressMonitor());
                if (op.getExecutionState() == 0) {
                    SVNLogEntry[] sVNLogEntryArray = op.getMessages();
                    int n = sVNLogEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SVNLogEntry entry = sVNLogEntryArray[n2];
                        UpdateSubscriber.this.comments.put(SVNRevision.fromNumber(entry.revision), entry.message);
                        ++n2;
                    }
                }
            }
        });
        return resourceChange;
    }

    protected boolean isIncoming(SVNEntryStatus status) {
        SVNChangeStatus st = (SVNChangeStatus)status;
        return st.repositoryPropStatus == 2 || st.repositoryTextStatus != 0 || st.hasTreeConflict;
    }

    public int getState(ResourceMapping mapping, int stateMask, IProgressMonitor monitor) throws CoreException {
        if ((stateMask & 0x200) == 0) {
            ResourceTraversal[] traversals = mapping.getTraversals((ResourceMappingContext)new SubscriberResourceMappingContext((Subscriber)this, false), monitor);
            final int[] direction = new int[1];
            final int[] kind = new int[1];
            this.accept(traversals, new IDiffVisitor(){

                public boolean visit(IDiff diff) {
                    if (diff instanceof IThreeWayDiff) {
                        IThreeWayDiff twd = (IThreeWayDiff)diff;
                        direction[0] = direction[0] | twd.getDirection();
                    }
                    int diffKind = diff.getKind();
                    if (kind[0] == 0) {
                        kind[0] = diffKind;
                    }
                    if (kind[0] != diffKind) {
                        kind[0] = 4;
                    }
                    return diffKind == 4;
                }
            });
            return (direction[0] | kind[0]) & stateMask;
        }
        return super.getState(mapping, stateMask, monitor);
    }

    private UpdateSubscriber() {
        super(true, SVNMessages.UpdateSubscriber_Name);
    }
}

