/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNConnectorCancelException;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNLogEntryCallbackWithMergeInfo;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.ActivityCancelledException;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.operation.RepositoryConnectionInfo;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class CheckRepositoryConnectionOperation
extends AbstractActionOperation
implements RepositoryConnectionInfo.IRepositoryConnectionInfoProvider {
    protected IRepositoryResource resource;
    protected boolean canIncludeMergeInfo;
    protected boolean isValidateMergeInfo;
    protected boolean hasConnection;
    protected long lastRepositoryRevision;
    protected boolean isServerSupportsMergeInfo;

    public CheckRepositoryConnectionOperation(IRepositoryResource resource, boolean canIncludeMergeInfo, boolean isValidateMergeInfo) {
        super("Operation_CheckRepositoryConnection", SVNRevisionGraphMessages.class);
        this.resource = resource;
        this.canIncludeMergeInfo = canIncludeMergeInfo;
        this.isValidateMergeInfo = isValidateMergeInfo;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.isServerSupportsMergeInfo = this.canIncludeMergeInfo;
        IRepositoryRoot root = this.resource.getRepositoryLocation().getRepositoryRoot();
        try {
            this.lastRepositoryRevision = root.getRevision();
            this.hasConnection = this.lastRepositoryRevision != -1L;
        }
        catch (SVNConnectorException e) {
            if (e instanceof SVNConnectorCancelException) {
                throw e;
            }
            this.hasConnection = false;
        }
        if (!this.hasConnection) {
            final boolean[] isProceedWithoutConnection = new boolean[1];
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dlg = new MessageDialog(UIMonitorUtility.getShell(), SVNRevisionGraphMessages.Dialog_GraphTitle, null, SVNRevisionGraphMessages.CheckRepositoryConnectionOperation_DialogMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    isProceedWithoutConnection[0] = dlg.open() == 0;
                }
            });
            if (!isProceedWithoutConnection[0]) {
                throw new ActivityCancelledException();
            }
        } else if (this.isValidateMergeInfo && this.canIncludeMergeInfo) {
            this.checkMergeInfo(monitor);
        }
    }

    protected void checkMergeInfo(IProgressMonitor monitor) {
        block6: {
            IRepositoryLocation location = this.resource.getRepositoryLocation();
            ISVNConnector proxy = location.acquireSVNProxy();
            try {
                try {
                    proxy.logEntries(SVNUtility.getEntryReference((IRepositoryResource)location.getRepositoryRoot()), new SVNRevisionRange[]{new SVNRevisionRange(this.lastRepositoryRevision, this.lastRepositoryRevision)}, new String[0], 1L, 524288L, (ISVNLogEntryCallback)new SVNLogEntryCallbackWithMergeInfo(), (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null));
                    this.isServerSupportsMergeInfo = true;
                }
                catch (SVNConnectorException sVNConnectorException) {
                    this.isServerSupportsMergeInfo = false;
                    location.releaseSVNProxy(proxy);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                location.releaseSVNProxy(proxy);
                throw throwable;
            }
            location.releaseSVNProxy(proxy);
        }
        if (!this.isServerSupportsMergeInfo) {
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dlg = new MessageDialog(UIMonitorUtility.getShell(), SVNRevisionGraphMessages.Dialog_GraphTitle, null, SVNRevisionGraphMessages.CheckRepositoryConnectionOperation_MergeNotSupported, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    dlg.open();
                }
            });
        }
    }

    public RepositoryConnectionInfo getRepositoryConnectionInfo() {
        return new RepositoryConnectionInfo(this.hasConnection, this.lastRepositoryRevision, this.isServerSupportsMergeInfo);
    }
}

