/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.history.data.AffectedPathsNode;
import org.eclipse.team.svn.ui.history.data.SVNChangedPathData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AffectedPathsContentProvider
implements ITreeContentProvider {
    protected AffectedPathsNode root;

    public void initialize(SVNChangedPathData[] affectedPaths, Collection<String> relatedPathPrefixes, Collection<String> relatedParents, long currentRevision) {
        this.root = new AffectedPathsNode(SVNUIMessages.AffectedPathsContentProvider_RootName, null, '\u0000');
        if (affectedPaths == null) {
            return;
        }
        int i = 0;
        while (i < affectedPaths.length) {
            SVNChangedPathData row = affectedPaths[i];
            this.processPath(row, relatedPathPrefixes, relatedParents);
            ++i;
        }
        for (AffectedPathsNode node : this.root.getChildren()) {
            this.doCompress(node);
        }
    }

    public boolean hasChildren(Object element) {
        AffectedPathsNode node = (AffectedPathsNode)element;
        return node.hasChildren();
    }

    public Object[] getChildren(Object parentElement) {
        AffectedPathsNode parentNode = (AffectedPathsNode)parentElement;
        return parentNode.getChildren().toArray(new AffectedPathsNode[parentNode.getChildren().size()]);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object getParent(Object element) {
        return ((AffectedPathsNode)element).getParent();
    }

    public Object[] getElements(Object inputElement) {
        return new Object[]{this.root};
    }

    public AffectedPathsNode getRoot() {
        return this.root;
    }

    protected void processPath(SVNChangedPathData affectedPath, Collection<String> relatedPathPrefixes, Collection<String> relatedParents) {
        String fullResourcePath = affectedPath.getFullResourcePath();
        if (!this.isRelatedPath(fullResourcePath, relatedPathPrefixes) && !this.isRelatedParent(fullResourcePath, relatedParents)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(fullResourcePath, "/");
        AffectedPathsNode node = null;
        AffectedPathsNode parent = this.root;
        AffectedPathsNode nextToLast = this.root;
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            node = this.findByName(parent, name);
            if (node == null) {
                node = new AffectedPathsNode(name, parent, name.equals(affectedPath.resourceName) ? affectedPath.action : (char)'\u0000');
                parent.addChild(node);
            } else if (!st.hasMoreTokens()) {
                node.setStatus(affectedPath.action);
            }
            nextToLast = parent;
            parent = node;
        }
        nextToLast.addData(affectedPath);
        if (!(node == null || node.getChildren() != null && node.getChildren().size() != 0 || node.getPathData() != null && node.getPathData().length != 0)) {
            nextToLast.removeChild(node);
        }
    }

    protected AffectedPathsNode findByName(AffectedPathsNode parent, String name) {
        for (AffectedPathsNode node : parent.getChildren()) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    protected boolean isRelatedParent(String fullPath, Collection<String> relatedParents) {
        return relatedParents == null || relatedParents.contains(fullPath);
    }

    protected boolean isRelatedPath(String fullPath, Collection<String> relatedPathPrefixes) {
        if (relatedPathPrefixes == null) {
            return true;
        }
        for (String prefix : relatedPathPrefixes) {
            if (!fullPath.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected void doCompress(AffectedPathsNode node) {
        List<AffectedPathsNode> children = node.getChildren();
        if (children.size() > 1) {
            for (AffectedPathsNode tNode : children) {
                this.doCompress(tNode);
            }
        } else if (children.size() == 1) {
            AffectedPathsNode child = children.get(0);
            if (node.getData().length > 0) {
                this.doCompress(child);
            } else {
                node.addCompressedNameSegment(child.getName());
                List<AffectedPathsNode> lowerChildren = child.getChildren();
                for (AffectedPathsNode tNode : lowerChildren) {
                    tNode.setParent(node);
                }
                node.setChildren(lowerChildren);
                SVNChangedPathData[] sVNChangedPathDataArray = child.getData();
                int n = sVNChangedPathDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SVNChangedPathData data = sVNChangedPathDataArray[n2];
                    node.addData(data);
                    ++n2;
                }
                this.doCompress(node);
            }
        }
    }
}

