/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.mapping;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.mapping.ResourceModelSorter;
import org.eclipse.team.svn.core.mapping.SVNIncomingChangeSet;
import org.eclipse.team.svn.ui.mapping.SVNChangeSetActionProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class SVNChangeSetSorter
extends ResourceModelSorter {
    public static final int DATE = 1;
    public static final int COMMENT = 2;
    public static final int USER = 3;
    private ISynchronizePageConfiguration configuration;

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (o1 instanceof ChangeSet && o2 instanceof ChangeSet) {
            ChangeSet s1 = (ChangeSet)o1;
            ChangeSet s2 = (ChangeSet)o2;
            if (s1 instanceof ActiveChangeSet && s2 instanceof ActiveChangeSet) {
                return this.compareNames(((ActiveChangeSet)s1).getTitle(), ((ActiveChangeSet)s2).getTitle());
            }
            if (s1 instanceof SVNIncomingChangeSet && s2 instanceof SVNIncomingChangeSet) {
                SVNIncomingChangeSet r1 = (SVNIncomingChangeSet)s1;
                SVNIncomingChangeSet r2 = (SVNIncomingChangeSet)s2;
                if (this.getCommentCriteria() == 1) {
                    return r1.getDate().compareTo(r2.getDate());
                }
                if (this.getCommentCriteria() == 2) {
                    return this.compareNames(r1.getComment(), r2.getComment());
                }
                if (this.getCommentCriteria() == 3) {
                    return this.compareNames(r1.getAuthor(), r2.getAuthor());
                }
                return 0;
            }
            if (s1 instanceof ActiveChangeSet) {
                return -1;
            }
            if (s2 instanceof ActiveChangeSet) {
                return 1;
            }
            if (s1 instanceof SVNIncomingChangeSet) {
                return -1;
            }
            if (s2 instanceof SVNIncomingChangeSet) {
                return 1;
            }
        }
        return super.compare(viewer, o1, o2);
    }

    private int compareNames(String s1, String s2) {
        s1 = s1 == null ? "" : s1;
        s2 = s2 == null ? "" : s2;
        return this.collator.compare(s1, s2);
    }

    public int getCommentCriteria() {
        return SVNChangeSetActionProvider.getSortCriteria(this.configuration);
    }

    public void setConfiguration(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
    }
}

