/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryBase;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.CommentComposite;
import org.eclipse.team.svn.ui.composite.ResourceSelectionComposite;
import org.eclipse.team.svn.ui.composite.RevisionComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.event.IResourceSelectionChangeListener;
import org.eclipse.team.svn.ui.event.ResourceSelectionChangedEvent;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.panel.common.RepositoryTreePanel;
import org.eclipse.team.svn.ui.panel.participant.BasePaneParticipant;
import org.eclipse.team.svn.ui.panel.participant.PaneParticipantHelper;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.synchronize.AbstractSynchronizeActionGroup;
import org.eclipse.team.svn.ui.utility.UserInputHistory;
import org.eclipse.team.svn.ui.verifier.AbsolutePathVerifier;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.URLVerifier;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;

public abstract class AbstractBranchTagPanel
extends AbstractDialogPanel {
    protected Button startWithCheck;
    protected Button freezeExternalsCheck;
    protected Combo destinationCombo;
    protected Combo branchingModeCombo;
    protected UserInputHistory resourceNameHistory;
    protected CommentComposite comment;
    protected String destinationUrl;
    protected IRepositoryRoot root;
    protected String nationalizationId;
    protected boolean startsWith;
    protected boolean freezeExternals;
    protected Set existingNodesNamesSet;
    protected boolean considerStructure;
    protected String historyName;
    protected int creationMode;
    protected ResourceSelectionComposite resourceSelection;
    protected IResource[] newResources;
    protected boolean disableSwitch;
    protected IRepositoryResource[] selectedRemoteResources;
    protected RevisionComposite revisionComposite;
    protected PaneParticipantHelper paneParticipantHelper;
    protected boolean hasParticipantPane;

    public AbstractBranchTagPanel(IRepositoryRoot root, boolean showStartsWith, Set existingNames, String nationalizationId, String historyName, IRepositoryResource[] selectedRemoteResources) {
        this(root, showStartsWith, existingNames, nationalizationId, historyName, new IResource[0], selectedRemoteResources);
    }

    public AbstractBranchTagPanel(IRepositoryRoot root, boolean showStartsWith, Set existingNames, String nationalizationId, String historyName, IResource[] resources, IRepositoryResource[] selectedRemoteResources) {
        this.nationalizationId = nationalizationId;
        this.historyName = historyName;
        this.selectedRemoteResources = selectedRemoteResources;
        this.newResources = FileUtility.getResourcesRecursive((IResource[])resources, (IStateFilter)IStateFilter.SF_NEW, (int)2);
        this.disableSwitch = FileUtility.checkForResourcesPresence((IResource[])resources, (IStateFilter)new IStateFilter.AbstractStateFilter(){

            protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
                return state == "Added";
            }

            protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
                return true;
            }
        }, (int)2);
        this.dialogTitle = SVNUIMessages.getString(String.valueOf(this.nationalizationId) + "_Title");
        this.dialogDescription = SVNUIMessages.getString(String.valueOf(this.nationalizationId) + "_Description");
        this.defaultMessage = SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure") ? SVNUIMessages.getString(String.valueOf(this.nationalizationId) + "_MessageAuto") : SVNUIMessages.getString(String.valueOf(this.nationalizationId) + "_Message");
        if (!showStartsWith) {
            this.defaultMessage = String.valueOf(this.defaultMessage) + " " + SVNUIMessages.AbstractBranchTagPanel_Message;
        }
        this.existingNodesNamesSet = existingNames;
        this.root = root;
        this.startsWith = showStartsWith;
        this.considerStructure = root.getRepositoryLocation().isStructureEnabled() && SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure");
        this.paneParticipantHelper = new PaneParticipantHelper();
    }

    public SVNRevision getRevisionForRemoteResources() {
        return this.revisionComposite != null ? this.revisionComposite.getSelectedRevision() : null;
    }

    public IResource[] getSelectedResources() {
        if (this.hasParticipantPane) {
            return this.paneParticipantHelper.getSelectedResources();
        }
        return this.resourceSelection == null ? new IResource[]{} : this.resourceSelection.getSelectedResources();
    }

    public IResource[] getNotSelectedResources() {
        if (this.hasParticipantPane) {
            return this.paneParticipantHelper.getNotSelectedResources();
        }
        return this.resourceSelection == null ? new IResource[]{} : this.resourceSelection.getNotSelectedResources();
    }

    public boolean isFreezeExternals() {
        return this.freezeExternals;
    }

    public String getMessage() {
        return this.comment.getMessage();
    }

    public int getCreationMode() {
        return this.creationMode;
    }

    public IRepositoryResource getDestination() {
        this.destinationUrl = this.destinationUrl.trim();
        while (this.destinationUrl.endsWith("/") || this.destinationUrl.endsWith("\\")) {
            this.destinationUrl = this.destinationUrl.substring(0, this.destinationUrl.length() - 1);
        }
        return this.root.getRepositoryLocation().asRepositoryContainer(this.destinationUrl, false);
    }

    public boolean isStartWithSelected() {
        return this.startsWith;
    }

    public Point getPrefferedSizeImpl() {
        return new Point(this.newResources != null && this.newResources.length > 0 ? 625 : 525, -1);
    }

    public void postInit() {
        super.postInit();
        this.comment.postInit(this.manager);
        if (this.hasParticipantPane) {
            this.paneParticipantHelper.expandPaneTree();
        }
    }

    public void createControlsImpl(Composite parent) {
        IRepositoryResource selectedRemoteResource;
        GridData data = null;
        GridLayout layout = new GridLayout();
        Group select = null;
        String substitutionUppercase = SVNUIMessages.getString(String.valueOf(this.nationalizationId) + "_NodeName");
        if (this.startsWith) {
            select = new Group(parent, 0);
            layout.numColumns = 2;
            select.setText(this.considerStructure ? substitutionUppercase : SVNUIMessages.getString(String.valueOf(this.nationalizationId) + "_Location_Group"));
        } else {
            select = new Composite(parent, 0);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 3;
        }
        select.setLayout((Layout)layout);
        select.setLayoutData((Object)new GridData(768));
        if (!this.startsWith) {
            Label description = new Label((Composite)select, 0);
            data = new GridData();
            description.setLayoutData((Object)data);
            description.setText(this.considerStructure ? substitutionUppercase : SVNUIMessages.getString(String.valueOf(this.nationalizationId) + "_Location_Field"));
        }
        this.createTopPart((Composite)select, substitutionUppercase);
        if (this.startsWith) {
            Composite inner = new Composite((Composite)select, 0);
            data = new GridData(768);
            inner.setLayoutData((Object)data);
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            inner.setLayout((Layout)layout);
            this.startWithCheck = new Button(inner, 32);
            data = new GridData(768);
            this.startWithCheck.setLayoutData((Object)data);
            this.startWithCheck.setText(SVNUIMessages.getString(String.valueOf(this.nationalizationId) + "_StartsWith"));
            this.startWithCheck.setSelection(false);
            this.startWithCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractBranchTagPanel.this.validateContent();
                }
            });
            this.freezeExternalsCheck = new Button(inner, 32);
            data = new GridData(768);
            this.freezeExternalsCheck.setLayoutData((Object)data);
            this.freezeExternalsCheck.setText(SVNUIMessages.getString(String.valueOf(this.nationalizationId) + "_FreezeExternals"));
            this.freezeExternalsCheck.setSelection(false);
        }
        if (this.selectedRemoteResources.length == 1) {
            selectedRemoteResource = this.selectedRemoteResources[0];
        } else if (this.selectedRemoteResources.length > 1) {
            selectedRemoteResource = this.selectedRemoteResources[0].getRoot();
        } else {
            selectedRemoteResource = this.root.getRepositoryLocation().getRoot();
            selectedRemoteResource.setPegRevision(this.root.getPegRevision());
            selectedRemoteResource.setSelectedRevision(this.root.getSelectedRevision());
        }
        this.revisionComposite = new RevisionComposite(parent, this, false, new String[]{SVNUIMessages.RevisionComposite_Revision, SVNUIMessages.RevisionComposite_HeadRevision}, SVNRevision.HEAD, false);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        data = new GridData(768);
        this.revisionComposite.setLayout((Layout)layout);
        this.revisionComposite.setLayoutData(data);
        this.revisionComposite.setSelectedResource(selectedRemoteResource);
        if (this.startsWith) {
            this.revisionComposite.setEnabled(SVNTeamPreferences.getDialogInt(SVNTeamUIPlugin.instance().getPreferenceStore(), "branchTagCreationMode") == 3);
        }
        SashForm splitter = new SashForm(parent, 512);
        data = new GridData(1808);
        splitter.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 3;
        splitter.setLayout((Layout)layout);
        Group group = new Group((Composite)splitter, 0);
        group.setLayout((Layout)new GridLayout());
        data = new GridData(1808);
        group.setLayoutData((Object)data);
        group.setText(SVNUIMessages.getString(String.valueOf(this.nationalizationId) + "_Comment"));
        this.comment = new CommentComposite((Composite)group, this);
        data = new GridData(1808);
        this.comment.setLayoutData(data);
        if (this.startsWith && this.newResources != null && this.newResources.length > 0) {
            if (this.paneParticipantHelper.isParticipantPane()) {
                this.hasParticipantPane = true;
                this.paneParticipantHelper.init(this.createPaneParticipant());
                this.createPaneControls((Composite)splitter);
            } else {
                this.createResourceSelectionCompositeControls((Composite)splitter);
            }
            splitter.setWeights(new int[]{1, 1});
        } else {
            splitter.setWeights(new int[]{1});
        }
    }

    protected void createPaneControls(Composite parent) {
        Control paneControl = this.paneParticipantHelper.createChangesPage(parent);
        GridData data = new GridData(1808);
        paneControl.setLayoutData((Object)data);
        this.paneParticipantHelper.initListeners();
        this.attachTo(paneControl, new PanelPaneVerifier(this.paneParticipantHelper));
    }

    protected BasePaneParticipant createPaneParticipant() {
        return new BasePaneParticipant((ISynchronizeScope)new ResourceScope(this.newResources), this){

            @Override
            protected Collection<AbstractSynchronizeActionGroup> getActionGroups() {
                ArrayList<AbstractSynchronizeActionGroup> actionGroups = new ArrayList<AbstractSynchronizeActionGroup>();
                actionGroups.add(new BasePaneParticipant.BasePaneActionGroup(this.validationManager));
                return actionGroups;
            }
        };
    }

    protected void createResourceSelectionCompositeControls(Composite parent) {
        this.resourceSelection = new ResourceSelectionComposite(parent, 0, this.newResources, true);
        GridData data = new GridData(1808);
        this.resourceSelection.setLayoutData(data);
        this.resourceSelection.addResourcesSelectionChangedListener(new IResourceSelectionChangeListener(){

            public void resourcesSelectionChanged(ResourceSelectionChangedEvent event) {
                AbstractBranchTagPanel.this.validateContent();
            }
        });
        this.attachTo((Control)this.resourceSelection, new AbstractVerifier(){

            protected String getWarningMessage(Control input) {
                IResource[] resources = AbstractBranchTagPanel.this.resourceSelection.getSelectedResources();
                if ((resources != null && resources.length != 0 || AbstractBranchTagPanel.this.disableSwitch) && AbstractBranchTagPanel.this.startWithCheck.getSelection()) {
                    return String.valueOf(AbstractBranchTagPanel.this.defaultMessage) + " " + SVNUIMessages.getString(String.valueOf(AbstractBranchTagPanel.this.nationalizationId) + "_Warning");
                }
                return null;
            }

            protected String getErrorMessage(Control input) {
                return null;
            }
        });
    }

    protected Composite createTopPart(Composite select, String substitutionUppercase) {
        this.destinationUrl = this.root.getUrl();
        this.destinationCombo = new Combo(select, 2048);
        GridData data = new GridData(768);
        this.destinationCombo.setLayoutData((Object)data);
        Button browse = new Button(select, 8);
        browse.setText(SVNUIMessages.Button_Browse);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(browse);
        browse.setLayoutData((Object)data);
        if (this.startsWith) {
            this.branchingModeCombo = new Combo(select, 2056);
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.branchingModeCombo.setLayoutData((Object)data);
            this.branchingModeCombo.setItems(new String[]{SVNUIMessages.AbstractBranchTagPanel_CreationMode_AsIs, SVNUIMessages.AbstractBranchTagPanel_CreationMode_CheckRevision, SVNUIMessages.AbstractBranchTagPanel_CreationMode_DoUpdate, SVNUIMessages.AbstractBranchTagPanel_CreationMode_Repository});
            this.branchingModeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractBranchTagPanel.this.creationModeChanged(AbstractBranchTagPanel.this.branchingModeCombo.getSelectionIndex());
                }
            });
            this.creationMode = SVNTeamPreferences.getDialogInt(SVNTeamUIPlugin.instance().getPreferenceStore(), "branchTagCreationMode");
            this.branchingModeCombo.select(this.creationMode);
        }
        CompositeVerifier verifier = new CompositeVerifier();
        if (!this.considerStructure) {
            this.resourceNameHistory = new UserInputHistory(this.historyName);
            this.destinationCombo.setText(this.destinationUrl);
            String name = SVNUIMessages.getString(String.valueOf(this.nationalizationId) + "_Location_Verifier");
            verifier.add(new URLVerifier(name));
            verifier.add(new AbsolutePathVerifier(name));
            verifier.add(new AbstractVerifier(){

                protected String getErrorMessage(Control input) {
                    String url = AbstractBranchTagPanel.this.root.getRepositoryLocation().getUrl();
                    if (!AbstractBranchTagPanel.this.destinationCombo.getText().startsWith(url)) {
                        return SVNUIMessages.format((String)SVNUIMessages.getString(String.valueOf(AbstractBranchTagPanel.this.nationalizationId) + "_Location_Verifier_DoesNotCorresponds"), (Object[])new String[]{AbstractBranchTagPanel.this.destinationCombo.getText(), url});
                    }
                    if (AbstractBranchTagPanel.this.startsWith) {
                        if (!AbstractBranchTagPanel.this.destinationCombo.getText().startsWith(AbstractBranchTagPanel.this.root.getUrl())) {
                            AbstractBranchTagPanel.this.startWithCheck.setSelection(false);
                            AbstractBranchTagPanel.this.startWithCheck.setEnabled(false);
                        } else {
                            AbstractBranchTagPanel.this.startWithCheck.setEnabled(true);
                        }
                    }
                    if (AbstractBranchTagPanel.this.root.getUrl().equals(SVNUtility.normalizeURL((String)AbstractBranchTagPanel.this.destinationCombo.getText()))) {
                        return SVNUIMessages.getString(String.valueOf(AbstractBranchTagPanel.this.nationalizationId) + "_Location_Verifier_NoTagName");
                    }
                    return null;
                }

                protected String getWarningMessage(Control input) {
                    return null;
                }
            });
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RepositoryTreePanel panel = new RepositoryTreePanel(SVNUIMessages.getString(String.valueOf(AbstractBranchTagPanel.this.nationalizationId) + "_SelectionProposal"), SVNUIMessages.RepositoryBrowsingPanel_Description, SVNUIMessages.RepositoryBrowsingPanel_Message, null, true, (IRepositoryBase)AbstractBranchTagPanel.this.root.getRepositoryLocation(), false);
                    DefaultDialog browser = new DefaultDialog(AbstractBranchTagPanel.this.manager.getShell(), panel);
                    if (browser.open() == 0) {
                        IRepositoryResource selected = panel.getSelectedResource();
                        if (selected != null) {
                            AbstractBranchTagPanel.this.destinationCombo.setText(selected.getUrl());
                        }
                        AbstractBranchTagPanel.this.validateContent();
                    }
                }
            });
        } else {
            this.resourceNameHistory = new UserInputHistory(String.valueOf(this.historyName) + "Name");
            String name = SVNUIMessages.getString(String.valueOf(this.nationalizationId) + "_NodeName_Verifier");
            verifier.add(new NonEmptyFieldVerifier(name){

                protected String getErrorMessageImpl(Control input) {
                    String msg = super.getErrorMessageImpl(input);
                    if (msg == null && new Path(this.getText(input)).segmentCount() == 0) {
                        return NonEmptyFieldVerifier.ERROR_MESSAGE;
                    }
                    return msg;
                }
            });
            verifier.add(new AbsolutePathVerifier(name));
            verifier.add(new AbstractVerifier(){

                protected String getErrorMessage(Control input) {
                    return null;
                }

                protected String getWarningMessage(Control input) {
                    String name = AbstractBranchTagPanel.this.destinationCombo.getText();
                    if (AbstractBranchTagPanel.this.existingNodesNamesSet != null && AbstractBranchTagPanel.this.existingNodesNamesSet.contains(name)) {
                        return SVNUIMessages.format((String)SVNUIMessages.getString(String.valueOf(AbstractBranchTagPanel.this.nationalizationId) + "_NodeName_Verifier_Error_Exists"), (Object[])new String[]{name});
                    }
                    return null;
                }
            });
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RepositoryTreePanel panel = new RepositoryTreePanel(SVNUIMessages.getString(String.valueOf(AbstractBranchTagPanel.this.nationalizationId) + "_SelectionProposal"), SVNUIMessages.RepositoryBrowsingPanel_Description, SVNUIMessages.RepositoryBrowsingPanel_Message, null, true, (IRepositoryBase)AbstractBranchTagPanel.this.root.getRoot(), false);
                    DefaultDialog browser = new DefaultDialog(AbstractBranchTagPanel.this.manager.getShell(), panel);
                    if (browser.open() == 0) {
                        IRepositoryResource selected = panel.getSelectedResource();
                        if (selected != null) {
                            AbstractBranchTagPanel.this.destinationCombo.setText(selected.getUrl().substring(AbstractBranchTagPanel.this.root.getUrl().length() + 1));
                        }
                        AbstractBranchTagPanel.this.validateContent();
                    }
                }
            });
        }
        this.destinationCombo.setVisibleItemCount(this.resourceNameHistory.getDepth());
        this.destinationCombo.setItems(this.resourceNameHistory.getHistory());
        this.attachTo((Control)this.destinationCombo, verifier);
        return select;
    }

    protected void creationModeChanged(int creationMode) {
        if (creationMode == 3) {
            this.freezeExternalsCheck.setSelection(false);
        }
        this.freezeExternalsCheck.setEnabled(creationMode != 3);
        this.revisionComposite.setEnabled(creationMode == 3);
    }

    protected void saveChangesImpl() {
        if (!this.considerStructure) {
            this.destinationUrl = this.destinationCombo.getText();
            this.resourceNameHistory.addLine(this.destinationUrl);
        } else {
            this.destinationUrl = String.valueOf(this.destinationUrl) + "/" + this.destinationCombo.getText();
            this.resourceNameHistory.addLine(this.destinationCombo.getText());
        }
        this.comment.saveChanges();
        if (this.startWithCheck != null) {
            this.startsWith = this.startWithCheck.getSelection();
            this.freezeExternals = this.freezeExternalsCheck.getSelection();
            this.creationMode = this.branchingModeCombo.getSelectionIndex();
            SVNTeamPreferences.setDialogInt(SVNTeamUIPlugin.instance().getPreferenceStore(), "branchTagCreationMode", this.creationMode);
        } else {
            this.startsWith = false;
            this.freezeExternals = false;
        }
    }

    protected void cancelChangesImpl() {
        this.comment.cancelChanges();
    }

    public void dispose() {
        super.dispose();
        if (this.hasParticipantPane) {
            this.paneParticipantHelper.dispose();
        }
    }

    protected class PanelPaneVerifier
    extends PaneParticipantHelper.PaneVerifier {
        public PanelPaneVerifier(PaneParticipantHelper paneParticipantHelper) {
            super(paneParticipantHelper);
        }

        protected String getErrorMessage(Control input) {
            return null;
        }

        protected String getWarningMessage(Control input) {
            IResource[] resourcesToProcess = this.paneParticipantHelper.getSelectedResources();
            if ((resourcesToProcess.length == 0 || AbstractBranchTagPanel.this.disableSwitch) && AbstractBranchTagPanel.this.startWithCheck.getSelection()) {
                return String.valueOf(AbstractBranchTagPanel.this.defaultMessage) + " " + SVNUIMessages.getString(String.valueOf(AbstractBranchTagPanel.this.nationalizationId) + "_Warning");
            }
            return null;
        }
    }
}

