/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.AddToSVNIgnoreOperation;
import org.eclipse.team.svn.core.operation.local.CreatePatchOperation;
import org.eclipse.team.svn.core.operation.local.ExportOperation;
import org.eclipse.team.svn.core.operation.local.MarkAsMergedOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.management.CleanupOperation;
import org.eclipse.team.svn.core.operation.local.property.GetPropertiesOperation;
import org.eclipse.team.svn.core.operation.local.refactor.DeleteResourceOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.resource.events.IResourceStatesListener;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.ResourcesParentsProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.local.AddToSVNIgnoreAction;
import org.eclipse.team.svn.ui.action.local.BranchTagAction;
import org.eclipse.team.svn.ui.action.local.CompareWithWorkingCopyAction;
import org.eclipse.team.svn.ui.action.local.ReplaceWithLatestRevisionAction;
import org.eclipse.team.svn.ui.action.local.ReplaceWithRevisionAction;
import org.eclipse.team.svn.ui.action.local.RevertAction;
import org.eclipse.team.svn.ui.composite.CommentComposite;
import org.eclipse.team.svn.ui.composite.ResourceSelectionComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.dialog.DiscardConfirmationDialog;
import org.eclipse.team.svn.ui.event.IResourceSelectionChangeListener;
import org.eclipse.team.svn.ui.event.ResourceSelectionChangedEvent;
import org.eclipse.team.svn.ui.extension.factory.ICommentDialogPanel;
import org.eclipse.team.svn.ui.operation.CompareResourcesOperation;
import org.eclipse.team.svn.ui.operation.ShowConflictEditorOperation;
import org.eclipse.team.svn.ui.panel.common.CommentPanel;
import org.eclipse.team.svn.ui.panel.local.EditTreeConflictsPanel;
import org.eclipse.team.svn.ui.panel.participant.CommitPaneParticipant;
import org.eclipse.team.svn.ui.panel.participant.CommitPaneParticipantHelper;
import org.eclipse.team.svn.ui.panel.remote.ComparePanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.properties.bugtraq.BugtraqModel;
import org.eclipse.team.svn.ui.propfind.BugtraqPropFindVisitor;
import org.eclipse.team.svn.ui.propfind.CompositePropFindVisitor;
import org.eclipse.team.svn.ui.propfind.IPropFindVisitor;
import org.eclipse.team.svn.ui.propfind.LogTemplatesPropFindVisitor;
import org.eclipse.team.svn.ui.propfind.MaxLogWidthPropFindVisitor;
import org.eclipse.team.svn.ui.propfind.MinLockSizePropFindVisitor;
import org.eclipse.team.svn.ui.propfind.MinLogSizePropFindVisitor;
import org.eclipse.team.svn.ui.utility.LockProposeUtility;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;

public class CommitPanel
extends CommentPanel
implements ICommentDialogPanel {
    public static final int MSG_COMMIT = 0;
    public static final int MSG_OVER_AND_COMMIT = 1;
    public static final int MAXIMUM_CHECKS_SIZE = 100;
    protected ResourceSelectionComposite selectionComposite;
    protected Button pasteNamesButton;
    protected CommitPaneParticipantHelper paneParticipantHelper;
    protected IResource[] resources;
    protected IResource[] userSelectedResources;
    protected Button keepLocksButton;
    protected SashForm sForm;
    protected boolean keepLocks;
    protected List<IResourceSelectionChangeListener> changeListenerList;
    protected int minLogSize;
    protected int maxLogWidth;
    protected final String proposedComment;
    protected IResourceStatesListener resourceStatesListener;
    protected boolean resourcesChanged;

    public CommitPanel(IResource[] resources, int msgType) {
        this(resources, msgType, null);
    }

    public CommitPanel(IResource[] resources, int msgType, String proposedComment) {
        this(resources, null, msgType, proposedComment);
    }

    public CommitPanel(IResource[] resources, IResource[] userSelectedResources, int msgType, String proposedComment) {
        super(SVNUIMessages.CommitPanel_Title);
        this.proposedComment = proposedComment;
        this.resources = resources;
        if (msgType == 1) {
            this.defaultMessage = SVNUIMessages.CommitPanel_Message;
            this.dialogDescription = SVNUIMessages.CommitPanel_Description;
        }
        this.changeListenerList = new ArrayList<IResourceSelectionChangeListener>();
        this.userSelectedResources = userSelectedResources;
        this.paneParticipantHelper = new CommitPaneParticipantHelper();
    }

    public void createControlsImpl(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 3;
        this.sForm = new SashForm(parent, 512);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 3;
        this.sForm.setLayout((Layout)layout);
        data = new GridData(1808);
        data.heightHint = 400;
        this.sForm.setLayoutData((Object)data);
        Composite composite = new Composite((Composite)this.sForm, 0);
        composite.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Group group = new Group(composite, 0);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        data = new GridData(1808);
        group.setLayoutData((Object)data);
        group.setText(SVNUIMessages.CommitPanel_Comment);
        CollectPropertiesOperation op = new CollectPropertiesOperation(this.resources);
        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
        this.bugtraqModel = op.getBugtraqModel();
        this.minLogSize = op.getMinLogSize();
        this.maxLogWidth = op.getMaxLogWidth();
        this.comment = new CommentComposite((Composite)group, this.proposedComment, this, op.getLogTemplates(), this.bugtraqModel, this.minLogSize, this.maxLogWidth);
        data = new GridData(1808);
        this.comment.setLayoutData(data);
        Composite middleComposite = new Composite(composite, 0);
        data = new GridData(768);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        layout.numColumns = 2;
        middleComposite.setLayoutData((Object)data);
        middleComposite.setLayout((Layout)layout);
        this.keepLocks = SVNTeamUIPlugin.instance().getPreferenceStore().getBoolean("CommitPanel.keepLocks");
        this.keepLocksButton = new Button(middleComposite, 32);
        data = new GridData(769);
        this.keepLocksButton.setLayoutData((Object)data);
        this.keepLocksButton.setText(SVNUIMessages.CommitPanel_KeepLocks);
        this.keepLocksButton.setSelection(false);
        this.keepLocksButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitPanel.this.keepLocks = CommitPanel.this.keepLocksButton.getSelection();
            }
        });
        this.keepLocksButton.setSelection(this.keepLocks);
        this.pasteNamesButton = new Button(middleComposite, 0x1000008);
        data = new GridData();
        this.pasteNamesButton.setLayoutData((Object)data);
        this.pasteNamesButton.setText(SVNUIMessages.CommitPanel_PasteNames_Button);
        this.pasteNamesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitPanel.this.pasteNames();
            }
        });
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        if (this.paneParticipantHelper.isParticipantPane()) {
            CommitPaneParticipant participant = new CommitPaneParticipant((ISynchronizeScope)new ResourceScope(this.resources), this);
            this.paneParticipantHelper.init(participant);
            this.createPaneControls();
        } else {
            this.createResourceSelectionCompositeControls();
        }
    }

    protected void createResourceSelectionCompositeControls() {
        this.selectionComposite = new ResourceSelectionComposite((Composite)this.sForm, 0, this.resources, true, this.userSelectedResources);
        GridData data = new GridData(1808);
        data.heightHint = 175;
        this.selectionComposite.setLayoutData(data);
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        int first = SVNTeamPreferences.getDialogInt(store, "CommitPanel.weight");
        this.sForm.setWeights(new int[]{first, 100 - first});
        this.selectionComposite.addResourcesSelectionChangedListener(new IResourceSelectionChangeListener(){

            public void resourcesSelectionChanged(ResourceSelectionChangedEvent event) {
                CommitPanel.this.fireResourcesSelectionChanged(event);
            }
        });
        this.attachTo((Control)this.selectionComposite, new AbstractVerifier(){

            protected String getErrorMessage(Control input) {
                IResource[] selection = CommitPanel.this.getSelectedResources();
                if (selection == null || selection.length == 0) {
                    return SVNUIMessages.ResourceSelectionComposite_Verifier_Error;
                }
                if (FileUtility.checkForResourcesPresenceRecursive((IResource[])selection, (IStateFilter)new IStateFilter.OrStateFilter(new IStateFilter[]{IStateFilter.SF_CONFLICTING, IStateFilter.SF_TREE_CONFLICTING}))) {
                    return SVNUIMessages.CommitPanel_Conflicting_Error;
                }
                return null;
            }

            protected String getWarningMessage(Control input) {
                String message = null;
                IResource[] selection = CommitPanel.this.getSelectedResources();
                if (selection != null && selection.length > 0) {
                    message = CommitPanel.validateResources(selection);
                }
                return message;
            }
        });
        this.addContextMenu();
    }

    protected void createPaneControls() {
        Composite paneComposite = new Composite((Composite)this.sForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        paneComposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 175;
        paneComposite.setLayoutData((Object)data);
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        int first = SVNTeamPreferences.getDialogInt(store, "CommitPanel.weight");
        this.sForm.setWeights(new int[]{first, 100 - first});
        Control paneControl = this.paneParticipantHelper.createChangesPage(paneComposite);
        data = new GridData(1808);
        paneControl.setLayoutData((Object)data);
        this.paneParticipantHelper.initListeners();
        this.attachTo((Control)paneComposite, new CommitPaneParticipantHelper.CommitPaneVerifier(this.paneParticipantHelper));
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.commitDialogContext";
    }

    public void postInit() {
        super.postInit();
        this.resourceStatesListener = new IResourceStatesListener(){

            public void resourcesStateChanged(ResourceStatesChangedEvent event) {
                CommitPanel.this.updateResources(event);
            }
        };
        SVNRemoteStorage.instance().addResourceStatesListener(ResourceStatesChangedEvent.class, this.resourceStatesListener);
        if (this.paneParticipantHelper.isParticipantPane()) {
            this.paneParticipantHelper.expandPaneTree();
        }
    }

    protected void saveChangesImpl() {
        super.saveChangesImpl();
        this.savePreferences();
    }

    protected void cancelChangesImpl() {
        super.cancelChangesImpl();
        this.savePreferences();
    }

    public boolean canClose() {
        final boolean[] commit = new boolean[]{true};
        if (this.bugtraqModel != null && this.bugtraqModel.getMessage() != null && this.bugtraqModel.isWarnIfNoIssue() && this.comment.getBugID() != null && this.comment.getBugID().trim().length() == 0) {
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dlg = new MessageDialog(UIMonitorUtility.getShell(), SVNUIMessages.CommitPanel_NoBugId_Title, null, SVNUIMessages.CommitPanel_NoBugId_Message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    commit[0] = dlg.open() == 0;
                }
            });
        }
        return commit[0];
    }

    public void pasteNames() {
        if (!this.paneParticipantHelper.isParticipantPane()) {
            List selectedResources = this.selectionComposite.getCurrentSelection();
            this.pasteNames(selectedResources.toArray(new IResource[0]));
        } else {
            ISelection selection = this.paneParticipantHelper.getSyncPageConfiguration().getSite().getSelectionProvider().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection strSelection = (IStructuredSelection)selection;
                Object[] elements = strSelection.toArray();
                IResource[] resources = Utils.getResources((Object[])elements);
                this.pasteNames(resources);
            }
        }
    }

    protected void pasteNames(IResource[] resources) {
        if (resources.length > 0) {
            String namesString = "";
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                namesString = String.valueOf(namesString) + resource.getName() + "\n";
                ++n2;
            }
            this.comment.insertText(namesString);
        }
    }

    protected void addContextMenu() {
        final TableViewer tableViewer = this.selectionComposite.getTableViewer();
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)tableViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MenuManager subMenu;
                manager.add((IContributionItem)new Separator("additions"));
                IStructuredSelection tSelection = (IStructuredSelection)tableViewer.getSelection();
                final IResource[] selectedResources = tSelection.toList().toArray(new IResource[tSelection.size()]);
                Action tAction = null;
                tAction = new Action(SVNUIMessages.CommitPanel_PasteNames_Action){

                    public void run() {
                        CommitPanel.this.pasteNames();
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() > 0);
                tAction = new Action(SVNUIMessages.CreatePatchCommand_label){

                    public void run() {
                        FileDialog dlg = new FileDialog(UIMonitorUtility.getShell(), 40960);
                        dlg.setText(SVNUIMessages.SelectPatchFilePage_SavePatchAs);
                        dlg.setFileName(String.valueOf(selectedResources[0].getName()) + ".patch");
                        dlg.setFilterExtensions(new String[]{"patch", "*.*"});
                        String file = dlg.open();
                        if (file != null) {
                            CreatePatchOperation mainOp = new CreatePatchOperation(new IResource[]{selectedResources[0]}, file, true, true, true, true);
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)mainOp, false);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_VERSIONED, (int)0));
                tAction = new Action(SVNUIMessages.BranchAction_label){

                    public void run() {
                        IResource[] resources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_EXCLUDE_DELETED, (int)2);
                        IActionOperation op = BranchTagAction.getBranchTagOperation(UIMonitorUtility.getShell(), 0, resources);
                        if (op != null) {
                            UIMonitorUtility.doTaskNowDefault(op, true);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() > 0 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_EXCLUDE_DELETED, (int)0));
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/branch.gif"));
                manager.add((IContributionItem)new Separator());
                tAction = new Action(SVNUIMessages.CommitPanel_Revert_Action){

                    public void run() {
                        IResource[] changedResources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)RevertAction.SF_REVERTABLE_OR_NEW);
                        CompositeOperation revertOp = RevertAction.getRevertOperation(UIMonitorUtility.getShell(), changedResources, selectedResources);
                        if (revertOp != null) {
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)revertOp, true);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/revert.gif"));
                tAction.setEnabled(tSelection.size() > 0);
                if (tSelection.size() > 0 && selectedResources.length == FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)AddToSVNIgnoreAction.SF_NEW_AND_PARENT_VERSIONED).length) {
                    subMenu = new MenuManager(SVNUIMessages.CommitPanel_Ignore_Group);
                    if (tSelection.size() > 1) {
                        tAction = new Action(SVNUIMessages.CommitPanel_IgnoreByName_Multiple_Action){

                            public void run() {
                                CompositeOperation op = new CompositeOperation("Operation_AddToSVNIgnore", SVNMessages.class);
                                op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 0, null));
                                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider((this).CommitPanel.this.resources), 2, RefreshResourcesOperation.REFRESH_ALL));
                                UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                            }
                        };
                        subMenu.add((IAction)tAction);
                        tAction.setEnabled(true);
                        tAction = new Action(SVNUIMessages.CommitPanel_IgnoreByExtension_Multiple_Action){

                            public void run() {
                                CompositeOperation op = new CompositeOperation("Operation_AddToSVNIgnore", SVNMessages.class);
                                op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 1, null));
                                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider((this).CommitPanel.this.resources), 2, RefreshResourcesOperation.REFRESH_ALL));
                                UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                            }
                        };
                        subMenu.add((IAction)tAction);
                        tAction.setEnabled(true);
                    } else {
                        tAction = new Action(selectedResources[0].getName()){

                            public void run() {
                                CompositeOperation op = new CompositeOperation("Operation_AddToSVNIgnore", SVNMessages.class);
                                op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 0, null));
                                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider((this).CommitPanel.this.resources), 2, RefreshResourcesOperation.REFRESH_ALL));
                                UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                            }
                        };
                        subMenu.add((IAction)tAction);
                        tAction.setEnabled(true);
                        String name = selectedResources[0].getName();
                        String[] parts = name.split("\\.");
                        if (parts.length != 0) {
                            tAction = new Action("*." + parts[parts.length - 1]){

                                public void run() {
                                    CompositeOperation op = new CompositeOperation("Operation_AddToSVNIgnore", SVNMessages.class);
                                    op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 1, null));
                                    op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider((this).CommitPanel.this.resources), 2, RefreshResourcesOperation.REFRESH_ALL));
                                    UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                                }
                            };
                            subMenu.add((IAction)tAction);
                            tAction.setEnabled(true);
                        }
                    }
                    manager.add((IContributionItem)subMenu);
                }
                tAction = new Action(SVNUIMessages.EditConflictsAction_label){

                    public void run() {
                        UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new ShowConflictEditorOperation(FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_CONTENT_CONFLICTING), true));
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_CONTENT_CONFLICTING));
                tAction = new Action(SVNUIMessages.EditTreeConflictsAction_label){

                    public void run() {
                        ILocalResource local;
                        if (selectedResources.length > 0 && (local = SVNRemoteStorage.instance().asLocalResource(selectedResources[0])).hasTreeConflict()) {
                            EditTreeConflictsPanel editConflictsPanel = new EditTreeConflictsPanel(local);
                            DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), editConflictsPanel);
                            if (dialog.open() == 0 && editConflictsPanel.getOperation() != null) {
                                UIMonitorUtility.doTaskScheduledDefault(editConflictsPanel.getOperation());
                            }
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selectedResources.length == 1 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_TREE_CONFLICTING, (int)0));
                tAction = new Action(SVNUIMessages.CommitPanel_MarkAsMerged_Action){

                    public void run() {
                        boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
                        MarkAsMergedOperation mainOp = new MarkAsMergedOperation(selectedResources, false, null, ignoreExternals);
                        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
                        op.add((IActionOperation)mainOp);
                        op.add((IActionOperation)new RefreshResourcesOperation(FileUtility.getParents((IResource[])selectedResources, (boolean)false)));
                        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_CONFLICTING) && selectedResources.length == 1);
                manager.add((IContributionItem)new Separator());
                tAction = new Action(SVNUIMessages.LockAction_label){

                    public void run() {
                        IResource[] filteredResources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_READY_TO_LOCK, (int)2);
                        CompositeOperation op = LockProposeUtility.performLockAction(filteredResources, false, UIMonitorUtility.getShell());
                        if (op != null) {
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/lock.gif"));
                tAction.setEnabled(FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_READY_TO_LOCK));
                tAction = new Action(SVNUIMessages.UnlockAction_label){

                    public void run() {
                        IResource[] filteredResources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_LOCKED, (int)2);
                        CompositeOperation op = LockProposeUtility.performUnlockAction(filteredResources, UIMonitorUtility.getShell());
                        if (op != null) {
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/unlock.gif"));
                tAction.setEnabled(FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_LOCKED));
                manager.add((IContributionItem)new Separator());
                subMenu = new MenuManager(SVNUIMessages.CommitPanel_CompareWith_Group);
                tAction = new Action(SVNUIMessages.CompareWithWorkingCopyAction_label){

                    public void run() {
                        IResource resource = selectedResources[0];
                        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                        if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                            IRepositoryResource remote = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)resource) : SVNRemoteStorage.instance().asRepositoryResource(resource);
                            remote.setSelectedRevision(SVNRevision.BASE);
                            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new CompareResourcesOperation(local, remote, false, true));
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)CompareWithWorkingCopyAction.COMPARE_FILTER, (int)0));
                tAction = new Action(SVNUIMessages.CompareWithLatestRevisionAction_label){

                    public void run() {
                        IResource resource = selectedResources[0];
                        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                        if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                            IRepositoryResource remote = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)resource) : SVNRemoteStorage.instance().asRepositoryResource(resource);
                            remote.setSelectedRevision(SVNRevision.HEAD);
                            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new CompareResourcesOperation(local, remote, false, true));
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && (CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 5 || selectedResources[0].getType() == 1) && FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)CompareWithWorkingCopyAction.COMPARE_FILTER));
                tAction = new Action(SVNUIMessages.CompareWithRevisionAction_label){

                    public void run() {
                        IResource resource = selectedResources[0];
                        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                        if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                            IRepositoryResource remote = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)resource) : SVNRemoteStorage.instance().asRepositoryResource(resource);
                            ComparePanel panel = new ComparePanel(remote, local.getRevision());
                            DefaultDialog dlg = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                            if (dlg.open() == 0) {
                                remote = panel.getSelectedResource();
                                UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new CompareResourcesOperation(local, remote, false, true));
                            }
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && (CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 5 || selectedResources[0].getType() == 1) && FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)CompareWithWorkingCopyAction.COMPARE_FILTER));
                manager.add((IContributionItem)subMenu);
                subMenu = new MenuManager(SVNUIMessages.CommitPanel_ReplaceWith_Group);
                tAction = new Action(SVNUIMessages.ReplaceWithLatestRevisionAction_label){

                    public void run() {
                        IResource[] resources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_ONREPOSITORY, (int)0);
                        IActionOperation op = ReplaceWithLatestRevisionAction.getReplaceOperation(resources, UIMonitorUtility.getShell());
                        if (op != null) {
                            UIMonitorUtility.doTaskNowDefault(op, true);
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_ONREPOSITORY));
                tAction = new Action(SVNUIMessages.ReplaceWithRevisionAction_label){

                    public void run() {
                        IActionOperation op = ReplaceWithRevisionAction.getReplaceOperation(selectedResources, UIMonitorUtility.getShell());
                        if (op != null) {
                            UIMonitorUtility.doTaskNowDefault(op, true);
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_ONREPOSITORY, (int)0));
                manager.add((IContributionItem)subMenu);
                manager.add((IContributionItem)new Separator());
                tAction = new Action(SVNUIMessages.ExportCommand_label){

                    public void run() {
                        DirectoryDialog fileDialog = new DirectoryDialog(UIMonitorUtility.getShell());
                        fileDialog.setText(SVNUIMessages.ExportAction_Select_Title);
                        fileDialog.setMessage(SVNUIMessages.ExportAction_Select_Description);
                        String path = fileDialog.open();
                        if (path != null) {
                            boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
                            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new ExportOperation(FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_EXCLUDE_DELETED, (int)0), path, SVNRevision.WORKING, ignoreExternals));
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/export.gif"));
                tAction.setEnabled(tSelection.size() > 0 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_EXCLUDE_DELETED, (int)0));
                tAction = new Action(SVNUIMessages.CleanupCommand_label){

                    public void run() {
                        IResource[] resources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_VERSIONED_FOLDERS, (int)0);
                        CleanupOperation mainOp = new CleanupOperation(resources);
                        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
                        op.add((IActionOperation)mainOp);
                        op.add((IActionOperation)new RefreshResourcesOperation(resources));
                        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() > 0 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_VERSIONED_FOLDERS, (int)0));
                manager.add((IContributionItem)new Separator());
                tAction = new Action(SVNUIMessages.CommitPanel_Delete_Action){

                    public void run() {
                        DiscardConfirmationDialog dialog = new DiscardConfirmationDialog(UIMonitorUtility.getShell(), selectedResources.length == 1, 2);
                        if (dialog.open() == 0) {
                            DeleteResourceOperation deleteOperation = new DeleteResourceOperation(selectedResources);
                            CompositeOperation op = new CompositeOperation(deleteOperation.getId(), deleteOperation.getMessagesClass());
                            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(selectedResources);
                            RestoreProjectMetaOperation restoreOp = new RestoreProjectMetaOperation(saveOp);
                            op.add((IActionOperation)saveOp);
                            op.add((IActionOperation)deleteOperation);
                            op.add((IActionOperation)restoreOp);
                            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_CHANGES));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/delete.gif"));
                tAction.setEnabled(tSelection.size() > 0 && !FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_DELETED, (int)0));
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tableViewer.getTable().setMenu(menu);
    }

    protected void updateResources(ResourceStatesChangedEvent event) {
        HashSet<IResource> allResources = new HashSet<IResource>(Arrays.asList(this.resources));
        HashSet<IResource> toDeleteSet = new HashSet<IResource>();
        toDeleteSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])event.resources, (IStateFilter)IStateFilter.SF_NOTMODIFIED, (int)0)));
        toDeleteSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])event.resources, (IStateFilter)IStateFilter.SF_NOTEXISTS, (int)0)));
        toDeleteSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])event.resources, (IStateFilter)IStateFilter.SF_IGNORED, (int)0)));
        allResources.removeAll(toDeleteSet);
        final IResource[] newResources = allResources.toArray(new IResource[allResources.size()]);
        if (!this.paneParticipantHelper.isParticipantPane()) {
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!CommitPanel.this.selectionComposite.isDisposed()) {
                        CommitPanel.this.selectionComposite.setResources(newResources);
                        CommitPanel.this.selectionComposite.fireSelectionChanged();
                    }
                }
            });
        }
        this.resources = newResources;
        this.resourcesChanged = true;
    }

    public boolean getResourcesChanged() {
        return this.resourcesChanged;
    }

    public IResource[] getSelectedResources() {
        if (this.paneParticipantHelper.isParticipantPane()) {
            return this.paneParticipantHelper.getSelectedResources();
        }
        return this.selectionComposite.getSelectedResources();
    }

    public IResource[] getNotSelectedResources() {
        if (this.paneParticipantHelper.isParticipantPane()) {
            return this.paneParticipantHelper.getNotSelectedResources();
        }
        return this.selectionComposite.getNotSelectedResources();
    }

    public void addResourcesSelectionChangedListener(IResourceSelectionChangeListener listener) {
        this.changeListenerList.add(listener);
    }

    public void removeResourcesSelectionChangedListener(IResourceSelectionChangeListener listener) {
        this.changeListenerList.remove(listener);
    }

    public void fireResourcesSelectionChanged(ResourceSelectionChangedEvent event) {
        this.validateContent();
        IResourceSelectionChangeListener[] listeners = this.changeListenerList.toArray(new IResourceSelectionChangeListener[this.changeListenerList.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].resourcesSelectionChanged(event);
            ++i;
        }
    }

    public boolean getKeepLocks() {
        return this.keepLocks;
    }

    protected Point getPrefferedSizeImpl() {
        return new Point(600, -1);
    }

    protected void savePreferences() {
        int[] weights = this.sForm.getWeights();
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        SVNTeamPreferences.setDialogInt(store, "CommitPanel.weight", weights[0] / 10);
        store.setValue("CommitPanel.keepLocks", this.keepLocks);
    }

    public void dispose() {
        super.dispose();
        SVNRemoteStorage.instance().removeResourceStatesListener(ResourceStatesChangedEvent.class, this.resourceStatesListener);
        if (this.paneParticipantHelper.isParticipantPane()) {
            this.paneParticipantHelper.dispose();
        }
    }

    public static String validateResources(IResource[] resources) {
        String message = null;
        int highestProblemSeverity = CommitPanel.getHighestProblemSeverity(resources);
        switch (highestProblemSeverity) {
            case 1: {
                message = SVNUIMessages.CommitPanel_Resource_Validation_Warning_Message;
                break;
            }
            case 2: {
                message = SVNUIMessages.CommitPanel_Resource_Validation_Error_Message;
            }
        }
        return message;
    }

    public static int getHighestProblemSeverity(IResource[] resources) {
        int res = -1;
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            try {
                int problemSeverity = resource.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0);
                res = problemSeverity > res ? problemSeverity : res;
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectPropertiesOperation
    extends AbstractActionOperation {
        protected IResource[] resources;
        protected MinLogSizePropFindVisitor minLogVisitor;
        protected LogTemplatesPropFindVisitor logTemplateVisitor;
        protected BugtraqPropFindVisitor bugtraqVisitor;
        protected MaxLogWidthPropFindVisitor maxWidthVisitor;
        protected MinLockSizePropFindVisitor minLockVisitor;
        protected CompositePropFindVisitor compositeVisitor;

        public CollectPropertiesOperation(IResource[] resources) {
            super("Operation_CollectProperties", SVNUIMessages.class);
            this.resources = resources;
            this.logTemplateVisitor = new LogTemplatesPropFindVisitor();
            this.bugtraqVisitor = new BugtraqPropFindVisitor();
            this.minLogVisitor = new MinLogSizePropFindVisitor();
            this.maxWidthVisitor = new MaxLogWidthPropFindVisitor();
            this.minLockVisitor = new MinLockSizePropFindVisitor();
            this.compositeVisitor = SVNTeamPreferences.getCommentTemplatesBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "comment.logTemplates.enabled") ? new CompositePropFindVisitor(new IPropFindVisitor[]{this.logTemplateVisitor, this.bugtraqVisitor, this.minLogVisitor, this.maxWidthVisitor, this.minLockVisitor}) : new CompositePropFindVisitor(new IPropFindVisitor[]{this.bugtraqVisitor, this.minLogVisitor, this.maxWidthVisitor, this.minLockVisitor});
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            ArrayList<IResource> parentProperties = new ArrayList<IResource>();
            int length = this.resources.length < 100 ? this.resources.length : 100;
            int i = 0;
            while (i < length && !monitor.isCanceled()) {
                ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)this, (String)this.resources[i].getFullPath().toString());
                ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(this.resources[i]);
                IResource resourceToProcess = this.resources[i];
                while (IStateFilter.SF_UNVERSIONED.accept(local) || IStateFilter.SF_TREE_CONFLICTING.accept(local) && !IStateFilter.SF_TREE_CONFLICTING_REPOSITORY_EXIST.accept(local)) {
                    resourceToProcess = resourceToProcess.getParent();
                    local = SVNRemoteStorage.instance().asLocalResourceAccessible(resourceToProcess);
                }
                if (!this.processProperty(resourceToProcess, parentProperties, monitor)) break;
                ProgressMonitorUtility.progress((IProgressMonitor)monitor, (int)i, (int)length);
                ++i;
            }
        }

        protected boolean processProperty(IResource resource, ArrayList<IResource> parentProperties, IProgressMonitor monitor) {
            SVNProperty[] properties;
            if (parentProperties.contains(resource) || monitor.isCanceled()) {
                return true;
            }
            GetPropertiesOperation op = new GetPropertiesOperation(resource);
            ProgressMonitorUtility.doTaskExternalDefault((IActionOperation)op, (IProgressMonitor)monitor);
            if (op.getExecutionState() == 0 && (properties = op.getProperties()) != null) {
                int i = 0;
                while (i < properties.length) {
                    if (!this.compositeVisitor.visit(properties[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            parentProperties.add(resource);
            IContainer parent = resource.getParent();
            if (!(parent == null || parent instanceof IWorkspaceRoot || monitor.isCanceled() || IStateFilter.SF_UNVERSIONED.accept(SVNRemoteStorage.instance().asLocalResource((IResource)parent)))) {
                return this.processProperty((IResource)parent, parentProperties, monitor);
            }
            return true;
        }

        public HashSet getLogTemplates() {
            return this.logTemplateVisitor.getLogTemplates();
        }

        public BugtraqModel getBugtraqModel() {
            return this.bugtraqVisitor.getBugtraqModel();
        }

        public int getMinLogSize() {
            return this.minLogVisitor.getMinLogSize();
        }

        public int getMinLockSize() {
            return this.minLockVisitor.getMinLockSize();
        }

        public int getMaxLogWidth() {
            return this.maxWidthVisitor.getMaxLogWidth();
        }
    }
}

