/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.remote;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IDisassembly;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisassemblyProxy
implements IDisassembly {
    private final IChannel channel;

    public DisassemblyProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public String getName() {
        return "Disassembly";
    }

    @Override
    public IToken getCapabilities(String context_id, final IDisassembly.DoneGetCapabilities done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getCapabilities", (Object[])new Object[]{context_id}){

            public void done(Exception error, Object[] args) {
                Map[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = DisassemblyProxy.toCapabilitiesArray(args[1]);
                }
                done.doneGetCapabilities(this.token, error, arr);
            }
        }.token;
    }

    @Override
    public IToken disassemble(String context_id, Number addr, int size, Map<String, Object> params, final IDisassembly.DoneDisassemble done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"disassemble", (Object[])new Object[]{context_id, addr, Integer.valueOf((int)size), params}){

            public void done(Exception error, Object[] args) {
                IDisassembly.IDisassemblyLine[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = DisassemblyProxy.toDisassemblyArray(args[1]);
                }
                done.doneDisassemble(this.token, error, arr);
            }
        }.token;
    }

    private static Map<String, Object>[] toCapabilitiesArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new Map[c.size()]);
    }

    private static IDisassembly.IDisassemblyLine[] toDisassemblyArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        IDisassembly.IDisassemblyLine[] arr = new IDisassembly.IDisassemblyLine[c.size()];
        int i = 0;
        for (Map m : c) {
            arr[i++] = new DisassemblyLine(m);
        }
        return arr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DisassemblyLine
    implements IDisassembly.IDisassemblyLine {
        final Number addr;
        final int size;
        final Map<String, Object>[] instruction;

        DisassemblyLine(Map<String, Object> m) {
            this.addr = (Number)m.get("Address");
            Number size = (Number)m.get("Size");
            this.size = size != null ? size.intValue() : 0;
            Collection c = (Collection)m.get("Instruction");
            this.instruction = c.toArray(new Map[c.size()]);
        }

        @Override
        public Number getAddress() {
            return this.addr;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public Map<String, Object>[] getInstruction() {
            return this.instruction;
        }

        public String toString() {
            StringBuffer bf = new StringBuffer();
            bf.append('[');
            bf.append(this.addr.toString());
            bf.append(' ');
            bf.append(this.size);
            bf.append(' ');
            Map<String, Object>[] mapArray = this.instruction;
            int n = this.instruction.length;
            int n2 = 0;
            while (n2 < n) {
                Map<String, Object> m = mapArray[n2];
                bf.append(m.toString());
                ++n2;
            }
            bf.append(']');
            return bf.toString();
        }
    }
}

