/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.remote;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.services.ITerminals;

public class TerminalsProxy
implements ITerminals {
    private final IChannel channel;
    private final Map<ITerminals.TerminalsListener, IChannel.IEventListener> listeners = new HashMap<ITerminals.TerminalsListener, IChannel.IEventListener>();

    public TerminalsProxy(IChannel channel) {
        this.channel = channel;
    }

    public String getName() {
        return "Terminals";
    }

    public IToken getContext(String id, final ITerminals.DoneGetContext done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getContext", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                TerminalContext ctx = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        ctx = new TerminalContext((Map)args[1]);
                    }
                }
                done.doneGetContext(this.token, error, ctx);
            }
        }.token;
    }

    public IToken launch(String type, String encoding, String[] environment, final ITerminals.DoneLaunch done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"launch", (Object[])new Object[]{type, encoding, environment}){

            public void done(Exception error, Object[] args) {
                TerminalContext ctx = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        ctx = new TerminalContext((Map)args[1]);
                    }
                }
                done.doneLaunch(this.token, error, ctx);
            }
        }.token;
    }

    public IToken setWinSize(String context_id, int newWidth, int newHeight, final ITerminals.DoneCommand done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"setWinSize", (Object[])new Object[]{context_id, Integer.valueOf((int)newWidth), Integer.valueOf((int)newHeight)}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneCommand(this.token, error);
            }
        }.token;
    }

    public IToken exit(String context_id, final ITerminals.DoneCommand done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"exit", (Object[])new Object[]{context_id}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneCommand(this.token, error);
            }
        }.token;
    }

    public void addListener(final ITerminals.TerminalsListener listener) {
        IChannel.IEventListener l = new IChannel.IEventListener(){

            public void event(String name, byte[] data) {
                block6: {
                    try {
                        Object[] args = JSON.parseSequence(data);
                        if (name.equals("exited")) {
                            if (!$assertionsDisabled && args.length != 2) {
                                throw new AssertionError();
                            }
                            listener.exited((String)args[0], ((Number)args[1]).intValue());
                            break block6;
                        }
                        if (name.equals("winSizeChanged")) {
                            if (!$assertionsDisabled && args.length != 3) {
                                throw new AssertionError();
                            }
                            listener.winSizeChanged((String)args[0], ((Number)args[1]).intValue(), ((Number)args[2]).intValue());
                            break block6;
                        }
                        throw new IOException("Terminals service: unknown event: " + name);
                    }
                    catch (Throwable x) {
                        TerminalsProxy.this.channel.terminate(x);
                    }
                }
            }
        };
        this.channel.addEventListener(this, l);
        this.listeners.put(listener, l);
    }

    public void removeListener(ITerminals.TerminalsListener listener) {
        IChannel.IEventListener l = this.listeners.remove(listener);
        if (l != null) {
            this.channel.removeEventListener(this, l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TerminalContext
    implements ITerminals.TerminalContext {
        private final Map<String, Object> props;

        TerminalContext(Map<String, Object> props) {
            this.props = props;
        }

        @Override
        public String getID() {
            return (String)this.props.get("ID");
        }

        @Override
        public String getProcessID() {
            return (String)this.props.get("ProcessID");
        }

        @Override
        public String getPtyType() {
            return (String)this.props.get("PtyType");
        }

        @Override
        public String getEncoding() {
            return (String)this.props.get("Encoding");
        }

        @Override
        public int getWidth() {
            return (Integer)this.props.get("Width");
        }

        @Override
        public int getHeight() {
            return (Integer)this.props.get("Height");
        }

        @Override
        public IToken exit(final ITerminals.DoneCommand done) {
            return new Command((IChannel)((TerminalsProxy)TerminalsProxy.this).channel, (IService)TerminalsProxy.this, (String)"exit", (Object[])new Object[]{this.getID()}){

                public void done(Exception error, Object[] args) {
                    if (error == null) {
                        if (!$assertionsDisabled && args.length != 1) {
                            throw new AssertionError();
                        }
                        error = this.toError(args[0]);
                    }
                    done.doneCommand(this.token, error);
                }
            }.token;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }

        public String toString() {
            return "[Terminals Context " + this.props.toString() + "]";
        }
    }
}

