/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.tm.tcf.core.StreamChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.Protocol;

public class ChannelPIPE
extends StreamChannel {
    private InputStream inp;
    private OutputStream out;
    private boolean started;
    private boolean closed;

    public ChannelPIPE(IPeer remote_peer, String name) {
        super(remote_peer);
        try {
            this.inp = new BufferedInputStream(new FileInputStream(name));
            byte[] buf = new byte[1024];
            int rd = this.inp.read(buf);
            if (rd <= 0 || buf[rd - 1] != 0) {
                throw new Exception("Invalid remote peer responce");
            }
            this.out = new BufferedOutputStream(new FileOutputStream(new String(buf, 0, rd - 1, "UTF-8")));
            this.onConnected(null);
        }
        catch (Exception x) {
            this.onConnected(x);
        }
    }

    private void onConnected(final Throwable x) {
        Protocol.invokeLater(new Runnable(){

            public void run() {
                if (x != null) {
                    ChannelPIPE.this.terminate(x);
                    ChannelPIPE.this.closed = true;
                }
                if (ChannelPIPE.this.closed) {
                    try {
                        if (ChannelPIPE.this.out != null) {
                            ChannelPIPE.this.out.close();
                        }
                        if (ChannelPIPE.this.inp != null) {
                            ChannelPIPE.this.inp.close();
                        }
                    }
                    catch (IOException y) {
                        Protocol.log("Cannot close pipe", y);
                    }
                } else {
                    ChannelPIPE.this.started = true;
                    ChannelPIPE.this.start();
                }
            }
        });
    }

    protected final int get() throws IOException {
        block4: {
            try {
                if (!this.closed) break block4;
                return -1;
            }
            catch (IOException x) {
                if (this.closed) {
                    return -1;
                }
                throw x;
            }
        }
        return this.inp.read();
    }

    protected final int get(byte[] buf) throws IOException {
        block4: {
            try {
                if (!this.closed) break block4;
                return -1;
            }
            catch (IOException x) {
                if (this.closed) {
                    return -1;
                }
                throw x;
            }
        }
        return this.inp.read(buf);
    }

    protected final void put(int b) throws IOException {
        assert (b >= 0 && b <= 255);
        if (this.closed) {
            return;
        }
        this.out.write(b);
    }

    protected final void put(byte[] buf) throws IOException {
        if (this.closed) {
            return;
        }
        this.out.write(buf);
    }

    protected final void flush() throws IOException {
        if (this.closed) {
            return;
        }
        this.out.flush();
    }

    protected void stop() throws IOException {
        this.closed = true;
        if (this.started) {
            this.out.close();
            this.inp.close();
        }
    }
}

