/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.protocol;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.tm.tcf.core.Base64;
import org.eclipse.tm.tcf.protocol.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSON {
    private static final Map<Class<?>, ObjectWriter<?>> object_writers = new HashMap();
    private static char[] tmp_buf = new char[4096];
    private static byte[] tmp_bbf = new byte[4096];
    private static int tmp_buf_pos;
    private static boolean zero_copy;
    private static Binary[] bin_buf;
    private static int bin_buf_pos;
    private static byte[] inp;
    private static int inp_pos;
    private static int cur_ch;
    private static final char[] err_buf;
    private static int err_buf_pos;
    private static int err_buf_cnt;

    static {
        bin_buf = new Binary[16];
        err_buf = new char[100];
    }

    public static <X> void addObjectWriter(Class<X> cls, ObjectWriter<X> writer) {
        object_writers.put(cls, writer);
    }

    public static void write(char ch) {
        if (tmp_buf_pos >= tmp_buf.length) {
            char[] tmp = new char[tmp_buf.length * 2];
            System.arraycopy(tmp_buf, 0, tmp, 0, tmp_buf_pos);
            tmp_buf = tmp;
        }
        JSON.tmp_buf[JSON.tmp_buf_pos++] = ch;
    }

    public static void write(String s) {
        int l = s.length();
        int i = 0;
        while (i < l) {
            char ch = s.charAt(i);
            if (tmp_buf_pos >= tmp_buf.length) {
                JSON.write(ch);
            } else {
                JSON.tmp_buf[JSON.tmp_buf_pos++] = ch;
            }
            ++i;
        }
    }

    public static void writeUInt(int n) {
        assert (n >= 0);
        if (n >= 10) {
            JSON.writeUInt(n / 10);
        }
        JSON.write((char)(48 + n % 10));
    }

    private static int readUTF8Char() {
        int ch;
        if (inp_pos >= inp.length) {
            return -1;
        }
        if ((ch = inp[inp_pos++]) < 0) {
            if ((ch & 0xE0) == 192) {
                ch = (ch & 0x1F) << 6;
                ch |= inp[inp_pos++] & 0x3F;
            } else if ((ch & 0xF0) == 224) {
                ch = (ch & 0xF) << 12;
                ch |= (inp[inp_pos++] & 0x3F) << 6;
                ch |= inp[inp_pos++] & 0x3F;
            } else if ((ch & 0xF0) == 240) {
                ch = (ch & 0xF) << 18;
                ch |= (inp[inp_pos++] & 0x3F) << 12;
                ch |= (inp[inp_pos++] & 0x3F) << 6;
                ch |= inp[inp_pos++] & 0x3F;
            } else {
                assert (false) : "invalid UTF-8 encoding";
                ch &= 0xFF;
            }
        }
        return ch;
    }

    private static void read() throws IOException {
        cur_ch = JSON.readUTF8Char();
        JSON.err_buf[JSON.err_buf_pos++] = (char)cur_ch;
        if (err_buf_pos >= err_buf.length) {
            err_buf_pos = 0;
            ++err_buf_cnt;
        }
    }

    private static void error() throws IOException {
        JSON.error("syntax error");
    }

    private static void error(String msg) throws IOException {
        StringBuffer bf = new StringBuffer();
        bf.append("JSON " + msg + ":");
        int cnt = 0;
        boolean nl = true;
        int i = 0;
        while (true) {
            char ch = '\u0000';
            if (err_buf_cnt == 0 && i < err_buf_pos) {
                ch = err_buf[i];
            } else if (err_buf_cnt > 0 && i < err_buf.length) {
                ch = err_buf[(err_buf_pos + i) % err_buf.length];
            } else {
                int n = JSON.readUTF8Char();
                if (n < 0) break;
                ch = (char)n;
            }
            if (nl) {
                bf.append("\n ");
                if (err_buf_cnt == 0) {
                    bf.append(cnt);
                } else {
                    bf.append('*');
                }
                bf.append(": ");
                if (cnt == 0 && err_buf_cnt > 0) {
                    bf.append("...");
                }
                nl = false;
            }
            if (ch == '\u0000') {
                ++cnt;
                nl = true;
            } else {
                bf.append(ch);
            }
            ++i;
        }
        throw new IOException(bf.toString());
    }

    private static int readHexDigit() throws IOException {
        int n = 0;
        if (cur_ch >= 48 && cur_ch <= 57) {
            n = cur_ch - 48;
        } else if (cur_ch >= 65 && cur_ch <= 70) {
            n = cur_ch - 65 + 10;
        } else if (cur_ch >= 97 && cur_ch <= 102) {
            n = cur_ch - 97 + 10;
        } else {
            JSON.error();
        }
        JSON.read();
        return n;
    }

    private static Object readFloat(boolean sign, BigInteger val) throws IOException {
        int scale = 0;
        int fraction = 0;
        if (cur_ch == 46) {
            JSON.read();
            while (cur_ch >= 48 && cur_ch <= 57) {
                val = val.multiply(BigInteger.valueOf(10L));
                val = val.add(BigInteger.valueOf(cur_ch - 48));
                ++fraction;
                JSON.read();
            }
        }
        if (cur_ch == 69 || cur_ch == 101) {
            boolean neg;
            JSON.read();
            boolean bl = neg = cur_ch == 45;
            if (neg || cur_ch == 43) {
                JSON.read();
            }
            while (cur_ch >= 48 && cur_ch <= 57) {
                scale = scale * 10 + cur_ch - 48;
                JSON.read();
            }
            if (neg) {
                scale = -scale;
            }
        }
        if (sign) {
            val = val.negate();
        }
        return new BigDecimal(val, fraction - scale);
    }

    private static Object readNestedObject() throws IOException {
        boolean neg;
        switch (cur_ch) {
            case 40: {
                JSON.read();
                int len = 0;
                while (cur_ch >= 48 && cur_ch <= 57) {
                    len = len * 10 + (cur_ch - 48);
                    JSON.read();
                }
                if (cur_ch != 41) {
                    JSON.error();
                }
                byte[] res = new byte[len];
                System.arraycopy(inp, inp_pos, res, 0, len);
                inp_pos += len;
                JSON.read();
                return res;
            }
            case 34: {
                JSON.read();
                tmp_buf_pos = 0;
                block20: while (true) {
                    if (cur_ch <= 0) {
                        JSON.error();
                    }
                    if (cur_ch == 34) break;
                    if (cur_ch == 92) {
                        JSON.read();
                        if (cur_ch <= 0) {
                            JSON.error();
                        }
                        switch (cur_ch) {
                            case 34: 
                            case 47: 
                            case 92: {
                                break;
                            }
                            case 98: {
                                cur_ch = 8;
                                break;
                            }
                            case 102: {
                                cur_ch = 12;
                                break;
                            }
                            case 110: {
                                cur_ch = 10;
                                break;
                            }
                            case 114: {
                                cur_ch = 13;
                                break;
                            }
                            case 116: {
                                cur_ch = 9;
                                break;
                            }
                            case 117: {
                                JSON.read();
                                int n = 0;
                                n |= JSON.readHexDigit() << 12;
                                n |= JSON.readHexDigit() << 8;
                                n |= JSON.readHexDigit() << 4;
                                JSON.write((char)(n |= JSON.readHexDigit()));
                                continue block20;
                            }
                            default: {
                                JSON.error();
                            }
                        }
                    }
                    if (tmp_buf_pos >= tmp_buf.length) {
                        JSON.write((char)cur_ch);
                    } else {
                        JSON.tmp_buf[JSON.tmp_buf_pos++] = (char)cur_ch;
                    }
                    JSON.read();
                }
                JSON.read();
                return new String(tmp_buf, 0, tmp_buf_pos);
            }
            case 91: {
                ArrayList<Object> l = new ArrayList<Object>();
                JSON.read();
                if (cur_ch <= 0) {
                    JSON.error();
                }
                if (cur_ch != 93) {
                    while (true) {
                        l.add(JSON.readNestedObject());
                        if (cur_ch == 93) break;
                        if (cur_ch != 44) {
                            JSON.error();
                        }
                        JSON.read();
                    }
                }
                JSON.read();
                return Collections.unmodifiableList(l);
            }
            case 123: {
                HashMap<String, Object> m = new HashMap<String, Object>();
                JSON.read();
                if (cur_ch <= 0) {
                    JSON.error();
                }
                if (cur_ch != 125) {
                    while (true) {
                        String key = (String)JSON.readNestedObject();
                        if (cur_ch != 58) {
                            JSON.error();
                        }
                        JSON.read();
                        Object val = JSON.readNestedObject();
                        m.put(key, val);
                        if (cur_ch == 125) break;
                        if (cur_ch != 44) {
                            JSON.error();
                        }
                        JSON.read();
                    }
                }
                JSON.read();
                return Collections.unmodifiableMap(m);
            }
            case 110: {
                JSON.read();
                if (cur_ch != 117) {
                    JSON.error();
                }
                JSON.read();
                if (cur_ch != 108) {
                    JSON.error();
                }
                JSON.read();
                if (cur_ch != 108) {
                    JSON.error();
                }
                JSON.read();
                return null;
            }
            case 102: {
                JSON.read();
                if (cur_ch != 97) {
                    JSON.error();
                }
                JSON.read();
                if (cur_ch != 108) {
                    JSON.error();
                }
                JSON.read();
                if (cur_ch != 115) {
                    JSON.error();
                }
                JSON.read();
                if (cur_ch != 101) {
                    JSON.error();
                }
                JSON.read();
                return Boolean.FALSE;
            }
            case 116: {
                JSON.read();
                if (cur_ch != 114) {
                    JSON.error();
                }
                JSON.read();
                if (cur_ch != 117) {
                    JSON.error();
                }
                JSON.read();
                if (cur_ch != 101) {
                    JSON.error();
                }
                JSON.read();
                return Boolean.TRUE;
            }
            case 78: {
                JSON.read();
                if (cur_ch != 97) {
                    JSON.error();
                }
                JSON.read();
                if (cur_ch != 78) {
                    JSON.error();
                }
                JSON.read();
                return Float.valueOf(Float.NaN);
            }
        }
        boolean bl = neg = cur_ch == 45;
        if (neg) {
            JSON.read();
        }
        if (cur_ch >= 48 && cur_ch <= 57) {
            int v = 0;
            while (v <= 0xCCCCCCB) {
                v = v * 10 + (cur_ch - 48);
                JSON.read();
                if (cur_ch >= 48 && cur_ch <= 57) continue;
                if (cur_ch == 46 || cur_ch == 69 || cur_ch == 101) {
                    return JSON.readFloat(neg, BigInteger.valueOf(v));
                }
                if (neg) {
                    v = -v;
                }
                return v;
            }
            long vl = v;
            while (vl < 0xCCCCCCCCCCCCCCBL) {
                vl = vl * 10L + (long)(cur_ch - 48);
                JSON.read();
                if (cur_ch >= 48 && cur_ch <= 57) continue;
                if (cur_ch == 46 || cur_ch == 69 || cur_ch == 101) {
                    return JSON.readFloat(neg, BigInteger.valueOf(vl));
                }
                if (neg) {
                    vl = -vl;
                }
                return vl;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(vl);
            do {
                sb.append((char)cur_ch);
                JSON.read();
            } while (cur_ch >= 48 && cur_ch <= 57);
            BigInteger n = new BigInteger(sb.toString());
            if (cur_ch == 46 || cur_ch == 69 || cur_ch == 101) {
                return JSON.readFloat(neg, n);
            }
            if (neg) {
                n = n.negate();
            }
            return n;
        }
        JSON.error();
        return null;
    }

    private static Object readObject() throws IOException {
        Object o = JSON.readNestedObject();
        if (cur_ch >= 0) {
            JSON.error();
        }
        return o;
    }

    private static Object[] readSequence() throws IOException {
        ArrayList<Object> l = new ArrayList<Object>();
        while (cur_ch >= 0) {
            if (cur_ch == 0) {
                l.add(null);
            } else {
                l.add(JSON.readNestedObject());
            }
            if (cur_ch != 0) {
                JSON.error("missing \\0 terminator");
            }
            JSON.read();
        }
        return l.toArray();
    }

    public static void writeObject(Object o) throws IOException {
        if (o == null) {
            JSON.write("null");
        } else if (o instanceof Boolean) {
            JSON.write(o.toString());
        } else if (o instanceof Number) {
            JSON.write(o.toString());
        } else if (o instanceof String) {
            String s = (String)o;
            char[] arr = new char[s.length()];
            s.getChars(0, arr.length, arr, 0);
            JSON.writeObject(arr);
        } else if (o instanceof char[]) {
            char[] s = (char[])o;
            JSON.write('\"');
            int l = s.length;
            int i = 0;
            while (i < l) {
                char ch = s[i];
                switch (ch) {
                    case '\u0000': {
                        JSON.write("\\u0000");
                        break;
                    }
                    case '\u0001': {
                        JSON.write("\\u0001");
                        break;
                    }
                    case '\r': {
                        JSON.write("\\r");
                        break;
                    }
                    case '\n': {
                        JSON.write("\\n");
                        break;
                    }
                    case '\t': {
                        JSON.write("\\t");
                        break;
                    }
                    case '\b': {
                        JSON.write("\\b");
                        break;
                    }
                    case '\f': {
                        JSON.write("\\f");
                        break;
                    }
                    case '\"': 
                    case '\\': {
                        JSON.write('\\');
                    }
                    default: {
                        if (tmp_buf_pos >= tmp_buf.length) {
                            JSON.write(ch);
                            break;
                        }
                        JSON.tmp_buf[JSON.tmp_buf_pos++] = ch;
                    }
                }
                ++i;
            }
            JSON.write('\"');
        } else if (o instanceof Binary) {
            Binary b = (Binary)o;
            if (zero_copy) {
                JSON.write('(');
                JSON.write(Integer.toString(b.size));
                JSON.write(')');
                JSON.write('\u0001');
                JSON.bin_buf[JSON.bin_buf_pos++] = b;
            } else {
                JSON.writeObject(Base64.toBase64(b.bytes, b.offs, b.size));
            }
        } else if (o instanceof byte[]) {
            JSON.write('[');
            byte[] arr = (byte[])o;
            boolean comma = false;
            int i = 0;
            while (i < arr.length) {
                if (comma) {
                    JSON.write(',');
                }
                JSON.writeUInt(arr[i] & 0xFF);
                comma = true;
                ++i;
            }
            JSON.write(']');
        } else if (o instanceof Object[]) {
            JSON.write('[');
            Object[] arr = (Object[])o;
            boolean comma = false;
            int i = 0;
            while (i < arr.length) {
                if (comma) {
                    JSON.write(',');
                }
                JSON.writeObject(arr[i]);
                comma = true;
                ++i;
            }
            JSON.write(']');
        } else if (o instanceof Collection) {
            JSON.write('[');
            boolean comma = false;
            Iterator i = ((Collection)o).iterator();
            while (i.hasNext()) {
                if (comma) {
                    JSON.write(',');
                }
                JSON.writeObject(i.next());
                comma = true;
            }
            JSON.write(']');
        } else if (o instanceof Map) {
            Map map = (Map)o;
            JSON.write('{');
            boolean comma = false;
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                if (comma) {
                    JSON.write(',');
                }
                Map.Entry e = i.next();
                JSON.writeObject(e.getKey());
                JSON.write(':');
                JSON.writeObject(e.getValue());
                comma = true;
            }
            JSON.write('}');
        } else {
            ObjectWriter<?> writer = object_writers.get(o.getClass());
            if (writer == null) {
                for (Class<?> c : object_writers.keySet()) {
                    if (!c.isInstance(o)) continue;
                    writer = object_writers.get(c);
                    break;
                }
            }
            if (writer != null) {
                writer.write(o);
            } else {
                throw new IOException("JSON: unsupported object type:" + o.getClass());
            }
        }
    }

    private static byte[] toBytes() {
        int inp_pos = 0;
        int out_pos = 0;
        int blc_pos = 0;
        while (inp_pos < tmp_buf_pos) {
            char ch;
            if (out_pos > tmp_bbf.length - 4) {
                byte[] tmp = new byte[tmp_bbf.length * 2];
                System.arraycopy(tmp_bbf, 0, tmp, 0, out_pos);
                tmp_bbf = tmp;
            }
            if ((ch = tmp_buf[inp_pos++]) == '\u0001') {
                Binary b = bin_buf[blc_pos++];
                while (out_pos > tmp_bbf.length - b.size) {
                    byte[] tmp = new byte[tmp_bbf.length * 2];
                    System.arraycopy(tmp_bbf, 0, tmp, 0, out_pos);
                    tmp_bbf = tmp;
                }
                System.arraycopy(b.bytes, b.offs, tmp_bbf, out_pos, b.size);
                out_pos += b.size;
                continue;
            }
            if (ch < '\u0080') {
                JSON.tmp_bbf[out_pos++] = (byte)ch;
                continue;
            }
            if (ch < '\u0800') {
                JSON.tmp_bbf[out_pos++] = (byte)(ch >> 6 | 0xC0);
                JSON.tmp_bbf[out_pos++] = (byte)(ch & 0x3F | 0x80);
                continue;
            }
            if (ch < '\u10000') {
                JSON.tmp_bbf[out_pos++] = (byte)(ch >> 12 | 0xE0);
                JSON.tmp_bbf[out_pos++] = (byte)(ch >> 6 & 0x3F | 0x80);
                JSON.tmp_bbf[out_pos++] = (byte)(ch & 0x3F | 0x80);
                continue;
            }
            JSON.tmp_bbf[out_pos++] = (byte)(ch >> 18 | 0xF0);
            JSON.tmp_bbf[out_pos++] = (byte)(ch >> 12 & 0x3F | 0x80);
            JSON.tmp_bbf[out_pos++] = (byte)(ch >> 6 & 0x3F | 0x80);
            JSON.tmp_bbf[out_pos++] = (byte)(ch & 0x3F | 0x80);
        }
        byte[] res = new byte[out_pos];
        System.arraycopy(tmp_bbf, 0, res, 0, out_pos);
        return res;
    }

    public static String toJSON(Object o) throws IOException {
        assert (Protocol.isDispatchThread());
        tmp_buf_pos = 0;
        bin_buf_pos = 0;
        zero_copy = false;
        JSON.writeObject(o);
        return new String(tmp_buf, 0, tmp_buf_pos);
    }

    public static byte[] toJASONBytes(Object o) throws IOException {
        assert (Protocol.isDispatchThread());
        tmp_buf_pos = 0;
        bin_buf_pos = 0;
        zero_copy = false;
        JSON.writeObject(o);
        return JSON.toBytes();
    }

    public static byte[] toJSONSequence(Object[] o) throws IOException {
        assert (Protocol.isDispatchThread());
        if (o == null || o.length == 0) {
            return null;
        }
        tmp_buf_pos = 0;
        bin_buf_pos = 0;
        zero_copy = false;
        int i = 0;
        while (i < o.length) {
            JSON.writeObject(o[i]);
            JSON.write('\u0000');
            ++i;
        }
        return JSON.toBytes();
    }

    public static byte[] toJSONSequence(Object[] o, boolean zero_copy) throws IOException {
        assert (Protocol.isDispatchThread());
        if (o == null || o.length == 0) {
            return null;
        }
        tmp_buf_pos = 0;
        bin_buf_pos = 0;
        JSON.zero_copy = zero_copy;
        int i = 0;
        while (i < o.length) {
            JSON.writeObject(o[i]);
            JSON.write('\u0000');
            ++i;
        }
        return JSON.toBytes();
    }

    public static Object parseOne(byte[] b) throws IOException {
        assert (Protocol.isDispatchThread());
        if (b.length == 0) {
            return null;
        }
        inp = b;
        inp_pos = 0;
        err_buf_pos = 0;
        err_buf_cnt = 0;
        JSON.read();
        return JSON.readObject();
    }

    public static Object[] parseSequence(byte[] b) throws IOException {
        assert (Protocol.isDispatchThread());
        inp = b;
        inp_pos = 0;
        err_buf_pos = 0;
        err_buf_cnt = 0;
        JSON.read();
        return JSON.readSequence();
    }

    public static byte[] toByteArray(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (o instanceof char[]) {
            return Base64.toByteArray((char[])o);
        }
        if (o instanceof String) {
            return Base64.toByteArray(((String)o).toCharArray());
        }
        throw new Error();
    }

    public static void toByteArray(byte[] buf, int offs, int size, Object o) {
        if (o instanceof char[]) {
            Base64.toByteArray(buf, offs, size, (char[])o);
        } else if (o instanceof String) {
            Base64.toByteArray(buf, offs, size, ((String)o).toCharArray());
        } else if (o != null) {
            System.arraycopy(JSON.toByteArray(o), 0, buf, offs, size);
        }
    }

    public static final class Binary {
        public final byte[] bytes;
        public final int offs;
        public final int size;

        public Binary(byte[] bytes, int offs, int size) {
            this.bytes = bytes;
            this.offs = offs;
            this.size = size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ObjectWriter<V> {
        public void write(V var1) throws IOException;
    }
}

