/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.services;

import java.math.BigInteger;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;

public interface ILineNumbers
extends IService {
    public static final String NAME = "LineNumbers";

    public IToken mapToSource(String var1, Number var2, Number var3, DoneMapToSource var4);

    public IToken mapToMemory(String var1, String var2, int var3, int var4, DoneMapToMemory var5);

    public static final class CodeArea {
        public final String directory;
        public final String file;
        public final int start_line;
        public final int start_column;
        public final int end_line;
        public final int end_column;
        public final Number start_address;
        public final Number end_address;
        public final int isa;
        public final boolean is_statement;
        public final boolean basic_block;
        public final boolean prologue_end;
        public final boolean epilogue_begin;

        public CodeArea(String directory, String file, int start_line, int start_column, int end_line, int end_column, Number start_address, Number end_address, int isa, boolean is_statement, boolean basic_block, boolean prologue_end, boolean epilogue_begin) {
            this.directory = directory;
            this.file = file;
            this.start_line = start_line;
            this.start_column = start_column;
            this.end_line = end_line;
            this.end_column = end_column;
            this.start_address = start_address;
            this.end_address = end_address;
            this.isa = isa;
            this.is_statement = is_statement;
            this.basic_block = basic_block;
            this.prologue_end = prologue_end;
            this.epilogue_begin = epilogue_begin;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CodeArea)) {
                return false;
            }
            CodeArea a = (CodeArea)o;
            if (this.start_line != a.start_line) {
                return false;
            }
            if (this.start_column != a.start_column) {
                return false;
            }
            if (this.end_line != a.end_line) {
                return false;
            }
            if (this.end_column != a.end_column) {
                return false;
            }
            if (this.isa != a.isa) {
                return false;
            }
            if (this.is_statement != a.is_statement) {
                return false;
            }
            if (this.basic_block != a.basic_block) {
                return false;
            }
            if (this.prologue_end != a.prologue_end) {
                return false;
            }
            if (this.epilogue_begin != a.epilogue_begin) {
                return false;
            }
            if (this.start_address != null && !this.start_address.equals(a.start_address)) {
                return false;
            }
            if (this.start_address == null && a.start_address != null) {
                return false;
            }
            if (this.end_address != null && !this.end_address.equals(a.end_address)) {
                return false;
            }
            if (this.end_address == null && a.end_address != null) {
                return false;
            }
            if (this.file != null && !this.file.equals(a.file)) {
                return false;
            }
            if (this.file == null && a.file != null) {
                return false;
            }
            if (this.directory != null && !this.directory.equals(a.directory)) {
                return false;
            }
            return this.directory != null || a.directory == null;
        }

        public int hashCode() {
            int h = 0;
            if (this.file != null) {
                h += this.file.hashCode();
            }
            return h + this.start_line + this.start_column + this.end_line + this.end_column;
        }

        public String toString() {
            StringBuffer bf = new StringBuffer();
            bf.append('[');
            if (this.directory != null) {
                bf.append(this.directory);
                bf.append(':');
            }
            if (this.file != null) {
                bf.append(this.file);
                bf.append(':');
            }
            bf.append(this.start_line);
            if (this.start_column != 0) {
                bf.append('.');
                bf.append(this.start_column);
            }
            bf.append("..");
            bf.append(this.end_line);
            if (this.end_column != 0) {
                bf.append('.');
                bf.append(this.end_column);
            }
            bf.append(" -> ");
            if (this.start_address != null) {
                bf.append("0x");
                bf.append(new BigInteger(this.start_address.toString()).toString(16));
            } else {
                bf.append('0');
            }
            bf.append("..");
            if (this.end_address != null) {
                bf.append("0x");
                bf.append(new BigInteger(this.end_address.toString()).toString(16));
            } else {
                bf.append('0');
            }
            if (this.isa != 0) {
                bf.append(",isa ");
                bf.append(this.isa);
            }
            if (this.is_statement) {
                bf.append(",statement");
            }
            if (this.basic_block) {
                bf.append(",basic block");
            }
            if (this.prologue_end) {
                bf.append(",prologue end");
            }
            if (this.epilogue_begin) {
                bf.append(",epilogue begin");
            }
            bf.append(']');
            return bf.toString();
        }
    }

    public static interface DoneMapToMemory {
        public void doneMapToMemory(IToken var1, Exception var2, CodeArea[] var3);
    }

    public static interface DoneMapToSource {
        public void doneMapToSource(IToken var1, Exception var2, CodeArea[] var3);
    }
}

