/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.util;

import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCFDataCache<V>
implements Runnable {
    private Throwable error;
    private boolean valid;
    private boolean posted;
    private boolean disposed;
    private V data;
    protected final IChannel channel;
    protected IToken command;
    private Runnable[] waiting_list = null;
    private int waiting_cnt;

    public TCFDataCache(IChannel channel) {
        assert (channel != null);
        this.channel = channel;
    }

    private void post() {
        if (this.posted) {
            return;
        }
        if (this.waiting_cnt == 0) {
            return;
        }
        Protocol.invokeLater(this);
        this.posted = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isPending() {
        return this.command != null;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Throwable getError() {
        assert (this.valid);
        return this.error;
    }

    public V getData() {
        assert (Protocol.isDispatchThread());
        assert (this.valid);
        return this.data;
    }

    @Override
    public final void run() {
        assert (Protocol.isDispatchThread());
        this.posted = false;
        if (this.waiting_cnt > 0) {
            int cnt = this.waiting_cnt;
            Runnable[] arr = this.waiting_list;
            this.waiting_list = null;
            this.waiting_cnt = 0;
            int i = 0;
            while (i < cnt) {
                Runnable r = arr[i];
                if (!(r instanceof TCFDataCache) || !((TCFDataCache)r).posted) {
                    r.run();
                }
                ++i;
            }
            if (this.waiting_list == null) {
                this.waiting_list = arr;
            }
        }
    }

    public void wait(Runnable cb) {
        assert (Protocol.isDispatchThread());
        assert (!this.disposed);
        assert (!this.valid);
        if (cb != null && !this.isWaiting(cb)) {
            if (this.waiting_list == null) {
                this.waiting_list = new Runnable[8];
            }
            if (this.waiting_cnt >= this.waiting_list.length) {
                Runnable[] tmp = new Runnable[this.waiting_cnt * 2];
                System.arraycopy(this.waiting_list, 0, tmp, 0, this.waiting_list.length);
                this.waiting_list = tmp;
            }
            this.waiting_list[this.waiting_cnt++] = cb;
        }
    }

    public boolean isWaiting(Runnable cb) {
        if (this.waiting_list == null) {
            return false;
        }
        int i = 0;
        while (i < this.waiting_cnt) {
            if (this.waiting_list[i] == cb) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean validate() {
        assert (Protocol.isDispatchThread());
        if (this.disposed || this.channel.getState() != 1) {
            this.command = null;
            this.valid = true;
            this.error = null;
            this.data = null;
        } else {
            if (this.command != null) {
                return false;
            }
            if (!this.valid && !this.startDataRetrieval()) {
                return false;
            }
        }
        assert (this.valid);
        assert (this.command == null);
        this.post();
        return true;
    }

    public boolean validate(Runnable cb) {
        if (!this.validate()) {
            this.wait(cb);
            return false;
        }
        return true;
    }

    public void start(IToken command) {
        assert (!this.valid);
        assert (command != null);
        assert (this.command == null);
        this.command = command;
    }

    public void done(IToken command) {
        if (this.command != command) {
            return;
        }
        assert (!this.valid);
        this.command = null;
        this.post();
    }

    public void set(IToken token, Throwable error, V data) {
        assert (Protocol.isDispatchThread());
        if (token != null && this.command != token) {
            return;
        }
        this.command = null;
        if (!this.disposed) {
            assert (!this.valid);
            if (this.channel.getState() != 1) {
                error = null;
                data = null;
            }
            this.error = error;
            this.data = data;
            this.valid = true;
        }
        this.post();
    }

    public void reset(V data) {
        assert (Protocol.isDispatchThread());
        if (this.command != null) {
            this.command.cancel();
            this.command = null;
        }
        if (!this.disposed) {
            this.data = data;
            this.error = null;
            this.valid = true;
        }
        this.post();
    }

    public void reset() {
        assert (Protocol.isDispatchThread());
        if (!this.disposed) {
            this.error = null;
            this.valid = false;
            this.data = null;
        }
        this.post();
    }

    public void cancel() {
        this.reset();
        if (this.command != null) {
            this.command.cancel();
            this.command = null;
        }
    }

    public void dispose() {
        this.cancel();
        this.valid = true;
        this.disposed = true;
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        bf.append('[');
        if (this.valid) {
            bf.append("valid,");
        }
        if (this.disposed) {
            bf.append("disposed,");
        }
        if (this.posted) {
            bf.append("posted,");
        }
        if (this.error != null) {
            bf.append("error,");
        }
        bf.append("data=");
        bf.append(this.data == null ? "null" : this.data.toString());
        bf.append(']');
        return bf.toString();
    }

    protected abstract boolean startDataRetrieval();
}

