/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IFileSystem;
import org.eclipse.tm.tcf.util.TCFTask;

public final class TCFFileInputStream
extends InputStream {
    private static final int MAX_READ_AHEAD = 8;
    private final IFileSystem.IFileHandle handle;
    private final IFileSystem fs;
    private final int buf_size;
    private long mark = 0L;
    private long offset = 0L;
    private Buffer buf;
    private boolean closed = false;
    private boolean suspend_read_ahead;
    private Runnable waiting_client;
    private final LinkedList<Buffer> read_ahead_buffers = new LinkedList();

    public TCFFileInputStream(IFileSystem.IFileHandle handle) {
        this(handle, 4096);
    }

    public TCFFileInputStream(IFileSystem.IFileHandle handle, int buf_size) {
        this.handle = handle;
        this.fs = handle.getService();
        this.buf_size = buf_size;
    }

    private void startReadAhead(Buffer prv) {
        if (this.suspend_read_ahead) {
            return;
        }
        if (this.read_ahead_buffers.size() > 0) {
            prv = this.read_ahead_buffers.getLast();
        }
        if (prv.eof) {
            return;
        }
        long pos = prv.offset + (long)(prv.buf == null ? this.buf_size : prv.buf.length);
        while (this.read_ahead_buffers.size() < 8) {
            final Buffer buf = new Buffer(pos);
            buf.token = this.fs.read(this.handle, pos, this.buf_size, new IFileSystem.DoneRead(){

                public void doneRead(IToken token, IFileSystem.FileSystemException error, byte[] data, boolean eof) {
                    if (!$assertionsDisabled && buf.token != token) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !TCFFileInputStream.this.read_ahead_buffers.contains(buf)) {
                        throw new AssertionError();
                    }
                    buf.token = null;
                    if (error != null) {
                        TCFFileInputStream.this.suspend_read_ahead = true;
                        TCFFileInputStream.this.read_ahead_buffers.remove(buf);
                    } else if (data.length != TCFFileInputStream.this.buf_size) {
                        buf.buf = data;
                        buf.eof = eof;
                        if (!eof) {
                            TCFFileInputStream.this.suspend_read_ahead = true;
                        }
                    } else {
                        buf.buf = data;
                        buf.eof = eof;
                        TCFFileInputStream.this.startReadAhead(buf);
                    }
                    if (TCFFileInputStream.this.waiting_client != null) {
                        Protocol.invokeLater(TCFFileInputStream.this.waiting_client);
                        TCFFileInputStream.this.waiting_client = null;
                    }
                }
            });
            this.read_ahead_buffers.add(buf);
            pos += (long)this.buf_size;
        }
    }

    private boolean stopReadAhead(Runnable done) {
        this.suspend_read_ahead = true;
        Iterator i = this.read_ahead_buffers.iterator();
        while (i.hasNext()) {
            Buffer buf = (Buffer)i.next();
            if (buf.token != null && !buf.token.cancel()) continue;
            i.remove();
        }
        if (this.read_ahead_buffers.size() > 0) {
            assert (this.waiting_client == null);
            this.waiting_client = done;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int read() throws IOException {
        if (!this.closed) ** GOTO lbl8
        throw new IOException("Stream is closed");
lbl-1000:
        // 1 sources

        {
            if (this.buf != null && this.buf.eof) {
                return -1;
            }
            this.buf = (Buffer)new TCFTask<Buffer>(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    if (TCFFileInputStream.$assertionsDisabled || TCFFileInputStream.access$4(TCFFileInputStream.this) == null) ** GOTO lbl21
                    throw new AssertionError();
lbl-1000:
                    // 1 sources

                    {
                        buf = (Buffer)TCFFileInputStream.access$0(TCFFileInputStream.this).getFirst();
                        if (buf.offset == TCFFileInputStream.access$6(TCFFileInputStream.this)) {
                            if (buf.token != null) {
                                TCFFileInputStream.access$5(TCFFileInputStream.this, this);
                            } else {
                                TCFFileInputStream.access$3(TCFFileInputStream.this, buf);
                                TCFFileInputStream.access$0(TCFFileInputStream.this).remove(buf);
                                this.done(buf);
                            }
                            return;
                        }
                        TCFFileInputStream.access$1(TCFFileInputStream.this, true);
                        if (buf.token != null && buf.token.cancel()) {
                            buf.token = null;
                        }
                        if (buf.token != null) {
                            TCFFileInputStream.access$5(TCFFileInputStream.this, this);
                            return;
                        }
                        TCFFileInputStream.access$0(TCFFileInputStream.this).remove(buf);
lbl21:
                        // 2 sources

                        ** while (TCFFileInputStream.access$0((TCFFileInputStream)TCFFileInputStream.this).size() > 0)
                    }
lbl22:
                    // 1 sources

                    TCFFileInputStream.access$7(TCFFileInputStream.this).read(TCFFileInputStream.access$8(TCFFileInputStream.this), TCFFileInputStream.access$6(TCFFileInputStream.this), TCFFileInputStream.access$2(TCFFileInputStream.this), new IFileSystem.DoneRead(){

                        public void doneRead(IToken token, IFileSystem.FileSystemException error, byte[] data, boolean eof) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            if (!($assertionsDisabled || data != null && data.length <= TCFFileInputStream.this.buf_size)) {
                                throw new AssertionError();
                            }
                            Buffer buf = new Buffer(TCFFileInputStream.this.offset);
                            buf.buf = data;
                            buf.eof = eof;
                            if (!eof) {
                                TCFFileInputStream.this.suspend_read_ahead = false;
                                TCFFileInputStream.this.startReadAhead(buf);
                            }
                            this.done(buf);
                        }
                    });
                }
            }.getIO();
            if (!TCFFileInputStream.$assertionsDisabled && this.buf.token != null) {
                throw new AssertionError();
            }
lbl8:
            // 3 sources

            ** while (this.buf == null || this.buf.offset > this.offset || this.buf.offset + (long)this.buf.buf.length <= this.offset)
        }
lbl9:
        // 1 sources

        ofs = (int)(this.offset++ - this.buf.offset);
        return this.buf.buf[ofs] & 255;
    }

    public synchronized int read(byte[] arr, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (arr == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > arr.length - off) {
            throw new IndexOutOfBoundsException();
        }
        int pos = 0;
        while (pos < len) {
            if (this.buf != null && this.buf.offset <= this.offset && this.buf.offset + (long)this.buf.buf.length > this.offset) {
                int buf_pos = (int)(this.offset - this.buf.offset);
                int buf_len = this.buf.buf.length - buf_pos;
                int n = len - pos < buf_len ? len - pos : buf_len;
                System.arraycopy(this.buf.buf, buf_pos, arr, off + pos, n);
                pos += n;
                this.offset += (long)n;
                continue;
            }
            int c = this.read();
            if (c == -1) {
                if (pos != 0) break;
                return -1;
            }
            arr[off + pos++] = (byte)c;
        }
        return pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void reset() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.offset = this.mark;
        if (this.buf != null && this.buf.offset <= this.offset && this.buf.offset + (long)this.buf.buf.length > this.offset) {
            return;
        }
        new TCFTask<Object>(){

            @Override
            public void run() {
                if (!TCFFileInputStream.this.stopReadAhead(this)) {
                    return;
                }
                this.done(this);
            }
        }.getIO();
        this.buf = null;
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.offset;
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        new TCFTask<Object>(){

            @Override
            public void run() {
                if (!TCFFileInputStream.this.stopReadAhead(this)) {
                    return;
                }
                if (!$assertionsDisabled && !TCFFileInputStream.this.read_ahead_buffers.isEmpty()) {
                    throw new AssertionError();
                }
                TCFFileInputStream.this.fs.close(TCFFileInputStream.this.handle, new IFileSystem.DoneClose(){

                    public void doneClose(IToken token, IFileSystem.FileSystemException error) {
                        if (error != null) {
                            this.error(error);
                        } else {
                            this.done(this);
                        }
                    }
                });
            }
        }.getIO();
        this.closed = true;
        this.buf = null;
    }

    private static class Buffer {
        final long offset;
        IToken token;
        byte[] buf;
        boolean eof;

        Buffer(long offset) {
            this.offset = offset;
        }

        public String toString() {
            return "[" + this.offset + ":" + (this.buf == null ? "null" : Integer.toString(this.buf.length)) + "]";
        }
    }
}

