/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.HashMap;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExpression;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;

class TCFChildrenHoverExpressions
extends TCFChildren {
    TCFChildrenHoverExpressions(TCFNode parent) {
        super(parent, 16);
    }

    void onSuspended() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onSuspended();
        }
    }

    void onRegisterValueChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onRegisterValueChanged();
        }
    }

    private TCFNodeExpression findScript(String text) {
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression e = (TCFNodeExpression)n;
            if (!text.equals(e.getScript())) continue;
            return e;
        }
        return null;
    }

    protected boolean startDataRetrieval() {
        HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
        String expression_script = null;
        if (this.node instanceof TCFNodeExecContext) {
            expression_script = ((TCFNodeExecContext)this.node).getHoverExpression();
        } else if (this.node instanceof TCFNodeStackFrame) {
            expression_script = ((TCFNodeStackFrame)this.node).getHoverExpression();
        }
        if (expression_script != null) {
            TCFNodeExpression expression_node = this.findScript(expression_script);
            if (expression_node == null) {
                expression_node = new TCFNodeExpression(this.node, expression_script, null, null, -1, false);
                this.add(expression_node);
            }
            data.put(expression_node.id, expression_node);
        }
        this.set(null, null, data);
        return true;
    }
}

