/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IStackTrace;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFChildrenStackTrace
extends TCFChildren {
    private final TCFNodeExecContext node;
    private String top_frame_id;

    TCFChildrenStackTrace(TCFNodeExecContext node) {
        super(node, 16);
        this.node = node;
    }

    void onSourceMappingChange() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).onSourceMappingChange();
        }
    }

    void onExpressionAddedOrRemoved() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).onExpressionAddedOrRemoved();
        }
    }

    void onSuspended() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).onSuspended();
        }
        this.reset();
    }

    void onRegistersChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).onRegistersChanged();
        }
        this.reset();
    }

    void onMemoryMapChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).onMemoryMapChanged();
        }
        this.reset();
    }

    void onRegisterValueChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).onRegisterValueChanged();
        }
        this.reset();
    }

    void onResumed() {
        this.reset(null);
    }

    void postAllChangedDelta() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).postAllChangedDelta();
        }
    }

    public TCFNodeStackFrame getTopFrame() {
        assert (this.isValid());
        return (TCFNodeStackFrame)this.node.model.getNode(this.top_frame_id);
    }

    @Override
    public void set(IToken token, Throwable error, Map<String, TCFNode> data) {
        for (TCFNode n : this.getNodes()) {
            if (data != null && data.get(n.id) != null) continue;
            ((TCFNodeStackFrame)n).setFrameNo(-1);
        }
        super.set(token, error, data);
    }

    private void addEmulatedTopFrame(HashMap<String, TCFNode> data) {
        this.top_frame_id = String.valueOf(this.node.id) + "-TF";
        TCFNodeStackFrame n = (TCFNodeStackFrame)this.node.model.getNode(this.top_frame_id);
        if (n == null) {
            n = new TCFNodeStackFrame(this.node, this.top_frame_id, true);
        }
        n.setFrameNo(0);
        data.put(n.id, n);
    }

    protected boolean startDataRetrieval() {
        TCFDataCache<TCFContextState> state = this.node.getState();
        if (!state.validate((Runnable)((Object)this))) {
            return false;
        }
        if (this.node.isNotActive()) {
            this.top_frame_id = null;
            this.set(null, null, new HashMap<String, TCFNode>());
            return true;
        }
        Throwable state_error = state.getError();
        TCFContextState state_data = (TCFContextState)state.getData();
        if (state_error != null || state_data == null || !state_data.is_suspended) {
            this.set(null, state_error, null);
            return true;
        }
        final HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
        IStackTrace st = (IStackTrace)this.node.model.getLaunch().getService(IStackTrace.class);
        if (st == null) {
            this.addEmulatedTopFrame(data);
            this.set(null, null, data);
            return true;
        }
        assert (this.command == null);
        this.command = st.getChildren(this.node.id, new IStackTrace.DoneGetChildren(){

            public void doneGetChildren(IToken token, Exception error, String[] contexts) {
                if (TCFChildrenStackTrace.this.command == token) {
                    if (error == null && contexts != null) {
                        int cnt = contexts.length;
                        String[] stringArray = contexts;
                        int n = contexts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String id = stringArray[n2];
                            --cnt;
                            TCFNodeStackFrame n3 = (TCFNodeStackFrame)((TCFChildrenStackTrace)TCFChildrenStackTrace.this).node.model.getNode(id);
                            if (n3 == null) {
                                n3 = new TCFNodeStackFrame(TCFChildrenStackTrace.this.node, id, false);
                            }
                            if (!$assertionsDisabled && n3.parent != TCFChildrenStackTrace.this.node) {
                                throw new AssertionError();
                            }
                            n3.setFrameNo(cnt);
                            data.put(id, n3);
                            if (cnt == 0) {
                                TCFChildrenStackTrace.this.top_frame_id = id;
                            }
                            ++n2;
                        }
                    }
                    if (data.size() == 0) {
                        TCFChildrenStackTrace.this.addEmulatedTopFrame(data);
                    }
                }
                TCFChildrenStackTrace.this.set(token, (Throwable)error, data);
            }
        });
        return false;
    }
}

