/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;

class TCFConsole {
    private final TCFModel model;
    private final IOConsole console;
    private final Display display;
    private final LinkedList<Message> out_queue;
    private final Thread inp_thread = new Thread(){

        public void run() {
            try {
                int len;
                IOConsoleInputStream inp = TCFConsole.this.console.getInputStream();
                final byte[] buf = new byte[256];
                while ((len = inp.read(buf)) >= 0) {
                    if (len == 2 && buf[0] == 13 && buf[1] == 10) {
                        len = 1;
                    }
                    final int n = len;
                    Protocol.invokeAndWait((Runnable)new Runnable(){

                        public void run() {
                            try {
                                TCFConsole.this.model.getLaunch().writeProcessInputStream(buf, 0, n);
                            }
                            catch (Exception x) {
                                TCFConsole.this.model.onProcessStreamError(null, 0, x, 0);
                            }
                        }
                    });
                }
            }
            catch (Throwable x) {
                Activator.log("Cannot read console input", x);
            }
        }
    };
    private final Thread out_thread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HashMap<Integer, IOConsoleOutputStream> out_streams = new HashMap<Integer, IOConsoleOutputStream>();
            try {
                while (true) {
                    Message m = null;
                    LinkedList linkedList = TCFConsole.this.out_queue;
                    synchronized (linkedList) {
                        while (TCFConsole.this.out_queue.size() == 0) {
                            TCFConsole.this.out_queue.wait();
                        }
                        m = (Message)TCFConsole.this.out_queue.removeFirst();
                    }
                    if (m.data != null) {
                        IOConsoleOutputStream stream = (IOConsoleOutputStream)out_streams.get(m.stream_id);
                        if (stream == null) {
                            final int id = m.stream_id;
                            final IOConsoleOutputStream s = stream = TCFConsole.this.console.newOutputStream();
                            TCFConsole.this.display.syncExec(new Runnable(){

                                public void run() {
                                    try {
                                        int color_id = 2;
                                        switch (id) {
                                            case 1: {
                                                color_id = 3;
                                                break;
                                            }
                                            case 2: {
                                                color_id = 9;
                                                break;
                                            }
                                            case 3: {
                                                color_id = 5;
                                            }
                                        }
                                        s.setColor(TCFConsole.this.display.getSystemColor(color_id));
                                    }
                                    catch (Throwable x) {
                                        Activator.log("Cannot open console view", x);
                                    }
                                }
                            });
                            out_streams.put(m.stream_id, stream);
                        }
                        stream.write(m.data, 0, m.data.length);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable x) {
                Activator.log("Cannot write console output", x);
            }
            for (IOConsoleOutputStream stream : out_streams.values()) {
                try {
                    stream.close();
                }
                catch (IOException x) {
                    Activator.log("Cannot close console stream", x);
                }
            }
            try {
                TCFConsole.this.console.getInputStream().close();
            }
            catch (IOException x) {
                Activator.log("Cannot close console stream", x);
            }
            try {
                TCFConsole.this.display.syncExec(new Runnable(){

                    public void run() {
                        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
                        manager.removeConsoles((IConsole[])new IOConsole[]{TCFConsole.this.console});
                    }
                });
            }
            catch (SWTException x) {
                if (x.code == 45) {
                    return;
                }
                Activator.log("Cannot remove console", x);
            }
        }
    };

    TCFConsole(TCFModel model, String process_id) {
        this.model = model;
        this.display = model.getDisplay();
        this.out_queue = new LinkedList();
        this.console = new IOConsole("TCF " + process_id, null, ImageCache.getImageDescriptor("icons/tcf.gif"), "UTF-8", true);
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
                    TCFConsole.this.display.timerExec(200, (Runnable)this);
                } else if (!PlatformUI.getWorkbench().isClosing()) {
                    try {
                        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
                        manager.addConsoles(new IConsole[]{TCFConsole.this.console});
                        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (w == null) {
                            return;
                        }
                        IWorkbenchPage page = w.getActivePage();
                        if (page == null) {
                            return;
                        }
                        IConsoleView view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
                        view.display((IConsole)TCFConsole.this.console);
                    }
                    catch (Throwable x) {
                        Activator.log("Cannot open console view", x);
                    }
                }
            }
        });
        this.inp_thread.setName("TCF Launch Console Input");
        this.out_thread.setName("TCF Launch Console Output");
        this.inp_thread.start();
        this.out_thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(int stream_id, byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        LinkedList<Message> linkedList = this.out_queue;
        synchronized (linkedList) {
            Message m = new Message();
            m.stream_id = stream_id;
            m.data = data;
            this.out_queue.add(m);
            this.out_queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        LinkedList<Message> linkedList = this.out_queue;
        synchronized (linkedList) {
            this.out_queue.add(new Message());
            this.out_queue.notify();
        }
    }

    private static class Message {
        int stream_id;
        byte[] data;

        private Message() {
        }
    }
}

