/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.model.TCFFunctionRef;
import org.eclipse.tm.internal.tcf.debug.model.TCFSourceRef;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.model.ISymbolOwner;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenExpressions;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenHoverExpressions;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenModules;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenRegisters;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModelProxy;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeSymbol;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.ILineNumbers;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IMemoryMap;
import org.eclipse.tm.tcf.services.IProcesses;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.services.ISymbols;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFNodeExecContext
extends TCFNode
implements ISymbolOwner {
    private final TCFChildrenExecContext children_exec;
    private final TCFChildrenStackTrace children_stack;
    private final TCFChildrenRegisters children_regs;
    private final TCFChildrenExpressions children_exps;
    private final TCFChildrenHoverExpressions children_hover_exps;
    private final TCFChildrenModules children_modules;
    private final TCFNode.TCFData<IMemory.MemoryContext> mem_context;
    private final TCFNode.TCFData<IRunControl.RunControlContext> run_context;
    private final TCFNode.TCFData<MemoryRegion[]> memory_map;
    private final TCFNode.TCFData<IProcesses.ProcessContext> prs_context;
    private final TCFNode.TCFData<TCFContextState> state;
    private final TCFNode.TCFData<BigInteger> address;
    private final TCFNode.TCFData<Collection<Map<String, Object>>> signal_list;
    private final TCFNode.TCFData<SignalMask[]> signal_mask;
    private final TCFNode.TCFData<TCFNodeExecContext> memory_node;
    private LinkedHashMap<BigInteger, TCFDataCache<TCFSourceRef>> line_info_lookup_cache;
    private LinkedHashMap<BigInteger, TCFDataCache<TCFFunctionRef>> func_info_lookup_cache;
    private LookupCacheTimer lookup_cache_timer;
    private int mem_seq_no;
    private int exe_seq_no;
    private final Map<String, TCFNodeSymbol> symbols = new HashMap<String, TCFNodeSymbol>();
    private int resumed_cnt;
    private boolean resume_pending;
    private boolean resumed_by_action;
    private TCFNode[] last_stack_trace;
    private String last_label;
    private String last_image;
    private String hover_expression;

    TCFNodeExecContext(TCFNode parent, final String id) {
        super(parent, id);
        this.children_exec = new TCFChildrenExecContext(this);
        this.children_stack = new TCFChildrenStackTrace(this);
        this.children_regs = new TCFChildrenRegisters(this);
        this.children_exps = new TCFChildrenExpressions(this);
        this.children_hover_exps = new TCFChildrenHoverExpressions(this);
        this.children_modules = new TCFChildrenModules(this);
        this.mem_context = new TCFNode.TCFData<IMemory.MemoryContext>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                IMemory mem = (IMemory)TCFNodeExecContext.this.model.getLaunch().getService(IMemory.class);
                if (mem == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = mem.getContext(id, new IMemory.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IMemory.MemoryContext context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.run_context = new TCFNode.TCFData<IRunControl.RunControlContext>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                IRunControl run = (IRunControl)TCFNodeExecContext.this.model.getLaunch().getService(IRunControl.class);
                if (run == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = run.getContext(id, new IRunControl.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.prs_context = new TCFNode.TCFData<IProcesses.ProcessContext>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                IProcesses prs = (IProcesses)TCFNodeExecContext.this.model.getLaunch().getService(IProcesses.class);
                if (prs == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = prs.getContext(id, new IProcesses.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.memory_map = new TCFNode.TCFData<MemoryRegion[]>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                IMemoryMap mmap = (IMemoryMap)TCFNodeExecContext.this.model.getLaunch().getService(IMemoryMap.class);
                if (mmap == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = mmap.get(id, new IMemoryMap.DoneGet(){

                    public void doneGet(IToken token, Exception error, IMemoryMap.MemoryRegion[] map) {
                        MemoryRegion[] arr = null;
                        if (map != null) {
                            int i = 0;
                            arr = new MemoryRegion[map.length];
                            IMemoryMap.MemoryRegion[] memoryRegionArray = map;
                            int n = map.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IMemoryMap.MemoryRegion r = memoryRegionArray[n2];
                                arr[i++] = new MemoryRegion(r);
                                ++n2;
                            }
                        }
                        this.set(token, error, arr);
                    }
                });
                return false;
            }
        };
        this.state = new TCFNode.TCFData<TCFContextState>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                if (!TCFNodeExecContext.this.run_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)TCFNodeExecContext.this.run_context.getData();
                if (ctx == null || !ctx.hasState()) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = ctx.getState(new IRunControl.DoneGetState(){

                    public void doneGetState(IToken token, Exception error, boolean suspended, String pc, String reason, Map<String, Object> params) {
                        TCFContextState s = new TCFContextState();
                        s.is_suspended = suspended;
                        s.suspend_pc = pc;
                        s.suspend_reason = reason;
                        s.suspend_params = params;
                        this.set(token, error, s);
                    }
                });
                return false;
            }
        };
        this.address = new TCFNode.TCFData<BigInteger>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeExecContext.this.run_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)TCFNodeExecContext.this.run_context.getData();
                if (ctx == null || !ctx.hasState()) {
                    this.set(null, TCFNodeExecContext.this.run_context.getError(), null);
                    return true;
                }
                if (!TCFNodeExecContext.this.state.validate((Runnable)((Object)this))) {
                    return false;
                }
                TCFContextState s = (TCFContextState)TCFNodeExecContext.this.state.getData();
                if (s == null) {
                    this.set(null, TCFNodeExecContext.this.state.getError(), null);
                    return true;
                }
                if (s.suspend_pc == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.set(null, null, new BigInteger(s.suspend_pc));
                return true;
            }
        };
        this.signal_list = new TCFNode.TCFData<Collection<Map<String, Object>>>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                IProcesses prs = (IProcesses)this.channel.getRemoteService(IProcesses.class);
                if (prs == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = prs.getSignalList(id, new IProcesses.DoneGetSignalList(){

                    public void doneGetSignalList(IToken token, Exception error, Collection<Map<String, Object>> list) {
                        this.set(token, error, list);
                    }
                });
                return false;
            }
        };
        this.signal_mask = new TCFNode.TCFData<SignalMask[]>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeExecContext.this.signal_list.validate((Runnable)((Object)this))) {
                    return false;
                }
                IProcesses prs = (IProcesses)this.channel.getRemoteService(IProcesses.class);
                final Collection sigs = (Collection)TCFNodeExecContext.this.signal_list.getData();
                if (prs == null || sigs == null) {
                    this.set(null, TCFNodeExecContext.this.signal_list.getError(), null);
                    return true;
                }
                this.command = prs.getSignalMask(id, new IProcesses.DoneGetSignalMask(){

                    public void doneGetSignalMask(IToken token, Exception error, int dont_stop, int dont_pass, int pending) {
                        int n = 0;
                        SignalMask[] list = new SignalMask[sigs.size()];
                        for (Map m : sigs) {
                            int n2 = n++;
                            SignalMask signalMask = new SignalMask();
                            list[n2] = signalMask;
                            SignalMask s = signalMask;
                            s.props = m;
                            int mask = 1 << s.getIndex().intValue();
                            s.dont_stop = (dont_stop & mask) != 0;
                            s.dont_pass = (dont_pass & mask) != 0;
                            boolean bl = s.pending = (pending & mask) != 0;
                        }
                        this.set(token, error, list);
                    }
                });
                return false;
            }
        };
        this.memory_node = new TCFNode.TCFData<TCFNodeExecContext>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                TCFNodeExecContext exe;
                TCFNode n = TCFNodeExecContext.this;
                String id = null;
                Throwable err = null;
                while (n != null && !n.isDisposed()) {
                    if (n instanceof TCFNodeExecContext) {
                        IRunControl.RunControlContext ctx;
                        exe = n;
                        TCFDataCache<IRunControl.RunControlContext> cache = exe.getRunContext();
                        if (!cache.validate((Runnable)((Object)this))) {
                            return false;
                        }
                        err = cache.getError();
                        if (err != null || (ctx = (IRunControl.RunControlContext)cache.getData()) == null) break;
                        String prs = ctx.getProcessID();
                        id = prs != null ? prs : n.id;
                        break;
                    }
                    n = n.parent;
                }
                if (err != null) {
                    this.set(null, err, null);
                } else if (id == null) {
                    this.set(null, new Exception("Context does not provide memory access"), null);
                } else {
                    if (!TCFNodeExecContext.this.model.createNode(id, this)) {
                        return false;
                    }
                    if (!this.isValid()) {
                        exe = (TCFNodeExecContext)TCFNodeExecContext.this.model.getNode(id);
                        if (!exe.getMemoryContext().validate((Runnable)((Object)this))) {
                            return false;
                        }
                        this.set(null, null, exe);
                    }
                }
                return true;
            }
        };
    }

    @Override
    void dispose() {
        assert (!this.isDisposed());
        ArrayList<TCFNodeSymbol> l = new ArrayList<TCFNodeSymbol>(this.symbols.values());
        for (TCFNodeSymbol s : l) {
            s.dispose();
        }
        assert (this.symbols.size() == 0);
        super.dispose();
    }

    void setMemSeqNo(int no) {
        this.mem_seq_no = no;
    }

    void setExeSeqNo(int no) {
        this.exe_seq_no = no;
    }

    TCFChildren getHoverExpressionCache(String expression) {
        if (!(expression == this.hover_expression || expression != null && expression.equals(this.hover_expression))) {
            this.hover_expression = expression;
            this.children_hover_exps.cancel();
        }
        return this.children_hover_exps;
    }

    String getHoverExpression() {
        return this.hover_expression;
    }

    void setRunContext(IRunControl.RunControlContext ctx) {
        this.run_context.reset(ctx);
    }

    void setProcessContext(IProcesses.ProcessContext ctx) {
        this.prs_context.reset(ctx);
    }

    void setMemoryContext(IMemory.MemoryContext ctx) {
        this.mem_context.reset(ctx);
    }

    public TCFDataCache<TCFNodeExecContext> getMemoryNode() {
        return this.memory_node;
    }

    public TCFDataCache<MemoryRegion[]> getMemoryMap() {
        return this.memory_map;
    }

    public TCFDataCache<Collection<Map<String, Object>>> getSignalList() {
        return this.signal_list;
    }

    public TCFDataCache<SignalMask[]> getSignalMask() {
        return this.signal_mask;
    }

    private BigInteger toBigInteger(Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        return new BigInteger(n.toString());
    }

    public TCFDataCache<TCFSourceRef> getLineInfo(final BigInteger addr) {
        TCFNode.TCFData<TCFSourceRef> ref_cache;
        if (this.isDisposed()) {
            return null;
        }
        if (this.line_info_lookup_cache != null && (ref_cache = this.line_info_lookup_cache.get(addr)) != null) {
            return ref_cache;
        }
        final ILineNumbers ln = (ILineNumbers)this.model.getLaunch().getService(ILineNumbers.class);
        if (ln == null) {
            return null;
        }
        final BigInteger n0 = addr;
        final BigInteger n1 = n0.add(BigInteger.valueOf(1L));
        if (this.line_info_lookup_cache == null) {
            this.line_info_lookup_cache = new LinkedHashMap(11, 0.75f, true);
            if (this.lookup_cache_timer == null) {
                this.lookup_cache_timer = new LookupCacheTimer();
            }
        }
        ref_cache = new TCFNode.TCFData<TCFSourceRef>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeExecContext.this.memory_node.validate((Runnable)((Object)this))) {
                    return false;
                }
                IMemory.MemoryContext mem_data = null;
                TCFNodeExecContext mem = (TCFNodeExecContext)TCFNodeExecContext.this.memory_node.getData();
                if (mem != null) {
                    TCFDataCache<IMemory.MemoryContext> mem_cache = mem.getMemoryContext();
                    if (!mem_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    mem_data = (IMemory.MemoryContext)mem_cache.getData();
                }
                final TCFSourceRef ref_data = new TCFSourceRef();
                if (mem_data != null) {
                    ref_data.context_id = mem_data.getID();
                    ref_data.address_size = mem_data.getAddressSize();
                }
                this.command = ln.mapToSource(TCFNodeExecContext.this.id, (Number)n0, (Number)n1, new ILineNumbers.DoneMapToSource(){

                    public void doneMapToSource(IToken token, Exception error, ILineNumbers.CodeArea[] areas) {
                        ref_data.address = addr;
                        if (error == null && areas != null && areas.length > 0) {
                            ILineNumbers.CodeArea[] codeAreaArray = areas;
                            int n = areas.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ILineNumbers.CodeArea area = codeAreaArray[n2];
                                BigInteger a0 = TCFNodeExecContext.this.toBigInteger(area.start_address);
                                BigInteger a1 = TCFNodeExecContext.this.toBigInteger(area.end_address);
                                if (n0.compareTo(a0) >= 0 && n0.compareTo(a1) < 0 && (ref_data.area == null || area.start_line < ref_data.area.start_line)) {
                                    if (area.start_address != a0 || area.end_address != a1) {
                                        area = new ILineNumbers.CodeArea(area.directory, area.file, area.start_line, area.start_column, area.end_line, area.end_column, (Number)a0, (Number)a1, area.isa, area.is_statement, area.basic_block, area.prologue_end, area.epilogue_begin);
                                    }
                                    ref_data.area = area;
                                }
                                ++n2;
                            }
                        }
                        ref_data.error = error;
                        this.set(token, null, ref_data);
                    }
                });
                return false;
            }
        };
        this.line_info_lookup_cache.put(addr, (TCFDataCache<TCFSourceRef>)ref_cache);
        return ref_cache;
    }

    public TCFDataCache<TCFFunctionRef> getFuncInfo(final BigInteger addr) {
        TCFNode.TCFData<TCFFunctionRef> ref_cache;
        if (this.isDisposed()) {
            return null;
        }
        if (this.func_info_lookup_cache != null && (ref_cache = this.func_info_lookup_cache.get(addr)) != null) {
            return ref_cache;
        }
        final ISymbols syms = (ISymbols)this.model.getLaunch().getService(ISymbols.class);
        if (syms == null) {
            return null;
        }
        if (this.func_info_lookup_cache == null) {
            this.func_info_lookup_cache = new LinkedHashMap(11, 0.75f, true);
            if (this.lookup_cache_timer == null) {
                this.lookup_cache_timer = new LookupCacheTimer();
            }
        }
        ref_cache = new TCFNode.TCFData<TCFFunctionRef>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeExecContext.this.memory_node.validate((Runnable)((Object)this))) {
                    return false;
                }
                IMemory.MemoryContext mem_data = null;
                TCFNodeExecContext mem = (TCFNodeExecContext)TCFNodeExecContext.this.memory_node.getData();
                if (mem != null) {
                    TCFDataCache<IMemory.MemoryContext> mem_cache = mem.getMemoryContext();
                    if (!mem_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    mem_data = (IMemory.MemoryContext)mem_cache.getData();
                }
                final TCFFunctionRef ref_data = new TCFFunctionRef();
                if (mem_data != null) {
                    ref_data.context_id = mem_data.getID();
                    ref_data.address_size = mem_data.getAddressSize();
                }
                this.command = syms.findByAddr(TCFNodeExecContext.this.id, (Number)addr, new ISymbols.DoneFind(){

                    public void doneFind(IToken token, Exception error, String symbol_id) {
                        ref_data.address = addr;
                        ref_data.error = error;
                        ref_data.symbol_id = symbol_id;
                        this.set(token, null, ref_data);
                    }
                });
                return false;
            }
        };
        this.func_info_lookup_cache.put(addr, (TCFDataCache<TCFFunctionRef>)ref_cache);
        return ref_cache;
    }

    private void clearLookupCaches() {
        TCFDataCache<TCFSourceRef> cache;
        Iterator<TCFDataCache<TCFSourceRef>> i;
        if (this.line_info_lookup_cache != null) {
            i = this.line_info_lookup_cache.values().iterator();
            while (i.hasNext()) {
                cache = i.next();
                if (cache.isPending()) continue;
                cache.dispose();
                i.remove();
            }
            if (this.line_info_lookup_cache.size() == 0) {
                this.line_info_lookup_cache = null;
            }
        }
        if (this.func_info_lookup_cache != null) {
            i = this.func_info_lookup_cache.values().iterator();
            while (i.hasNext()) {
                cache = i.next();
                if (cache.isPending()) continue;
                cache.dispose();
                i.remove();
            }
            if (this.func_info_lookup_cache.size() == 0) {
                this.func_info_lookup_cache = null;
            }
        }
    }

    @Override
    public TCFNode getParent(IPresentationContext ctx) {
        Set ids;
        assert (Protocol.isDispatchThread());
        if ("org.eclipse.debug.ui.DebugView".equals(ctx.getId()) && (ids = this.model.getLaunch().getContextFilter()) != null) {
            if (ids.contains(this.id)) {
                return this.model.getRootNode();
            }
            if (this.parent instanceof TCFNodeLaunch) {
                return null;
            }
        }
        return this.parent;
    }

    public TCFDataCache<IRunControl.RunControlContext> getRunContext() {
        return this.run_context;
    }

    public TCFDataCache<IProcesses.ProcessContext> getProcessContext() {
        return this.prs_context;
    }

    public TCFDataCache<IMemory.MemoryContext> getMemoryContext() {
        return this.mem_context;
    }

    public TCFDataCache<BigInteger> getAddress() {
        return this.address;
    }

    public TCFDataCache<TCFContextState> getState() {
        return this.state;
    }

    public TCFChildrenStackTrace getStackTrace() {
        return this.children_stack;
    }

    public TCFChildren getRegisters() {
        return this.children_regs;
    }

    public TCFChildren getModules() {
        return this.children_modules;
    }

    public TCFChildren getChildren() {
        return this.children_exec;
    }

    @Override
    public void addSymbol(TCFNodeSymbol s) {
        assert (this.symbols.get(s.id) == null);
        this.symbols.put(s.id, s);
    }

    @Override
    public void removeSymbol(TCFNodeSymbol s) {
        assert (this.symbols.get(s.id) == s);
        this.symbols.remove(s.id);
    }

    public boolean isNotActive() {
        Number n;
        Map attrs;
        TCFContextState state_data = (TCFContextState)this.state.getData();
        if (state_data != null && state_data.suspend_params != null && (attrs = (Map)state_data.suspend_params.get("PCError")) != null && (n = (Number)attrs.get("Code")) != null) {
            return n.intValue() == 28;
        }
        return false;
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        TCFChildren children = null;
        if ("org.eclipse.debug.ui.DebugView".equals(result.getPresentationContext().getId())) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                if (this.resume_pending && this.last_stack_trace != null) {
                    result.setChildCount(this.last_stack_trace.length);
                    return true;
                }
                if (!this.state.validate(done)) {
                    return false;
                }
                if (this.isNotActive()) {
                    this.last_stack_trace = new TCFNode[0];
                    result.setChildCount(0);
                    return true;
                }
                TCFContextState state_data = (TCFContextState)this.state.getData();
                if (state_data != null && !state_data.is_suspended) {
                    result.setChildCount(0);
                    return true;
                }
                children = this.children_stack;
            } else {
                children = this.children_exec;
            }
        } else if ("org.eclipse.debug.ui.RegisterView".equals(result.getPresentationContext().getId())) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                children = this.children_regs;
            }
        } else if ("org.eclipse.debug.ui.ExpressionView".equals(result.getPresentationContext().getId())) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                children = this.children_exps;
            }
        } else if ("org.eclipse.tm.tcf.debug.ui.expression_hover".equals(result.getPresentationContext().getId())) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                children = this.children_hover_exps;
            }
        } else if ("org.eclipse.debug.ui.ModuleView".equals(result.getPresentationContext().getId())) {
            if (!this.mem_context.validate(done)) {
                return false;
            }
            IMemory.MemoryContext ctx = (IMemory.MemoryContext)this.mem_context.getData();
            if (ctx != null) {
                children = this.children_modules;
            }
        }
        if (children != null) {
            if (!children.validate(done)) {
                return false;
            }
            if (children == this.children_stack) {
                this.last_stack_trace = this.children_stack.toArray();
            }
            result.setChildCount(children.size());
        } else {
            result.setChildCount(0);
        }
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        TCFChildren children = null;
        if ("org.eclipse.debug.ui.DebugView".equals(result.getPresentationContext().getId())) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                if (this.resume_pending && this.last_stack_trace != null) {
                    TCFNode[] arr = this.last_stack_trace;
                    int offset = 0;
                    int r_offset = result.getOffset();
                    int r_length = result.getLength();
                    TCFNode[] tCFNodeArray = arr;
                    int n = arr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TCFNode n3 = tCFNodeArray[n2];
                        if (offset >= r_offset && offset < r_offset + r_length) {
                            result.setChild((Object)n3, offset);
                        }
                        ++offset;
                        ++n2;
                    }
                    return true;
                }
                if (!this.state.validate(done)) {
                    return false;
                }
                if (this.isNotActive()) {
                    this.last_stack_trace = new TCFNode[0];
                    return true;
                }
                TCFContextState state_data = (TCFContextState)this.state.getData();
                if (state_data != null && !state_data.is_suspended) {
                    return true;
                }
                children = this.children_stack;
            } else {
                children = this.children_exec;
            }
        } else if ("org.eclipse.debug.ui.RegisterView".equals(result.getPresentationContext().getId())) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                children = this.children_regs;
            }
        } else if ("org.eclipse.debug.ui.ExpressionView".equals(result.getPresentationContext().getId())) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                children = this.children_exps;
            }
        } else if ("org.eclipse.tm.tcf.debug.ui.expression_hover".equals(result.getPresentationContext().getId())) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                children = this.children_hover_exps;
            }
        } else if ("org.eclipse.debug.ui.ModuleView".equals(result.getPresentationContext().getId())) {
            if (!this.mem_context.validate(done)) {
                return false;
            }
            IMemory.MemoryContext ctx = (IMemory.MemoryContext)this.mem_context.getData();
            if (ctx != null) {
                children = this.children_modules;
            }
        }
        if (children == null) {
            return true;
        }
        if (!children.validate(done)) {
            return false;
        }
        if (children == this.children_stack) {
            this.last_stack_trace = this.children_stack.toArray();
        }
        return children.getData(result, done);
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        TCFChildren children = null;
        if ("org.eclipse.debug.ui.DebugView".equals(result.getPresentationContext().getId())) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                if (this.resume_pending && this.last_stack_trace != null) {
                    result.setHasChilren(this.last_stack_trace.length > 0);
                    return true;
                }
                if (!this.state.validate(done)) {
                    return false;
                }
                if (this.isNotActive()) {
                    this.last_stack_trace = new TCFNode[0];
                    result.setHasChilren(false);
                    return true;
                }
                TCFContextState state_data = (TCFContextState)this.state.getData();
                if (state_data != null) {
                    result.setHasChilren(state_data.is_suspended);
                    return true;
                }
                children = this.children_stack;
            } else {
                children = this.children_exec;
            }
        } else if ("org.eclipse.debug.ui.RegisterView".equals(result.getPresentationContext().getId())) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                children = this.children_regs;
            }
        } else if ("org.eclipse.debug.ui.ExpressionView".equals(result.getPresentationContext().getId())) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                children = this.children_exps;
            }
        } else if ("org.eclipse.tm.tcf.debug.ui.expression_hover".equals(result.getPresentationContext().getId())) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                children = this.children_hover_exps;
            }
        } else if ("org.eclipse.debug.ui.ModuleView".equals(result.getPresentationContext().getId())) {
            if (!this.mem_context.validate(done)) {
                return false;
            }
            IMemory.MemoryContext ctx = (IMemory.MemoryContext)this.mem_context.getData();
            if (ctx != null) {
                children = this.children_modules;
            }
        }
        if (children != null) {
            if (!children.validate(done)) {
                return false;
            }
            if (children == this.children_stack) {
                this.last_stack_trace = this.children_stack.toArray();
            }
            result.setHasChilren(children.size() > 0);
        } else {
            result.setHasChilren(false);
        }
        return true;
    }

    @Override
    protected boolean getData(ILabelUpdate result, Runnable done) {
        if (!this.run_context.validate(done)) {
            return false;
        }
        String image_name = null;
        StringBuffer label = new StringBuffer();
        Throwable error = this.run_context.getError();
        if (error != null) {
            result.setForeground(new RGB(255, 0, 0), 0);
            label.append(this.id);
            label.append(": ");
            label.append(TCFModel.getErrorMessage(error, false));
        } else {
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx == null) {
                label.append(this.id);
            } else {
                String prs;
                String nm = ctx.getName();
                if (nm == null && !ctx.hasState() && (prs = ctx.getProcessID()) != null) {
                    if (!this.prs_context.validate(done)) {
                        return false;
                    }
                    IProcesses.ProcessContext pctx = (IProcesses.ProcessContext)this.prs_context.getData();
                    if (pctx != null) {
                        nm = pctx.getName();
                    }
                }
                label.append(nm != null ? nm : this.id);
                if (ctx.hasState()) {
                    if (this.resumed_by_action || this.model.getActiveAction(this.id) != null) {
                        image_name = "icons/full/obj16/thread_obj.gif";
                        if (this.resume_pending && this.last_label != null) {
                            result.setImageDescriptor(ImageCache.getImageDescriptor(image_name), 0);
                            result.setLabel(this.last_label, 0);
                            return true;
                        }
                        label.append(" (Running)");
                    } else {
                        if (this.resume_pending && this.last_label != null && this.last_image != null) {
                            result.setImageDescriptor(ImageCache.getImageDescriptor(this.last_image), 0);
                            result.setLabel(this.last_label, 0);
                            return true;
                        }
                        if (!this.state.validate(done)) {
                            return false;
                        }
                        TCFContextState state_data = (TCFContextState)this.state.getData();
                        if (this.isNotActive()) {
                            image_name = "icons/thread_not_active.gif";
                            label.append(" (Not active)");
                            if (state_data.suspend_reason != null && !state_data.suspend_reason.equals("Suspended")) {
                                label.append(" - ");
                                label.append(state_data.suspend_reason);
                            }
                        } else {
                            image_name = state_data == null ? "icons/thread_not_active.gif" : (state_data.is_suspended ? "icons/full/obj16/threads_obj.gif" : "icons/full/obj16/thread_obj.gif");
                            if (state_data != null) {
                                if (!state_data.is_suspended) {
                                    label.append(" (Running)");
                                } else {
                                    String r = this.model.getContextActionResult(this.id);
                                    if (r == null) {
                                        r = state_data.suspend_reason;
                                        if (state_data.suspend_params != null) {
                                            String s = (String)state_data.suspend_params.get("SignalDescription");
                                            if (s == null) {
                                                s = (String)state_data.suspend_params.get("SignalName");
                                            }
                                            if (s != null) {
                                                r = String.valueOf(r) + ": " + s;
                                            }
                                        }
                                    }
                                    if (r == null) {
                                        r = "Suspended";
                                    }
                                    label.append(" (");
                                    label.append(r);
                                    if (state_data.suspend_params != null) {
                                        String cpu;
                                        String prs2 = (String)state_data.suspend_params.get("Context");
                                        if (prs2 != null) {
                                            label.append(", ");
                                            label.append(prs2);
                                        }
                                        if ((cpu = (String)state_data.suspend_params.get("CPU")) != null) {
                                            label.append(", ");
                                            label.append(cpu);
                                        }
                                    }
                                    label.append(")");
                                }
                            }
                        }
                    }
                } else {
                    Boolean b = this.hasSuspendedChildren(done);
                    if (b == null) {
                        return false;
                    }
                    image_name = b != false ? "icons/full/obj16/debugts_obj.gif" : "icons/full/obj16/debugt_obj.gif";
                }
            }
        }
        this.last_image = image_name;
        result.setImageDescriptor(ImageCache.getImageDescriptor(this.last_image), 0);
        this.last_label = label.toString();
        result.setLabel(this.last_label, 0);
        return true;
    }

    @Override
    protected boolean getData(IViewerInputUpdate result, Runnable done) {
        result.setInputElement(result.getElement());
        String id = result.getPresentationContext().getId();
        if ("org.eclipse.debug.ui.VariableView".equals(id)) {
            if (!this.children_stack.validate(done)) {
                return false;
            }
            TCFNodeStackFrame frame = this.children_stack.getTopFrame();
            if (frame != null) {
                result.setInputElement((Object)frame);
            }
        } else if ("org.eclipse.debug.ui.ModuleView".equals(id)) {
            TCFDataCache<TCFNodeExecContext> mem = this.model.searchMemoryContext(this);
            if (mem == null) {
                return true;
            }
            if (!mem.validate(done)) {
                return false;
            }
            if (mem.getData() == null) {
                return true;
            }
            result.setInputElement(mem.getData());
        }
        return true;
    }

    void postAllChangedDelta() {
        this.postContentChangedDelta();
        this.postStateChangedDelta();
    }

    void postContextAddedDelta() {
        for (TCFModelProxy p : this.model.getModelProxies()) {
            if (!"org.eclipse.debug.ui.DebugView".equals(p.getPresentationContext().getId())) continue;
            p.addDelta(this, 1);
        }
    }

    private void postContextRemovedDelta() {
        for (TCFModelProxy p : this.model.getModelProxies()) {
            if (!"org.eclipse.debug.ui.DebugView".equals(p.getPresentationContext().getId())) continue;
            p.addDelta(this, 2);
        }
    }

    private void postContentChangedDelta() {
        for (TCFModelProxy p : this.model.getModelProxies()) {
            int flags = 0;
            String id = p.getPresentationContext().getId();
            if ("org.eclipse.debug.ui.DebugView".equals(id)) {
                flags |= 0x400;
            }
            if (("org.eclipse.debug.ui.RegisterView".equals(id) || "org.eclipse.debug.ui.ExpressionView".equals(id) || "org.eclipse.tm.tcf.debug.ui.expression_hover".equals(id)) && p.getInput() == this) {
                flags |= 0x400;
            }
            if (flags == 0) continue;
            p.addDelta(this, flags);
        }
    }

    private void postAllAndParentsChangedDelta() {
        this.postContentChangedDelta();
        TCFNode n = this;
        while (n instanceof TCFNodeExecContext) {
            n.postStateChangedDelta();
            n = n.parent;
        }
    }

    private void postStateChangedDelta() {
        for (TCFModelProxy p : this.model.getModelProxies()) {
            if (!"org.eclipse.debug.ui.DebugView".equals(p.getPresentationContext().getId())) continue;
            p.addDelta(this, 2048);
        }
    }

    private void postModulesChangedDelta() {
        for (TCFModelProxy p : this.model.getModelProxies()) {
            if (!"org.eclipse.debug.ui.ModuleView".equals(p.getPresentationContext().getId())) continue;
            p.addDelta(this, 1024);
        }
    }

    void onContextAdded(IRunControl.RunControlContext context) {
        this.children_exec.onContextAdded(context);
    }

    void onContextChanged(IRunControl.RunControlContext context) {
        assert (!this.isDisposed());
        this.run_context.reset(context);
        this.memory_node.reset();
        this.signal_mask.reset();
        this.state.reset();
        this.children_stack.reset();
        this.children_stack.onSourceMappingChange();
        this.children_regs.reset();
        for (TCFNodeSymbol s : this.symbols.values()) {
            s.onMemoryMapChanged();
        }
        this.postAllChangedDelta();
    }

    void onContextAdded(IMemory.MemoryContext context) {
        this.children_exec.onContextAdded(context);
    }

    void onContextChanged(IMemory.MemoryContext context) {
        assert (!this.isDisposed());
        this.clearLookupCaches();
        this.mem_context.reset(context);
        for (TCFNodeSymbol s : this.symbols.values()) {
            s.onMemoryMapChanged();
        }
        this.postAllChangedDelta();
    }

    void onContextRemoved() {
        assert (!this.isDisposed());
        ++this.resumed_cnt;
        this.resume_pending = false;
        this.resumed_by_action = false;
        this.dispose();
        this.postContextRemovedDelta();
    }

    void onExpressionAddedOrRemoved() {
        this.children_exps.cancel();
        this.children_stack.onExpressionAddedOrRemoved();
    }

    void onContainerSuspended() {
        IRunControl.RunControlContext ctx;
        assert (!this.isDisposed());
        if (this.run_context.isValid() && (ctx = (IRunControl.RunControlContext)this.run_context.getData()) != null && !ctx.hasState()) {
            return;
        }
        this.onContextSuspended(null, null, null);
    }

    void onContainerResumed() {
        IRunControl.RunControlContext ctx;
        assert (!this.isDisposed());
        if (this.run_context.isValid() && (ctx = (IRunControl.RunControlContext)this.run_context.getData()) != null && !ctx.hasState()) {
            return;
        }
        this.onContextResumed();
    }

    void onContextSuspended(String pc, String reason, Map<String, Object> params) {
        assert (!this.isDisposed());
        if (pc != null) {
            TCFContextState tCFContextState = new TCFContextState();
            tCFContextState.is_suspended = true;
            tCFContextState.suspend_pc = pc;
            tCFContextState.suspend_reason = reason;
            tCFContextState.suspend_params = params;
            this.state.reset(tCFContextState);
        } else {
            this.state.reset();
        }
        this.address.reset();
        this.signal_mask.reset();
        this.children_stack.onSuspended();
        this.children_regs.onSuspended();
        this.children_exps.onSuspended();
        this.children_hover_exps.onSuspended();
        for (TCFNodeSymbol tCFNodeSymbol : this.symbols.values()) {
            tCFNodeSymbol.onExeStateChange();
        }
        if (this.model.getActiveAction(this.id) == null) {
            ++this.resumed_cnt;
            this.resume_pending = false;
            this.resumed_by_action = false;
            if (pc != null) {
                this.children_stack.postAllChangedDelta();
                this.postAllAndParentsChangedDelta();
            } else {
                final int n = ++this.resumed_cnt;
                Protocol.invokeLater((long)500L, (Runnable)new Runnable(){

                    public void run() {
                        if (n != TCFNodeExecContext.this.resumed_cnt) {
                            return;
                        }
                        if (TCFNodeExecContext.this.isDisposed()) {
                            return;
                        }
                        TCFNodeExecContext.this.children_stack.postAllChangedDelta();
                        TCFNodeExecContext.this.postAllAndParentsChangedDelta();
                    }
                });
            }
        }
    }

    void onContextResumed() {
        assert (!this.isDisposed());
        this.state.reset(new TCFContextState());
        if (!this.resume_pending) {
            final int cnt = ++this.resumed_cnt;
            this.resume_pending = true;
            boolean bl = this.resumed_by_action = this.model.getActiveAction(this.id) != null;
            if (this.resumed_by_action) {
                this.postAllChangedDelta();
            }
            Protocol.invokeLater((long)400L, (Runnable)new Runnable(){

                public void run() {
                    if (cnt != TCFNodeExecContext.this.resumed_cnt) {
                        return;
                    }
                    if (TCFNodeExecContext.this.isDisposed()) {
                        return;
                    }
                    TCFNodeExecContext.this.children_stack.onResumed();
                    TCFNodeExecContext.this.resume_pending = false;
                    TCFNodeExecContext.this.resumed_by_action = false;
                    TCFNodeExecContext.this.postAllAndParentsChangedDelta();
                }
            });
        }
    }

    void onContextActionDone() {
        if (!this.state.isValid() || this.state.getData() == null || ((TCFContextState)this.state.getData()).is_suspended) {
            ++this.resumed_cnt;
            this.resume_pending = false;
            this.resumed_by_action = false;
        }
        this.postAllChangedDelta();
        this.children_stack.postAllChangedDelta();
    }

    void onContextException(String msg) {
    }

    void onMemoryChanged(Number[] addr, long[] size) {
        assert (!this.isDisposed());
    }

    void onMemoryMapChanged() {
        this.clearLookupCaches();
        this.memory_map.reset();
        this.children_exec.onMemoryMapChanged();
        this.children_stack.onMemoryMapChanged();
        this.children_modules.onMemoryMapChanged();
        this.postModulesChangedDelta();
    }

    void onRegistersChanged() {
        this.children_stack.onRegistersChanged();
        this.postContentChangedDelta();
    }

    void onRegisterValueChanged() {
        this.state.reset();
        this.address.reset();
        this.children_stack.onRegisterValueChanged();
        this.postContentChangedDelta();
    }

    private Boolean hasSuspendedChildren(Runnable done) {
        if (!this.children_exec.validate(done)) {
            return null;
        }
        Map m = (Map)this.children_exec.getData();
        if (m == null) {
            return false;
        }
        for (TCFNode n : m.values()) {
            if (!(n instanceof TCFNodeExecContext)) continue;
            TCFNodeExecContext e = (TCFNodeExecContext)n;
            if (!e.run_context.validate(done)) {
                return null;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)e.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                TCFDataCache<TCFContextState> state_cache = e.getState();
                if (!state_cache.validate(done)) {
                    return null;
                }
                TCFContextState state_data = (TCFContextState)state_cache.getData();
                if (state_data == null || !state_data.is_suspended || e.isNotActive()) continue;
                return true;
            }
            Boolean b = e.hasSuspendedChildren(done);
            if (b == null) {
                return null;
            }
            if (!b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(TCFNode n) {
        if (n instanceof TCFNodeExecContext) {
            TCFNodeExecContext f = (TCFNodeExecContext)n;
            if (this.mem_seq_no < f.mem_seq_no) {
                return -1;
            }
            if (this.mem_seq_no > f.mem_seq_no) {
                return 1;
            }
            if (this.exe_seq_no < f.exe_seq_no) {
                return -1;
            }
            if (this.exe_seq_no > f.exe_seq_no) {
                return 1;
            }
        }
        return this.id.compareTo(n.id);
    }

    private class LookupCacheTimer
    implements Runnable {
        LookupCacheTimer() {
            Protocol.invokeLater((long)4000L, (Runnable)this);
        }

        public void run() {
            TCFDataCache cache;
            BigInteger addr;
            if (TCFNodeExecContext.this.isDisposed()) {
                return;
            }
            if (TCFNodeExecContext.this.line_info_lookup_cache != null) {
                addr = (BigInteger)TCFNodeExecContext.this.line_info_lookup_cache.keySet().iterator().next();
                cache = (TCFDataCache)TCFNodeExecContext.this.line_info_lookup_cache.get(addr);
                if (!cache.isPending()) {
                    ((TCFDataCache)TCFNodeExecContext.this.line_info_lookup_cache.remove(addr)).dispose();
                    if (TCFNodeExecContext.this.line_info_lookup_cache.size() == 0) {
                        TCFNodeExecContext.this.line_info_lookup_cache = null;
                    }
                }
            }
            if (TCFNodeExecContext.this.func_info_lookup_cache != null) {
                addr = (BigInteger)TCFNodeExecContext.this.func_info_lookup_cache.keySet().iterator().next();
                cache = (TCFDataCache)TCFNodeExecContext.this.func_info_lookup_cache.get(addr);
                if (!cache.isPending()) {
                    ((TCFDataCache)TCFNodeExecContext.this.func_info_lookup_cache.remove(addr)).dispose();
                    if (TCFNodeExecContext.this.func_info_lookup_cache.size() == 0) {
                        TCFNodeExecContext.this.func_info_lookup_cache = null;
                    }
                }
            }
            if (TCFNodeExecContext.this.line_info_lookup_cache == null && TCFNodeExecContext.this.func_info_lookup_cache == null) {
                TCFNodeExecContext.this.lookup_cache_timer = null;
            } else {
                Protocol.invokeLater((long)2500L, (Runnable)this);
            }
        }
    }

    public static class MemoryRegion {
        private final BigInteger addr_start;
        private final BigInteger addr_end;
        public final IMemoryMap.MemoryRegion region;

        private MemoryRegion(IMemoryMap.MemoryRegion region) {
            this.region = region;
            Number addr = region.getAddress();
            Number size = region.getSize();
            if (addr == null || size == null) {
                this.addr_start = null;
                this.addr_end = null;
            } else {
                this.addr_start = addr instanceof BigInteger ? (BigInteger)addr : new BigInteger(addr.toString());
                this.addr_end = this.addr_start.add(size instanceof BigInteger ? (BigInteger)size : new BigInteger(size.toString()));
            }
        }

        public boolean contains(BigInteger addr) {
            return this.addr_start != null && this.addr_end != null && this.addr_start.compareTo(addr) <= 0 && this.addr_end.compareTo(addr) > 0;
        }

        public String toString() {
            return this.region.getProperties().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SignalMask {
        protected Map<String, Object> props;
        protected boolean dont_stop;
        protected boolean dont_pass;
        protected boolean pending;

        public Number getIndex() {
            return (Number)this.props.get("Index");
        }

        public Number getCode() {
            return (Number)this.props.get("Code");
        }

        public Map<String, Object> getProperties() {
            return this.props;
        }

        public boolean isDontStop() {
            return this.dont_stop;
        }

        public boolean isDontPass() {
            return this.dont_pass;
        }

        public boolean isPending() {
            return this.pending;
        }

        public String toString() {
            StringBuffer bf = new StringBuffer();
            bf.append("[attrs=");
            bf.append(this.props.toString());
            if (this.dont_stop) {
                bf.append(",don't stop");
            }
            if (this.dont_pass) {
                bf.append(",don't pass");
            }
            if (this.pending) {
                bf.append(",pending");
            }
            bf.append(']');
            return bf.toString();
        }
    }
}

