/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.model.ICastToType;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenSubExpressions;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModelProxy;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeArrayPartition;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeRegister;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNumberFormat;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IExpressions;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IRegisters;
import org.eclipse.tm.tcf.services.ISymbols;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFNodeExpression
extends TCFNode
implements IElementEditor,
ICastToType {
    private final String script;
    private final int index;
    private final boolean deref;
    private final String field_id;
    private final TCFNode.TCFData<IExpressions.Expression> var_expression;
    private final TCFNode.TCFData<String> text;
    private final TCFNode.TCFData<Expression> expression;
    private final TCFNode.TCFData<IExpressions.Value> value;
    private final TCFNode.TCFData<ISymbols.Symbol> type;
    private final TCFNode.TCFData<String> type_name;
    private final TCFNode.TCFData<String> string;
    private final TCFNode.TCFData<String> expression_text;
    private final TCFChildrenSubExpressions children;
    private int sort_pos;
    private IExpressions.Value prev_value;
    private IExpressions.Value next_value;
    private static int expr_cnt;
    private static final ICellModifier cell_modifier;

    static {
        cell_modifier = new ICellModifier(){

            public boolean canModify(Object element, final String property) {
                final TCFNodeExpression node = (TCFNodeExpression)element;
                return (Boolean)new TCFTask<Boolean>(){

                    public void run() {
                        if ("Name".equals(property)) {
                            this.done(node.script != null);
                            return;
                        }
                        if (!node.expression.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (node.expression.getData() != null && ((Expression)((TCFNodeExpression)node).expression.getData()).expression.canAssign()) {
                            if (!node.value.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (!node.type.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if ("HexValue".equals(property)) {
                                this.done(TCFNumberFormat.isValidHexNumber(node.toNumberString(16)) == null);
                                return;
                            }
                            if ("DecValue".equals(property)) {
                                this.done(TCFNumberFormat.isValidDecNumber(true, node.toNumberString(10)) == null);
                                return;
                            }
                        }
                        this.done(Boolean.FALSE);
                    }
                }.getE();
            }

            public Object getValue(Object element, final String property) {
                final TCFNodeExpression node = (TCFNodeExpression)element;
                return new TCFTask<String>(){

                    public void run() {
                        if ("Name".equals(property)) {
                            this.done(node.script);
                            return;
                        }
                        if (!node.value.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (node.value.getData() != null) {
                            if ("HexValue".equals(property)) {
                                this.done(node.toNumberString(16));
                                return;
                            }
                            if ("DecValue".equals(property)) {
                                this.done(node.toNumberString(10));
                                return;
                            }
                        }
                        this.done(null);
                    }
                }.getE();
            }

            public void modify(Object element, final String property, final Object value) {
                if (value == null) {
                    return;
                }
                final TCFNodeExpression node = (TCFNodeExpression)element;
                new TCFTask<Boolean>(){

                    public void run() {
                        try {
                            IExpressions.Expression exp;
                            if ("Name".equals(property)) {
                                if (!node.script.equals(value)) {
                                    IExpression e;
                                    IExpressionManager m = DebugPlugin.getDefault().getExpressionManager();
                                    IExpression[] iExpressionArray = m.getExpressions();
                                    int n = iExpressionArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        e = iExpressionArray[n2];
                                        if (node.script.equals(e.getExpressionText())) {
                                            m.removeExpression(e);
                                        }
                                        ++n2;
                                    }
                                    e = m.newWatchExpression((String)value);
                                    m.addExpression(e);
                                }
                                this.done(Boolean.TRUE);
                                return;
                            }
                            if (!node.expression.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (node.expression.getData() != null && (exp = ((Expression)((TCFNodeExpression)node).expression.getData()).expression).canAssign()) {
                                byte[] bf = null;
                                int size = exp.getSize();
                                boolean is_float = false;
                                boolean big_endian = false;
                                boolean signed = false;
                                if (!node.value.validate((Runnable)((Object)this))) {
                                    return;
                                }
                                IExpressions.Value eval = (IExpressions.Value)node.value.getData();
                                if (eval != null) {
                                    switch (eval.getTypeClass()) {
                                        case real: {
                                            is_float = true;
                                        }
                                        case integer: {
                                            signed = true;
                                        }
                                    }
                                    big_endian = eval.isBigEndian();
                                    size = eval.getValue().length;
                                }
                                String input = (String)value;
                                String error = null;
                                if ("HexValue".equals(property)) {
                                    error = TCFNumberFormat.isValidHexNumber(input);
                                    if (error == null) {
                                        bf = TCFNumberFormat.toByteArray(input, 16, false, size, signed, big_endian);
                                    }
                                } else if ("DecValue".equals(property) && (error = TCFNumberFormat.isValidDecNumber(is_float, input)) == null) {
                                    bf = TCFNumberFormat.toByteArray(input, 10, is_float, size, signed, big_endian);
                                }
                                if (error != null) {
                                    throw new Exception("Invalid value: " + value, new Exception(error));
                                }
                                if (bf != null) {
                                    IExpressions exps = (IExpressions)node.model.getLaunch().getService(IExpressions.class);
                                    exps.assign(exp.getID(), bf, new IExpressions.DoneAssign(){

                                        public void doneAssign(IToken token, Exception error) {
                                            node.getRootExpression().onValueChanged();
                                            if (error != null) {
                                                node.model.showMessageBox("Cannot modify element value", error);
                                                this.done(Boolean.FALSE);
                                            } else {
                                                this.done(Boolean.TRUE);
                                            }
                                        }
                                    });
                                    return;
                                }
                            }
                            this.done(Boolean.FALSE);
                        }
                        catch (Throwable x) {
                            node.model.showMessageBox("Cannot modify element value", x);
                            this.done(Boolean.FALSE);
                        }
                    }
                }.getE();
            }
        };
    }

    TCFNodeExpression(final TCFNode parent, final String script, final String field_id, final String var_id, final int index, final boolean deref) {
        super(parent, var_id != null ? var_id : "Expr" + expr_cnt++);
        assert (script != null || field_id != null || var_id != null || index >= 0);
        this.script = script;
        this.field_id = field_id;
        this.index = index;
        this.deref = deref;
        this.var_expression = new TCFNode.TCFData<IExpressions.Expression>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                IExpressions exps = (IExpressions)TCFNodeExpression.this.model.getLaunch().getService(IExpressions.class);
                if (exps == null || var_id == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = exps.getContext(var_id, new IExpressions.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IExpressions.Expression context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.text = new TCFNode.TCFData<String>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (script != null) {
                    this.set(null, null, script);
                    return true;
                }
                if (var_id != null) {
                    if (!TCFNodeExpression.this.var_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    Throwable err = null;
                    String exp = null;
                    if (TCFNodeExpression.this.var_expression.getData() == null) {
                        err = TCFNodeExpression.this.var_expression.getError();
                    } else {
                        exp = ((IExpressions.Expression)TCFNodeExpression.this.var_expression.getData()).getExpression();
                        if (exp == null) {
                            err = new Exception("Missing 'Expression' property");
                        }
                    }
                    this.set(null, err, exp);
                    return true;
                }
                TCFNode n = parent;
                while (n instanceof TCFNodeArrayPartition) {
                    n = n.parent;
                }
                TCFNode.TCFData t = ((TCFNodeExpression)n).text;
                if (!t.validate((Runnable)((Object)this))) {
                    return false;
                }
                String e = (String)t.getData();
                if (e == null) {
                    this.set(null, t.getError(), null);
                    return true;
                }
                String cast = TCFNodeExpression.this.model.getCastToType(n.id);
                if (cast != null) {
                    e = "(" + cast + ")(" + e + ")";
                }
                if (field_id != null) {
                    e = "(" + e + ")" + (deref ? "->" : ".") + "${" + field_id + "}";
                } else if (index == 0) {
                    e = "*(" + e + ")";
                } else if (index > 0) {
                    e = "(" + e + ")[" + index + "]";
                }
                this.set(null, null, e);
                return true;
            }
        };
        this.expression = new TCFNode.TCFData<Expression>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                TCFNode n;
                IExpressions exps = (IExpressions)TCFNodeExpression.this.model.getLaunch().getService(IExpressions.class);
                if (exps == null) {
                    this.set(null, null, null);
                    return true;
                }
                String cast = TCFNodeExpression.this.model.getCastToType(TCFNodeExpression.this.id);
                if (var_id != null && cast == null) {
                    if (!TCFNodeExpression.this.var_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    Expression exp = null;
                    if (TCFNodeExpression.this.var_expression.getData() != null) {
                        exp = new Expression((IExpressions.Expression)TCFNodeExpression.this.var_expression.getData());
                    }
                    this.set(null, TCFNodeExpression.this.var_expression.getError(), exp);
                    return true;
                }
                if (!TCFNodeExpression.this.text.validate((Runnable)((Object)this))) {
                    return false;
                }
                String e = (String)TCFNodeExpression.this.text.getData();
                if (e == null) {
                    this.set(null, TCFNodeExpression.this.text.getError(), null);
                    return true;
                }
                if (cast != null) {
                    e = "(" + cast + ")(" + e + ")";
                }
                if ((n = ((TCFNodeExpression)TCFNodeExpression.this).getRootExpression().parent) instanceof TCFNodeStackFrame && ((TCFNodeStackFrame)n).isEmulated()) {
                    n = n.parent;
                }
                this.command = exps.create(n.id, null, e, new IExpressions.DoneCreate(){

                    public void doneCreate(IToken token, Exception error, IExpressions.Expression context) {
                        Expression e = null;
                        if (context != null) {
                            e = new Expression(context);
                            e.must_be_disposed = true;
                        }
                        if (!this.isDisposed()) {
                            this.set(token, error, e);
                        } else if (e != null) {
                            e.dispose();
                        }
                    }
                });
                return false;
            }

            public void cancel() {
                if (this.isValid() && this.getData() != null) {
                    ((Expression)this.getData()).dispose();
                }
                super.cancel();
            }

            @Override
            public void dispose() {
                if (this.isValid() && this.getData() != null) {
                    ((Expression)this.getData()).dispose();
                }
                super.dispose();
            }
        };
        this.value = new TCFNode.TCFData<IExpressions.Value>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                Boolean b = TCFNodeExpression.this.usePrevValue((Runnable)((Object)this));
                if (b == null) {
                    return false;
                }
                if (b.booleanValue()) {
                    this.set(null, null, TCFNodeExpression.this.prev_value);
                    return true;
                }
                if (!TCFNodeExpression.this.expression.validate((Runnable)((Object)this))) {
                    return false;
                }
                Expression exp = (Expression)TCFNodeExpression.this.expression.getData();
                if (exp == null) {
                    this.set(null, TCFNodeExpression.this.expression.getError(), null);
                    return true;
                }
                IExpressions exps = (IExpressions)TCFNodeExpression.this.model.getLaunch().getService(IExpressions.class);
                this.command = exps.evaluate(exp.expression.getID(), new IExpressions.DoneEvaluate(){

                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                        Boolean b;
                        if (error != null && (b = TCFNodeExpression.this.usePrevValue(null)) != null && b.booleanValue()) {
                            this.set(token, null, TCFNodeExpression.this.prev_value);
                            return;
                        }
                        this.set(token, error, value);
                    }
                });
                return false;
            }

            public void reset() {
                super.reset();
            }
        };
        this.type = new TCFNode.TCFData<ISymbols.Symbol>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                String type_id = null;
                if (!TCFNodeExpression.this.value.validate((Runnable)((Object)this))) {
                    return false;
                }
                IExpressions.Value val = (IExpressions.Value)TCFNodeExpression.this.value.getData();
                if (val != null) {
                    type_id = val.getTypeID();
                }
                if (type_id == null) {
                    if (!TCFNodeExpression.this.expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    Expression exp = (Expression)TCFNodeExpression.this.expression.getData();
                    if (exp != null) {
                        type_id = exp.expression.getTypeID();
                    }
                }
                if (type_id == null) {
                    this.set(null, TCFNodeExpression.this.value.getError(), null);
                    return true;
                }
                TCFDataCache<ISymbols.Symbol> type_cache = TCFNodeExpression.this.model.getSymbolInfoCache(type_id);
                if (type_cache == null) {
                    this.set(null, null, null);
                    return true;
                }
                if (!type_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                this.set(null, type_cache.getError(), (ISymbols.Symbol)type_cache.getData());
                return true;
            }
        };
        this.string = new TCFNode.TCFData<String>((TCFNode)this, this.channel){
            IMemory.MemoryContext mem;
            ISymbols.Symbol base_type_data;
            BigInteger addr;
            byte[] buf;
            int size;
            int offs;

            protected boolean startDataRetrieval() {
                if (this.addr != null) {
                    if (this.mem == null) {
                        TCFDataCache<TCFNodeExecContext> mem_cache = TCFNodeExpression.this.model.searchMemoryContext(parent);
                        if (mem_cache == null) {
                            this.set(null, new Exception("Context does not provide memory access"), null);
                            return true;
                        }
                        if (!mem_cache.validate((Runnable)((Object)this))) {
                            return false;
                        }
                        if (mem_cache.getError() != null) {
                            this.set(null, mem_cache.getError(), null);
                            return true;
                        }
                        this.mem = (IMemory.MemoryContext)((TCFNodeExecContext)mem_cache.getData()).getMemoryContext().getData();
                    }
                    if (this.size == 0) {
                        if (this.buf == null) {
                            this.buf = new byte[256];
                        }
                        if (this.offs >= this.buf.length) {
                            byte[] tmp = new byte[this.buf.length * 2];
                            System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
                            this.buf = tmp;
                        }
                        this.command = this.mem.get((Number)this.addr.add(BigInteger.valueOf(this.offs)), 1, this.buf, this.offs, 1, 0, new IMemory.DoneMemory(){

                            public void doneMemory(IToken token, IMemory.MemoryError error) {
                                if (error != null) {
                                    this.set(command, (Throwable)error, null);
                                } else if (buf[offs] == 0 || offs >= 2048) {
                                    this.set(command, null, TCFNodeExpression.this.toASCIIString(buf, 0, offs, '\"'));
                                } else if (command == token) {
                                    command = null;
                                    ++offs;
                                    this.run();
                                }
                            }
                        });
                        return false;
                    }
                    if (this.offs != this.size) {
                        if (this.buf == null || this.buf.length < this.size) {
                            this.buf = new byte[this.size];
                        }
                        this.command = this.mem.get((Number)this.addr, 1, this.buf, 0, this.size, 0, new IMemory.DoneMemory(){

                            public void doneMemory(IToken token, IMemory.MemoryError error) {
                                if (error != null) {
                                    this.set(command, (Throwable)error, null);
                                } else if (command == token) {
                                    command = null;
                                    offs = size;
                                    this.run();
                                }
                            }
                        });
                        return false;
                    }
                    StringBuffer bf = new StringBuffer();
                    bf.append('{');
                    if (!TCFNodeExpression.this.appendCompositeValueText(bf, 1, this.base_type_data, this.buf, 0, this.size, this.mem.isBigEndian(), (Runnable)((Object)this))) {
                        return false;
                    }
                    bf.append('}');
                    this.set(null, null, bf.toString());
                    return true;
                }
                if (!TCFNodeExpression.this.type.validate((Runnable)((Object)this))) {
                    return false;
                }
                ISymbols.Symbol type_data = (ISymbols.Symbol)TCFNodeExpression.this.type.getData();
                if (type_data != null) {
                    switch (type_data.getTypeClass()) {
                        case pointer: 
                        case array: {
                            TCFDataCache<ISymbols.Symbol> base_type_cahce = TCFNodeExpression.this.model.getSymbolInfoCache(type_data.getBaseTypeID());
                            if (base_type_cahce == null) break;
                            if (!base_type_cahce.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            this.base_type_data = (ISymbols.Symbol)base_type_cahce.getData();
                            if (this.base_type_data == null) break;
                            this.offs = 0;
                            this.size = this.base_type_data.getSize();
                            switch (this.base_type_data.getTypeClass()) {
                                case cardinal: 
                                case integer: {
                                    if (this.base_type_data.getSize() != 1) break;
                                    this.size = 0;
                                }
                                case composite: {
                                    if (this.base_type_data.getSize() == 0 || type_data.getTypeClass() == ISymbols.TypeClass.array && this.base_type_data.getTypeClass() == ISymbols.TypeClass.composite) break;
                                    if (!TCFNodeExpression.this.value.validate((Runnable)((Object)this))) {
                                        return false;
                                    }
                                    IExpressions.Value v = (IExpressions.Value)TCFNodeExpression.this.value.getData();
                                    if (v == null) break;
                                    byte[] data = v.getValue();
                                    if (type_data.getTypeClass() == ISymbols.TypeClass.array) {
                                        this.set(null, null, TCFNodeExpression.this.toASCIIString(data, 0, data.length, '\"'));
                                        return true;
                                    }
                                    BigInteger a = TCFNodeExpression.this.toBigInteger(data, 0, data.length, v.isBigEndian(), false);
                                    if (a.equals(BigInteger.valueOf(0L))) break;
                                    this.addr = a;
                                    Protocol.invokeLater((Runnable)((Object)this));
                                    return false;
                                }
                            }
                            break;
                        }
                        case cardinal: 
                        case integer: {
                            if (type_data.getSize() != 1) break;
                            if (!TCFNodeExpression.this.value.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            IExpressions.Value v = (IExpressions.Value)TCFNodeExpression.this.value.getData();
                            if (v == null) break;
                            byte[] data = v.getValue();
                            this.set(null, null, TCFNodeExpression.this.toASCIIString(data, 0, data.length, '\''));
                            return true;
                        }
                    }
                }
                this.set(null, null, null);
                return true;
            }

            public void reset() {
                super.reset();
                this.mem = null;
                this.addr = null;
            }
        };
        this.type_name = new TCFNode.TCFData<String>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                StringBuffer bf = new StringBuffer();
                if (!TCFNodeExpression.this.getTypeName(bf, (TCFDataCache<ISymbols.Symbol>)TCFNodeExpression.this.type, (Runnable)((Object)this))) {
                    return false;
                }
                this.set(null, null, bf.toString());
                return true;
            }
        };
        this.expression_text = new TCFNode.TCFData<String>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                String cast;
                TCFDataCache<ISymbols.Symbol> var;
                TCFNode.TCFData field = TCFNodeExpression.this.model.getSymbolInfoCache(field_id);
                TCFNode.TCFData pending = null;
                if (field != null && !field.validate()) {
                    pending = field;
                }
                if (!TCFNodeExpression.this.var_expression.validate()) {
                    pending = TCFNodeExpression.this.var_expression;
                }
                if (!TCFNodeExpression.this.text.validate()) {
                    pending = TCFNodeExpression.this.text;
                }
                if (pending != null) {
                    pending.wait((Runnable)((Object)this));
                    return false;
                }
                String parentName = "";
                if (parent instanceof TCFNodeExpression) {
                    TCFDataCache<String> parentText = ((TCFNodeExpression)parent).getExpressionText();
                    if (!parentText.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    if (parentText.getData() != null) {
                        parentName = this.parenthesize((String)parentText.getData());
                    }
                }
                String name = null;
                if (index >= 0) {
                    name = index == 0 && deref ? "*" + parentName : String.valueOf(parentName) + "[" + index + "]";
                }
                if (name == null && field != null && field.getData() != null) {
                    name = String.valueOf(parentName) + (deref ? "->" : ".") + ((ISymbols.Symbol)field.getData()).getName();
                }
                if (name == null && TCFNodeExpression.this.var_expression.getData() != null && (var = TCFNodeExpression.this.model.getSymbolInfoCache(((IExpressions.Expression)TCFNodeExpression.this.var_expression.getData()).getSymbolID())) != null) {
                    if (!var.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    if (var.getData() != null) {
                        name = ((ISymbols.Symbol)var.getData()).getName();
                    }
                }
                if (name == null && TCFNodeExpression.this.text.getData() != null) {
                    name = (String)TCFNodeExpression.this.text.getData();
                }
                if (name != null && (cast = TCFNodeExpression.this.model.getCastToType(TCFNodeExpression.this.id)) != null) {
                    name = "(" + cast + ")(" + name + ")";
                }
                this.set(null, null, name);
                return true;
            }

            private String parenthesize(String expr) {
                if (!expr.matches("\\w*")) {
                    return String.valueOf('(') + expr + ')';
                }
                return expr;
            }
        };
        this.children = new TCFChildrenSubExpressions(this, 0, 0, 0);
    }

    private TCFNodeExpression getRootExpression() {
        TCFNode n = this;
        while (n.parent instanceof TCFNodeExpression || n.parent instanceof TCFNodeArrayPartition) {
            n = n.parent;
        }
        return n;
    }

    private void postAllChangedDelta() {
        TCFNodeExpression n = this.getRootExpression();
        for (TCFModelProxy p : this.model.getModelProxies()) {
            String id = p.getPresentationContext().getId();
            if (!("org.eclipse.debug.ui.ExpressionView".equals(id) && n.script != null || "org.eclipse.tm.tcf.debug.ui.expression_hover".equals(id) && n.script != null) && (!"org.eclipse.debug.ui.VariableView".equals(id) || n.script != null)) continue;
            p.addDelta(this, 3072);
        }
    }

    void onSuspended() {
        this.prev_value = this.next_value;
        if (this.expression.isValid() && this.expression.getError() != null) {
            this.expression.reset();
        }
        this.value.reset();
        this.type.reset();
        this.type_name.reset();
        this.string.reset();
        this.children.onSuspended();
    }

    void onRegisterValueChanged() {
        this.value.reset();
        this.type.reset();
        this.type_name.reset();
        this.string.reset();
        this.children.onRegisterValueChanged();
        this.postAllChangedDelta();
    }

    void onValueChanged() {
        this.value.reset();
        this.type.reset();
        this.type_name.reset();
        this.string.reset();
        this.children.onValueChanged();
        this.postAllChangedDelta();
    }

    @Override
    public void onCastToTypeChanged() {
        this.expression.cancel();
        this.value.cancel();
        this.type.cancel();
        this.type_name.cancel();
        this.string.cancel();
        this.children.onCastToTypeChanged();
        this.postAllChangedDelta();
    }

    String getScript() {
        return this.script;
    }

    String getFieldID() {
        return this.field_id;
    }

    int getIndex() {
        return this.index;
    }

    boolean isDeref() {
        return this.deref;
    }

    void setSortPosition(int sort_pos) {
        this.sort_pos = sort_pos;
    }

    public TCFDataCache<IExpressions.Value> getValue() {
        return this.value;
    }

    @Override
    public TCFDataCache<ISymbols.Symbol> getType() {
        return this.type;
    }

    private Boolean usePrevValue(Runnable done) {
        if (this.prev_value == null) {
            return false;
        }
        if (this.parent instanceof TCFNodeStackFrame) {
            TCFNodeExecContext exe = (TCFNodeExecContext)this.parent.parent;
            TCFDataCache<TCFContextState> state_cache = exe.getState();
            if (!state_cache.validate(done)) {
                return null;
            }
            TCFContextState state = (TCFContextState)state_cache.getData();
            if (state == null || !state.is_suspended) {
                return true;
            }
            TCFChildrenStackTrace stack_trace_cache = exe.getStackTrace();
            if (!stack_trace_cache.validate(done)) {
                return null;
            }
            if (((Map)stack_trace_cache.getData()).get(this.parent.id) == null) {
                return true;
            }
        } else if (this.parent instanceof TCFNodeExecContext) {
            TCFNodeExecContext exe = (TCFNodeExecContext)this.parent;
            TCFDataCache<TCFContextState> state_cache = exe.getState();
            if (!state_cache.validate(done)) {
                return null;
            }
            TCFContextState state = (TCFContextState)state_cache.getData();
            if (state == null || !state.is_suspended) {
                return true;
            }
        }
        return false;
    }

    private boolean getTypeName(StringBuffer bf, TCFDataCache<ISymbols.Symbol> type_cache, Runnable done) {
        String name;
        block38: {
            ISymbols.Symbol type_symbol;
            name = null;
            do {
                String s = null;
                boolean get_base_type = false;
                if (!type_cache.validate(done)) {
                    return false;
                }
                type_symbol = (ISymbols.Symbol)type_cache.getData();
                if (type_symbol != null) {
                    s = type_symbol.getName();
                    if (s != null && type_symbol.getTypeClass() == ISymbols.TypeClass.composite) {
                        s = "struct " + s;
                    }
                    if (s == null && type_symbol.getSize() == 0) {
                        s = "void";
                    }
                    if (s == null) {
                        block0 : switch (type_symbol.getTypeClass()) {
                            case integer: {
                                switch (type_symbol.getSize()) {
                                    case 1: {
                                        s = "char";
                                        break block0;
                                    }
                                    case 2: {
                                        s = "short";
                                        break block0;
                                    }
                                    case 4: {
                                        s = "int";
                                        break block0;
                                    }
                                    case 8: {
                                        s = "long long";
                                        break block0;
                                    }
                                }
                                s = "<Integer>";
                                break;
                            }
                            case cardinal: {
                                switch (type_symbol.getSize()) {
                                    case 1: {
                                        s = "unsigned char";
                                        break block0;
                                    }
                                    case 2: {
                                        s = "unsigned short";
                                        break block0;
                                    }
                                    case 4: {
                                        s = "unsigned";
                                        break block0;
                                    }
                                    case 8: {
                                        s = "unsigned long long";
                                        break block0;
                                    }
                                }
                                s = "<Unsigned>";
                                break;
                            }
                            case real: {
                                switch (type_symbol.getSize()) {
                                    case 4: {
                                        s = "float";
                                        break block0;
                                    }
                                    case 8: {
                                        s = "double";
                                        break block0;
                                    }
                                }
                                s = "<Float>";
                                break;
                            }
                            case pointer: {
                                s = "*";
                                get_base_type = true;
                                break;
                            }
                            case array: {
                                s = "[" + type_symbol.getLength() + "]";
                                get_base_type = true;
                                break;
                            }
                            case composite: {
                                s = "<Structure>";
                                break;
                            }
                            case function: {
                                String[] children;
                                TCFDataCache<String[]> children_cache = this.model.getSymbolChildrenCache(type_symbol.getID());
                                if (!children_cache.validate(done)) {
                                    return false;
                                }
                                if (children_cache.getError() == null && (children = (String[])children_cache.getData()) != null) {
                                    StringBuffer args = new StringBuffer();
                                    if (name != null) {
                                        args.append('(');
                                        args.append(name);
                                        args.append(')');
                                        name = null;
                                    }
                                    args.append('(');
                                    String[] stringArray = children;
                                    int n = children.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String id = stringArray[n2];
                                        if (id != children[0]) {
                                            args.append(',');
                                        }
                                        if (!this.getTypeName(args, this.model.getSymbolInfoCache(id), done)) {
                                            return false;
                                        }
                                        ++n2;
                                    }
                                    args.append(')');
                                    s = args.toString();
                                    get_base_type = true;
                                    break;
                                }
                                s = "<Function>";
                            }
                        }
                    }
                }
                if (s == null) {
                    name = "N/A";
                    break block38;
                }
                name = name == null ? s : (!get_base_type ? String.valueOf(s) + " " + name : String.valueOf(s) + name);
                if (!get_base_type) break block38;
            } while ((type_cache = this.model.getSymbolInfoCache(type_symbol.getBaseTypeID())) != null);
            name = "N/A";
        }
        bf.append(name);
        return true;
    }

    private String toASCIIString(byte[] data, int offs, int size, char quote_char) {
        StringBuffer bf = new StringBuffer();
        bf.append(quote_char);
        int i = 0;
        while (i < size) {
            int ch = data[offs + i] & 0xFF;
            if (ch >= 32 && ch < 127) {
                bf.append((char)ch);
            } else {
                switch (ch) {
                    case 13: {
                        bf.append("\\r");
                        break;
                    }
                    case 10: {
                        bf.append("\\n");
                        break;
                    }
                    case 8: {
                        bf.append("\\b");
                        break;
                    }
                    case 9: {
                        bf.append("\\t");
                        break;
                    }
                    case 12: {
                        bf.append("\\f");
                        break;
                    }
                    default: {
                        bf.append('\\');
                        bf.append((char)(48 + ch / 64));
                        bf.append((char)(48 + ch / 8 % 8));
                        bf.append((char)(48 + ch % 8));
                    }
                }
            }
            ++i;
        }
        if (data.length <= offs + size || data[offs + size] == 0) {
            bf.append(quote_char);
        } else {
            bf.append("...");
        }
        return bf.toString();
    }

    private BigInteger toBigInteger(byte[] data, int offs, int size, boolean big_endian, boolean sign_extension) {
        assert (offs + size <= data.length);
        byte[] temp = null;
        if (sign_extension) {
            temp = new byte[size];
        } else {
            temp = new byte[size + 1];
            temp[0] = 0;
        }
        if (big_endian) {
            System.arraycopy(data, offs, temp, sign_extension ? 0 : 1, size);
        } else {
            int i = 0;
            while (i < size) {
                temp[temp.length - i - 1] = data[i + offs];
                ++i;
            }
        }
        return new BigInteger(temp);
    }

    private String toNumberString(int radix, ISymbols.Symbol t, byte[] data, int offs, int size, boolean big_endian) {
        if (size <= 0 || size >= 16) {
            return "";
        }
        String s = null;
        if (data == null) {
            s = "N/A";
        }
        if (s == null && radix == 10 && t != null) {
            block0 : switch (t.getTypeClass()) {
                case integer: {
                    s = this.toBigInteger(data, offs, size, big_endian, true).toString();
                    break;
                }
                case real: {
                    switch (t.getSize()) {
                        case 4: {
                            s = Float.toString(Float.intBitsToFloat(this.toBigInteger(data, offs, size, big_endian, true).intValue()));
                            break block0;
                        }
                        case 8: {
                            s = Double.toString(Double.longBitsToDouble(this.toBigInteger(data, offs, size, big_endian, true).longValue()));
                        }
                    }
                }
            }
        }
        if (s == null) {
            s = this.toBigInteger(data, offs, size, big_endian, false).toString(radix);
            switch (radix) {
                case 8: {
                    if (s.startsWith("0")) break;
                    s = "0" + s;
                    break;
                }
                case 16: {
                    int l = size * 2 - s.length();
                    if (l < 0) {
                        l = 0;
                    }
                    if (l > 16) {
                        l = 16;
                    }
                    s = String.valueOf("0000000000000000".substring(0, l)) + s;
                }
            }
        }
        if (s == null) {
            s = "N/A";
        }
        return s;
    }

    private String toNumberString(int radix) {
        byte[] data;
        String s = null;
        IExpressions.Value val = (IExpressions.Value)this.value.getData();
        if (val != null && (data = val.getValue()) != null) {
            s = this.toNumberString(radix, (ISymbols.Symbol)this.type.getData(), data, 0, data.length, val.isBigEndian());
        }
        if (s == null) {
            s = "N/A";
        }
        return s;
    }

    private void setLabel(ILabelUpdate result, String name, int col, int radix) {
        String s = this.toNumberString(radix);
        if (name == null) {
            result.setLabel(s, col);
        } else {
            result.setLabel(String.valueOf(name) + " = " + s, col);
        }
    }

    private boolean isValueChanged(IExpressions.Value x, IExpressions.Value y) {
        if (x == null || y == null) {
            return false;
        }
        byte[] xb = x.getValue();
        byte[] yb = y.getValue();
        if (xb == null || yb == null) {
            return false;
        }
        if (xb.length != yb.length) {
            return true;
        }
        int i = 0;
        while (i < xb.length) {
            if (xb[i] != yb[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected boolean getData(ILabelUpdate result, Runnable done) {
        String c;
        int i;
        Throwable error;
        String cast;
        TCFDataCache<ISymbols.Symbol> var;
        TCFDataCache<ISymbols.Symbol> field = this.model.getSymbolInfoCache(this.field_id);
        TCFDataCache<ISymbols.Symbol> pending = null;
        if (field != null && !field.validate()) {
            pending = field;
        }
        if (!this.var_expression.validate()) {
            pending = this.var_expression;
        }
        if (!this.text.validate()) {
            pending = this.text;
        }
        if (!this.value.validate()) {
            pending = this.value;
        }
        if (!this.type.validate()) {
            pending = this.type;
        }
        if (pending != null) {
            pending.wait(done);
            return false;
        }
        String name = null;
        if (this.index >= 0) {
            name = this.index == 0 && this.deref ? "*" : "[" + this.index + "]";
        }
        if (name == null && field != null && field.getData() != null) {
            name = ((ISymbols.Symbol)field.getData()).getName();
        }
        if (name == null && this.var_expression.getData() != null && (var = this.model.getSymbolInfoCache(((IExpressions.Expression)this.var_expression.getData()).getSymbolID())) != null) {
            if (!var.validate(done)) {
                return false;
            }
            if (var.getData() != null) {
                name = ((ISymbols.Symbol)var.getData()).getName();
            }
        }
        if (name == null && this.text.getData() != null) {
            name = (String)this.text.getData();
        }
        if (name != null && (cast = this.model.getCastToType(this.id)) != null) {
            name = "(" + cast + ")(" + name + ")";
        }
        if ((error = this.text.getError()) == null) {
            error = this.value.getError();
        }
        String[] cols = result.getColumnIds();
        if (error != null) {
            if (cols == null || cols.length <= 1) {
                result.setForeground(new RGB(255, 0, 0), 0);
                result.setLabel(String.valueOf(name) + ": N/A", 0);
            } else {
                i = 0;
                while (i < cols.length) {
                    c = cols[i];
                    if (c.equals("Name")) {
                        result.setLabel(name, i);
                    } else if (c.equals("Type")) {
                        if (!this.type_name.validate(done)) {
                            return false;
                        }
                        result.setLabel((String)this.type_name.getData(), i);
                    } else {
                        result.setForeground(new RGB(255, 0, 0), i);
                        result.setLabel("N/A", i);
                    }
                    ++i;
                }
            }
        } else if (cols == null) {
            this.setLabel(result, name, 0, 16);
        } else {
            i = 0;
            while (i < cols.length) {
                c = cols[i];
                if (c.equals("Name")) {
                    result.setLabel(name, i);
                } else if (c.equals("Type")) {
                    if (!this.type_name.validate(done)) {
                        return false;
                    }
                    result.setLabel((String)this.type_name.getData(), i);
                } else if (c.equals("HexValue")) {
                    this.setLabel(result, null, i, 16);
                } else if (c.equals("DecValue")) {
                    this.setLabel(result, null, i, 10);
                }
                ++i;
            }
        }
        this.next_value = (IExpressions.Value)this.value.getData();
        if (this.isValueChanged(this.prev_value, this.next_value)) {
            RGB c2 = new RGB(255, 255, 0);
            result.setBackground(c2, 0);
            if (cols != null) {
                int i2 = 1;
                while (i2 < cols.length) {
                    result.setBackground(c2, i2);
                    ++i2;
                }
            }
        }
        ISymbols.TypeClass type_class = ISymbols.TypeClass.unknown;
        ISymbols.Symbol type_symbol = (ISymbols.Symbol)this.type.getData();
        if (type_symbol != null) {
            type_class = type_symbol.getTypeClass();
        }
        switch (type_class) {
            case pointer: {
                result.setImageDescriptor(ImageCache.getImageDescriptor("icons/var_pointer.gif"), 0);
                break;
            }
            case array: 
            case composite: {
                result.setImageDescriptor(ImageCache.getImageDescriptor("icons/var_aggr.gif"), 0);
                break;
            }
            default: {
                result.setImageDescriptor(ImageCache.getImageDescriptor("icons/var_simple.gif"), 0);
            }
        }
        return true;
    }

    private void appendErrorText(StringBuffer bf, Throwable error) {
        if (error == null) {
            return;
        }
        bf.append("Exception: ");
        bf.append(TCFModel.getErrorMessage(error, true));
    }

    private boolean appendArrayValueText(StringBuffer bf, int level, ISymbols.Symbol type, byte[] data, int offs, int size, boolean big_endian, Runnable done) {
        assert (offs + size <= data.length);
        int length = type.getLength();
        bf.append('[');
        if (length > 0) {
            int elem_size = size / length;
            int n = 0;
            while (n < length) {
                if (n >= 100) {
                    bf.append("...");
                    break;
                }
                if (n > 0) {
                    bf.append(", ");
                }
                if (!this.appendValueText(bf, level + 1, type.getBaseTypeID(), data, offs + n * elem_size, elem_size, big_endian, done)) {
                    return false;
                }
                ++n;
            }
        }
        bf.append(']');
        return true;
    }

    private boolean appendCompositeValueText(StringBuffer bf, int level, ISymbols.Symbol type, byte[] data, int offs, int size, boolean big_endian, Runnable done) {
        TCFDataCache<String[]> children_cache = this.model.getSymbolChildrenCache(type.getID());
        if (children_cache == null) {
            bf.append("...");
            return true;
        }
        if (!children_cache.validate(done)) {
            return false;
        }
        String[] children_data = (String[])children_cache.getData();
        if (children_data == null) {
            bf.append("...");
            return true;
        }
        int cnt = 0;
        TCFDataCache<ISymbols.Symbol> pending = null;
        String[] stringArray = children_data;
        int n = children_data.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TCFDataCache<ISymbols.Symbol> field_cache = this.model.getSymbolInfoCache(id);
            if (!field_cache.validate()) {
                pending = field_cache;
            } else {
                ISymbols.Symbol field_data = (ISymbols.Symbol)field_cache.getData();
                if (field_data != null && field_data.getSymbolClass() == ISymbols.SymbolClass.reference) {
                    String name = field_data.getName();
                    int f_offs = field_data.getOffset();
                    int f_size = field_data.getSize();
                    if (name == null) {
                        if (offs + f_offs + f_size <= data.length) {
                            StringBuffer bf1 = new StringBuffer();
                            if (!this.appendCompositeValueText(bf1, level, field_data, data, offs + f_offs, f_size, big_endian, done)) {
                                return false;
                            }
                            if (bf1.length() > 0) {
                                if (cnt > 0) {
                                    bf.append(", ");
                                }
                                bf.append(bf1);
                                ++cnt;
                            }
                        }
                    } else {
                        if (cnt > 0) {
                            bf.append(", ");
                        }
                        bf.append(name);
                        bf.append('=');
                        if (offs + f_offs + f_size > data.length) {
                            bf.append('?');
                        } else if (!this.appendValueText(bf, level + 1, field_data.getTypeID(), data, offs + f_offs, f_size, big_endian, done)) {
                            return false;
                        }
                        ++cnt;
                    }
                }
            }
            ++n2;
        }
        if (pending == null) {
            return true;
        }
        pending.wait(done);
        return false;
    }

    private boolean appendValueText(StringBuffer bf, int level, String type_id, byte[] data, int offs, int size, boolean big_endian, Runnable done) {
        if (data == null) {
            return true;
        }
        ISymbols.Symbol type_data = null;
        if (type_id != null) {
            TCFDataCache<ISymbols.Symbol> type_cache = this.model.getSymbolInfoCache(type_id);
            if (!type_cache.validate(done)) {
                return false;
            }
            type_data = (ISymbols.Symbol)type_cache.getData();
        }
        if (type_data == null) {
            if (level == 0) {
                bf.append("Type: not available\n");
                bf.append("Size: ");
                bf.append(data.length);
                bf.append(data.length == 1 ? " byte\n" : " bytes\n");
                bf.append("Hex: ");
                bf.append(this.toNumberString(16, type_data, data, 0, data.length, big_endian));
                bf.append("\n");
            } else {
                bf.append(this.toNumberString(16, type_data, data, 0, data.length, big_endian));
            }
            return true;
        }
        if (level == 0) {
            if (!this.string.validate(done)) {
                return false;
            }
            Throwable e = this.string.getError();
            String s = (String)this.string.getData();
            if (s != null) {
                bf.append(s);
                bf.append("\n");
            } else if (e != null) {
                bf.append("Cannot read pointed value: ");
                bf.append(TCFModel.getErrorMessage(e, true));
            }
        }
        if (type_data.getSize() > 0) {
            switch (type_data.getTypeClass()) {
                case cardinal: 
                case integer: 
                case real: 
                case enumeration: {
                    if (level == 0) {
                        bf.append("Dec: ");
                        bf.append(this.toNumberString(10, type_data, data, offs, size, big_endian));
                        bf.append("\n");
                        bf.append("Oct: ");
                        bf.append(this.toNumberString(8, type_data, data, offs, size, big_endian));
                        bf.append("\n");
                        bf.append("Hex: ");
                        bf.append(this.toNumberString(16, type_data, data, offs, size, big_endian));
                        bf.append("\n");
                        break;
                    }
                    if (type_data.getTypeClass() == ISymbols.TypeClass.cardinal) {
                        bf.append("0x");
                        bf.append(this.toNumberString(16, type_data, data, offs, size, big_endian));
                        break;
                    }
                    bf.append(this.toNumberString(10, type_data, data, offs, size, big_endian));
                    break;
                }
                case pointer: 
                case function: {
                    if (level == 0) {
                        bf.append("Oct: ");
                        bf.append(this.toNumberString(8, type_data, data, offs, size, big_endian));
                        bf.append("\n");
                        bf.append("Hex: ");
                        bf.append(this.toNumberString(16, type_data, data, offs, size, big_endian));
                        bf.append("\n");
                        break;
                    }
                    bf.append("0x");
                    bf.append(this.toNumberString(16, type_data, data, offs, size, big_endian));
                    break;
                }
                case array: {
                    if (!this.appendArrayValueText(bf, level, type_data, data, offs, size, big_endian, done)) {
                        return false;
                    }
                    if (level != 0) break;
                    bf.append("\n");
                    break;
                }
                case composite: {
                    bf.append('{');
                    if (!this.appendCompositeValueText(bf, level, type_data, data, offs, size, big_endian, done)) {
                        return false;
                    }
                    bf.append('}');
                    if (level != 0) break;
                    bf.append("\n");
                }
            }
        }
        if (level == 0) {
            if (!this.type_name.validate(done)) {
                return false;
            }
            String nm = (String)this.type_name.getData();
            if (nm != null) {
                bf.append("Type: ");
                bf.append(nm);
                bf.append("\n");
            }
            bf.append("Size: ");
            bf.append(type_data.getSize());
            bf.append(type_data.getSize() == 1 ? " byte\n" : " bytes\n");
        }
        return true;
    }

    private String getRegisterName(String reg_id, Runnable done) {
        String name = reg_id;
        TCFChildren pending = null;
        TCFNodeRegister reg_node = null;
        LinkedList<TCFChildren> queue = new LinkedList<TCFChildren>();
        TCFNode n = this.parent;
        while (n != null) {
            if (n instanceof TCFNodeStackFrame) {
                queue.add(((TCFNodeStackFrame)n).getRegisters());
            }
            if (n instanceof TCFNodeExecContext) {
                queue.add(((TCFNodeExecContext)n).getRegisters());
                break;
            }
            n = n.parent;
        }
        while (!queue.isEmpty()) {
            TCFChildren reg_list = (TCFChildren)((Object)queue.removeFirst());
            if (!reg_list.validate()) {
                pending = reg_list;
                continue;
            }
            Map reg_map = (Map)reg_list.getData();
            if (reg_map == null) continue;
            reg_node = (TCFNodeRegister)reg_map.get(reg_id);
            if (reg_node != null) break;
            for (TCFNode node : reg_map.values()) {
                queue.add(((TCFNodeRegister)node).getChildren());
            }
        }
        if (pending != null) {
            pending.wait(done);
            return null;
        }
        if (reg_node != null) {
            TCFDataCache<IRegisters.RegistersContext> reg_ctx_cache = reg_node.getContext();
            if (!reg_ctx_cache.validate(done)) {
                return null;
            }
            IRegisters.RegistersContext reg_ctx_data = (IRegisters.RegistersContext)reg_ctx_cache.getData();
            if (reg_ctx_data != null && reg_ctx_data.getName() != null) {
                name = reg_ctx_data.getName();
            }
        }
        return name;
    }

    String getDetailText(Runnable done) {
        IExpressions.Value v;
        if (!this.expression.validate(done)) {
            return null;
        }
        if (!this.value.validate(done)) {
            return null;
        }
        StringBuffer bf = new StringBuffer();
        this.appendErrorText(bf, this.expression.getError());
        if (bf.length() == 0) {
            this.appendErrorText(bf, this.value.getError());
        }
        if (bf.length() == 0 && (v = (IExpressions.Value)this.value.getData()) != null) {
            Number addr;
            String reg_id;
            byte[] data = v.getValue();
            if (data != null) {
                boolean big_endian = v.isBigEndian();
                if (!this.appendValueText(bf, 0, v.getTypeID(), data, 0, data.length, big_endian, done)) {
                    return null;
                }
            }
            if ((reg_id = v.getRegisterID()) != null) {
                String nm = this.getRegisterName(reg_id, done);
                if (nm == null) {
                    return null;
                }
                bf.append("Register: ");
                bf.append(nm);
                bf.append('\n');
            }
            if ((addr = v.getAddress()) != null) {
                BigInteger i = addr instanceof BigInteger ? (BigInteger)addr : new BigInteger(addr.toString());
                bf.append("Address: 0x");
                bf.append(i.toString(16));
                bf.append('\n');
            }
        }
        return bf.toString();
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        result.setChildCount(this.children.size());
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        return this.children.getData(result, done);
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        result.setHasChilren(this.children.size() > 0);
        return true;
    }

    @Override
    public int compareTo(TCFNode n) {
        TCFNodeExpression e = (TCFNodeExpression)n;
        if (this.sort_pos < e.sort_pos) {
            return -1;
        }
        if (this.sort_pos > e.sort_pos) {
            return 1;
        }
        return 0;
    }

    public CellEditor getCellEditor(IPresentationContext context, String column_id, Object element, Composite parent) {
        assert (element == this);
        if ("Name".equals(column_id) && this.script != null) {
            return new TextCellEditor(parent);
        }
        if ("HexValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        if ("DecValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        assert (element == this);
        return cell_modifier;
    }

    @Override
    public Object getAdapter(Class adapter) {
        String script;
        if (adapter == IExpression.class && (script = this.script) != null) {
            IExpressionManager m = DebugPlugin.getDefault().getExpressionManager();
            IExpression[] iExpressionArray = m.getExpressions();
            int n = iExpressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExpression e = iExpressionArray[n2];
                if (script.equals(e.getExpressionText())) {
                    return e;
                }
                ++n2;
            }
        }
        return super.getAdapter(adapter);
    }

    public TCFDataCache<String> getExpressionText() {
        return this.expression_text;
    }

    private class Expression {
        final IExpressions.Expression expression;
        boolean must_be_disposed;

        Expression(IExpressions.Expression expression) {
            assert (expression != null);
            this.expression = expression;
        }

        void dispose() {
            if (!this.must_be_disposed) {
                return;
            }
            if (TCFNodeExpression.this.channel.getState() == 1) {
                IExpressions exps = (IExpressions)TCFNodeExpression.this.channel.getRemoteService(IExpressions.class);
                exps.dispose(this.expression.getID(), new IExpressions.DoneDispose(){

                    public void doneDispose(IToken token, Exception error) {
                        if (error == null) {
                            return;
                        }
                        if (((Expression)Expression.this).TCFNodeExpression.this.channel.getState() != 1) {
                            return;
                        }
                        Activator.log("Error disposing remote expression evaluator", error);
                    }
                });
            }
            this.must_be_disposed = false;
        }
    }
}

