/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.ui.model.ISymbolOwner;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeSymbol;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFNodeLaunch
extends TCFNode
implements ISymbolOwner {
    private final TCFChildrenExecContext children;
    private final TCFNode.TCFData<TCFNode[]> filtered_children;
    private final Map<String, TCFNodeSymbol> symbols = new HashMap<String, TCFNodeSymbol>();

    TCFNodeLaunch(final TCFModel model) {
        super(model);
        this.children = new TCFChildrenExecContext(this);
        this.filtered_children = new TCFNode.TCFData<TCFNode[]>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                Set filter = model.getLaunch().getContextFilter();
                if (filter == null) {
                    if (!TCFNodeLaunch.this.children.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    this.set(null, TCFNodeLaunch.this.children.getError(), TCFNodeLaunch.this.children.toArray());
                    return true;
                }
                HashSet<TCFNode> nodes = new HashSet<TCFNode>();
                for (String id : filter) {
                    if (!model.createNode(id, this)) {
                        return false;
                    }
                    if (this.isValid()) {
                        this.reset();
                        continue;
                    }
                    nodes.add(model.getNode(id));
                }
                Object[] array = nodes.toArray(new TCFNode[nodes.size()]);
                Arrays.sort(array);
                this.set(null, null, array);
                return true;
            }
        };
        Protocol.invokeLater((Runnable)new Runnable(){
            boolean done;

            public void run() {
                if (this.done) {
                    return;
                }
                ArrayList nodes = new ArrayList();
                if (!TCFNodeLaunch.this.searchSuspendedThreads((TCFDataCache<TCFNode[]>)TCFNodeLaunch.this.filtered_children, (ArrayList<TCFNodeExecContext>)nodes, this)) {
                    return;
                }
                if (nodes.size() == 1) {
                    TCFNodeExecContext n = (TCFNodeExecContext)nodes.get(0);
                    model.setDebugViewSelection(n, "Launch");
                } else {
                    for (TCFNodeExecContext n : nodes) {
                        String reason = ((TCFContextState)n.getState().getData()).suspend_reason;
                        model.setDebugViewSelection(n, reason);
                    }
                }
                this.done = true;
            }
        });
    }

    private boolean searchSuspendedThreads(TCFDataCache<TCFNode[]> c, ArrayList<TCFNodeExecContext> nodes, Runnable r) {
        if (!c.validate(r)) {
            return false;
        }
        TCFNode[] arr = (TCFNode[])c.getData();
        if (arr == null) {
            return true;
        }
        TCFNode[] tCFNodeArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode n3 = tCFNodeArray[n2];
            if (!this.searchSuspendedThreads((TCFNodeExecContext)n3, nodes, r)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean searchSuspendedThreads(TCFChildren c, ArrayList<TCFNodeExecContext> nodes, Runnable r) {
        if (!c.validate(r)) {
            return false;
        }
        TCFNode[] tCFNodeArray = c.toArray();
        int n = tCFNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode n3 = tCFNodeArray[n2];
            if (!this.searchSuspendedThreads((TCFNodeExecContext)n3, nodes, r)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean searchSuspendedThreads(TCFNodeExecContext n, ArrayList<TCFNodeExecContext> nodes, Runnable r) {
        TCFDataCache<IRunControl.RunControlContext> run_context = n.getRunContext();
        if (!run_context.validate(r)) {
            return false;
        }
        IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)run_context.getData();
        if (ctx != null && ctx.hasState()) {
            TCFDataCache<TCFContextState> state = n.getState();
            if (!state.validate(r)) {
                return false;
            }
            TCFContextState s = (TCFContextState)state.getData();
            if (s != null && s.is_suspended) {
                nodes.add(n);
            }
            return true;
        }
        return this.searchSuspendedThreads(n.getChildren(), nodes, r);
    }

    @Override
    void dispose() {
        ArrayList<TCFNodeSymbol> l = new ArrayList<TCFNodeSymbol>(this.symbols.values());
        for (TCFNodeSymbol s : l) {
            s.dispose();
        }
        assert (this.symbols.size() == 0);
        super.dispose();
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        if ("org.eclipse.debug.ui.DebugView".equals(result.getPresentationContext().getId())) {
            if (!this.filtered_children.validate(done)) {
                return false;
            }
            TCFNode[] arr = (TCFNode[])this.filtered_children.getData();
            result.setChildCount(arr == null ? 0 : arr.length);
        } else {
            result.setChildCount(0);
        }
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        if ("org.eclipse.debug.ui.DebugView".equals(result.getPresentationContext().getId())) {
            if (!this.filtered_children.validate(done)) {
                return false;
            }
            TCFNode[] arr = (TCFNode[])this.filtered_children.getData();
            if (arr != null) {
                int offset = 0;
                int r_offset = result.getOffset();
                int r_length = result.getLength();
                TCFNode[] tCFNodeArray = arr;
                int n = arr.length;
                int n2 = 0;
                while (n2 < n) {
                    TCFNode n3 = tCFNodeArray[n2];
                    if (offset >= r_offset && offset < r_offset + r_length) {
                        result.setChild((Object)n3, offset);
                    }
                    ++offset;
                    ++n2;
                }
            }
        }
        return true;
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        if ("org.eclipse.debug.ui.DebugView".equals(result.getPresentationContext().getId())) {
            if (!this.filtered_children.validate(done)) {
                return false;
            }
            TCFNode[] arr = (TCFNode[])this.filtered_children.getData();
            result.setHasChilren(arr != null && arr.length > 0);
        } else {
            result.setHasChilren(false);
        }
        return true;
    }

    void onContextAdded(IRunControl.RunControlContext context) {
        this.children.onContextAdded(context);
    }

    void onContextAdded(IMemory.MemoryContext context) {
        this.children.onContextAdded(context);
    }

    void onAnyContextSuspendedOrChanged() {
        for (TCFNodeSymbol s : this.symbols.values()) {
            s.onMemoryMapChanged();
        }
    }

    void onAnyContextAddedOrRemoved() {
        this.filtered_children.reset();
    }

    @Override
    public void addSymbol(TCFNodeSymbol s) {
        assert (this.symbols.get(s.id) == null);
        this.symbols.put(s.id, s);
    }

    @Override
    public void removeSymbol(TCFNodeSymbol s) {
        assert (this.symbols.get(s.id) == s);
        this.symbols.remove(s.id);
    }

    public TCFChildrenExecContext getChildren() {
        return this.children;
    }

    public TCFNode.TCFData<TCFNode[]> getFilteredChildren() {
        return this.filtered_children;
    }
}

