/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.math.BigInteger;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.tcf.services.IMemoryMap;

public class TCFNodeModule
extends TCFNode {
    private final IMemoryMap.MemoryRegion region;

    protected TCFNodeModule(TCFNode parent, String id, IMemoryMap.MemoryRegion region) {
        super(parent, id);
        this.region = region;
    }

    protected boolean getData(ILabelUpdate update, Runnable done) {
        String[] col_ids = update.getColumnIds();
        if (col_ids == null) {
            update.setLabel(this.region.getFileName(), 0);
        } else {
            int i = 0;
            while (i < col_ids.length) {
                String col_id = col_ids[i];
                if ("Name".equals(col_id)) {
                    update.setLabel(this.region.getFileName(), i);
                } else if ("Address".equals(col_id)) {
                    update.setLabel(this.toHexString(this.region.getAddress()), i);
                } else if ("Size".equals(col_id)) {
                    update.setLabel(this.toHexString(this.region.getSize()), i);
                } else if ("Flags".equals(col_id)) {
                    update.setLabel(this.getFlagsLabel(this.region.getFlags()), i);
                } else if ("Offset".equals(col_id)) {
                    update.setLabel(this.toHexString(this.region.getOffset()), i);
                } else if ("Section".equals(col_id)) {
                    String sectionName = this.region.getSectionName();
                    update.setLabel(sectionName != null ? sectionName : "", i);
                }
                ++i;
            }
        }
        update.setImageDescriptor(ImageCache.getImageDescriptor("icons/memory-map.gif"), 0);
        return true;
    }

    public String getDetailText(Runnable done) {
        StringBuilder detail = new StringBuilder();
        detail.append("File: ").append(this.region.getFileName()).append('\n');
        detail.append("Address: ").append(this.toHexString(this.region.getAddress())).append('\n');
        detail.append("Size: ").append(this.toHexString(this.region.getSize())).append('\n');
        detail.append("Flags: ").append(this.getFlagsLabel(this.region.getFlags())).append('\n');
        detail.append("Offset: ").append(this.toHexString(this.region.getOffset())).append('\n');
        String sectionName = this.region.getSectionName();
        detail.append("Section: ").append(sectionName != null ? sectionName : "<unknown>").append('\n');
        return detail.toString();
    }

    private String toHexString(Number address) {
        if (address == null) {
            return "";
        }
        BigInteger addr = address instanceof BigInteger ? (BigInteger)address : new BigInteger(address.toString());
        String s = addr.toString(16);
        int sz = s.length() <= 8 ? 8 : 16;
        int l = sz - s.length();
        if (l < 0) {
            l = 0;
        }
        if (l > 16) {
            l = 16;
        }
        return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
    }

    private String getFlagsLabel(int flags) {
        StringBuilder flagsLabel = new StringBuilder(3);
        if ((flags & 1) != 0) {
            flagsLabel.append('r');
        } else {
            flagsLabel.append('-');
        }
        if ((flags & 2) != 0) {
            flagsLabel.append('w');
        } else {
            flagsLabel.append('-');
        }
        if ((flags & 4) != 0) {
            flagsLabel.append('x');
        } else {
            flagsLabel.append('-');
        }
        return flagsLabel.toString();
    }
}

