/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenRegisters;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModelProxy;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNumberFormat;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IRegisters;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFNodeRegister
extends TCFNode
implements IElementEditor {
    private final TCFChildrenRegisters children;
    private final TCFNode.TCFData<IRegisters.RegistersContext> context;
    private final TCFNode.TCFData<byte[]> value;
    private final boolean is_stack_frame_register;
    private byte[] prev_value;
    private byte[] next_value;
    private static final RGB rgb_error = new RGB(255, 0, 0);
    private static final RGB rgb_highlight = new RGB(255, 255, 0);
    private int index;
    private static final ICellModifier cell_modifier = new ICellModifier(){

        public boolean canModify(Object element, final String property) {
            final TCFNodeRegister node = (TCFNodeRegister)element;
            return (Boolean)new TCFTask<Boolean>(){

                public void run() {
                    if (!node.context.validate((Runnable)((Object)this))) {
                        return;
                    }
                    IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)node.context.getData();
                    if (ctx != null && ctx.isWriteable()) {
                        if (!ctx.isReadable()) {
                            this.done(Boolean.TRUE);
                            return;
                        }
                        if (!node.value.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (node.value.getError() == null) {
                            if ("HexValue".equals(property)) {
                                this.done(TCFNumberFormat.isValidHexNumber(node.toNumberString(16)) == null);
                                return;
                            }
                            if ("DecValue".equals(property)) {
                                this.done(TCFNumberFormat.isValidDecNumber(true, node.toNumberString(10)) == null);
                                return;
                            }
                        }
                    }
                    this.done(Boolean.FALSE);
                }
            }.getE();
        }

        public Object getValue(Object element, final String property) {
            final TCFNodeRegister node = (TCFNodeRegister)element;
            return new TCFTask<String>(){

                public void run() {
                    if (!node.context.validate((Runnable)((Object)this))) {
                        return;
                    }
                    IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)node.context.getData();
                    if (!ctx.isReadable()) {
                        this.done("0");
                        return;
                    }
                    if (!node.value.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (node.value.getError() == null) {
                        if ("HexValue".equals(property)) {
                            this.done(node.toNumberString(16));
                            return;
                        }
                        if ("DecValue".equals(property)) {
                            this.done(node.toNumberString(10));
                            return;
                        }
                    }
                    this.done(null);
                }
            }.getE();
        }

        public void modify(Object element, final String property, final Object value) {
            if (value == null) {
                return;
            }
            final TCFNodeRegister node = (TCFNodeRegister)element;
            new TCFTask<Boolean>(){

                public void run() {
                    try {
                        if (!node.context.validate((Runnable)((Object)this))) {
                            return;
                        }
                        IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)node.context.getData();
                        if (ctx != null && ctx.isWriteable()) {
                            byte[] bf = null;
                            boolean is_float = ctx.isFloat();
                            int size = ctx.getSize();
                            boolean big_endian = ctx.isBigEndian();
                            String input = (String)value;
                            String error = null;
                            if ("HexValue".equals(property)) {
                                error = TCFNumberFormat.isValidHexNumber(input);
                                if (error == null) {
                                    bf = TCFNumberFormat.toByteArray(input, 16, false, size, false, big_endian);
                                }
                            } else if ("DecValue".equals(property) && (error = TCFNumberFormat.isValidDecNumber(is_float, input)) == null) {
                                bf = TCFNumberFormat.toByteArray(input, 10, is_float, size, is_float, big_endian);
                            }
                            if (error != null) {
                                throw new Exception("Invalid value: " + value, new Exception(error));
                            }
                            if (bf != null) {
                                ctx.set(bf, new IRegisters.DoneSet(){

                                    public void doneSet(IToken token, Exception error) {
                                        if (error != null) {
                                            node.model.showMessageBox("Cannot modify register value", error);
                                            this.done(Boolean.FALSE);
                                        } else {
                                            node.value.reset();
                                            node.postStateChangedDelta();
                                            this.done(Boolean.TRUE);
                                        }
                                    }
                                });
                                return;
                            }
                        }
                        this.done(Boolean.FALSE);
                    }
                    catch (Throwable x) {
                        node.model.showMessageBox("Cannot modify register value", x);
                        this.done(Boolean.FALSE);
                    }
                }
            }.getE();
        }
    };

    TCFNodeRegister(TCFNode parent, final String id) {
        super(parent, id);
        this.is_stack_frame_register = parent instanceof TCFNodeStackFrame ? true : (parent instanceof TCFNodeRegister ? ((TCFNodeRegister)parent).is_stack_frame_register : false);
        this.children = new TCFChildrenRegisters(this);
        this.context = new TCFNode.TCFData<IRegisters.RegistersContext>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                IRegisters regs = (IRegisters)TCFNodeRegister.this.model.getLaunch().getService(IRegisters.class);
                this.command = regs.getContext(id, new IRegisters.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IRegisters.RegistersContext context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.value = new TCFNode.TCFData<byte[]>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                Boolean b = TCFNodeRegister.this.usePrevValue((Runnable)((Object)this));
                if (b == null) {
                    return false;
                }
                if (b.booleanValue()) {
                    this.set(null, null, TCFNodeRegister.this.prev_value);
                    return true;
                }
                if (!TCFNodeRegister.this.context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)TCFNodeRegister.this.context.getData();
                if (ctx == null || ctx.getSize() <= 0) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = ctx.get(new IRegisters.DoneGet(){

                    public void doneGet(IToken token, Exception error, byte[] value) {
                        Boolean b;
                        if (error != null && (b = TCFNodeRegister.this.usePrevValue(null)) != null && b.booleanValue()) {
                            this.set(token, null, TCFNodeRegister.this.prev_value);
                            return;
                        }
                        this.set(token, error, value);
                    }
                });
                return false;
            }
        };
    }

    public TCFDataCache<IRegisters.RegistersContext> getContext() {
        return this.context;
    }

    public TCFDataCache<byte[]> getValue() {
        return this.value;
    }

    public TCFChildren getChildren() {
        return this.children;
    }

    void setIndex(int index) {
        this.index = index;
    }

    private Boolean usePrevValue(Runnable done) {
        if (this.prev_value == null) {
            return false;
        }
        if (this.parent instanceof TCFNodeStackFrame) {
            TCFNodeExecContext exe = (TCFNodeExecContext)this.parent.parent;
            TCFDataCache<TCFContextState> state_cache = exe.getState();
            if (!state_cache.validate(done)) {
                return null;
            }
            TCFContextState state = (TCFContextState)state_cache.getData();
            if (state == null || !state.is_suspended) {
                return true;
            }
            TCFChildrenStackTrace stack_trace_cache = exe.getStackTrace();
            if (!stack_trace_cache.validate(done)) {
                return null;
            }
            if (((Map)stack_trace_cache.getData()).get(this.parent.id) == null) {
                return true;
            }
        } else if (this.parent instanceof TCFNodeExecContext) {
            TCFNodeExecContext exe = (TCFNodeExecContext)this.parent;
            TCFDataCache<TCFContextState> state_cache = exe.getState();
            if (!state_cache.validate(done)) {
                return null;
            }
            TCFContextState state = (TCFContextState)state_cache.getData();
            if (state == null || !state.is_suspended) {
                return true;
            }
        }
        return false;
    }

    private void appendErrorText(StringBuffer bf, Throwable error) {
        if (error == null) {
            return;
        }
        bf.append("Exception: ");
        bf.append(TCFModel.getErrorMessage(error, true));
    }

    String getDetailText(Runnable done) {
        if (!this.context.validate(done)) {
            return null;
        }
        if (!this.value.validate(done)) {
            return null;
        }
        StringBuffer bf = new StringBuffer();
        this.appendErrorText(bf, this.context.getError());
        if (bf.length() == 0) {
            this.appendErrorText(bf, this.value.getError());
        }
        if (bf.length() == 0) {
            byte[] v;
            IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)this.context.getData();
            if (ctx != null) {
                if (ctx.getDescription() != null) {
                    bf.append(ctx.getDescription());
                    bf.append('\n');
                }
                int l = bf.length();
                if (ctx.isReadable()) {
                    bf.append("readable");
                }
                if (ctx.isReadOnce()) {
                    if (l < bf.length()) {
                        bf.append(", ");
                    }
                    bf.append("read once");
                }
                if (ctx.isWriteable()) {
                    if (l < bf.length()) {
                        bf.append(", ");
                    }
                    bf.append("writable");
                }
                if (ctx.isWriteOnce()) {
                    if (l < bf.length()) {
                        bf.append(", ");
                    }
                    bf.append("write once");
                }
                if (ctx.hasSideEffects()) {
                    if (l < bf.length()) {
                        bf.append(", ");
                    }
                    bf.append("side effects");
                }
                if (l < bf.length()) {
                    bf.append('\n');
                }
            }
            if ((v = (byte[])this.value.getData()) != null) {
                bf.append("Hex: ");
                bf.append(this.toNumberString(16));
                bf.append(", ");
                bf.append("Dec: ");
                bf.append(this.toNumberString(10));
                bf.append(", ");
                bf.append("Oct: ");
                bf.append(this.toNumberString(8));
                bf.append('\n');
                bf.append("Bin: ");
                bf.append(this.toNumberString(2));
                bf.append('\n');
            }
        }
        return bf.toString();
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        result.setHasChilren(this.children.size() > 0);
        return true;
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        result.setChildCount(this.children.size());
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        return this.children.getData(result, done);
    }

    @Override
    protected boolean getData(ILabelUpdate result, Runnable done) {
        int i;
        TCFNode.TCFData<IRegisters.RegistersContext> pending = null;
        if (!this.context.validate()) {
            pending = this.context;
        }
        if (!this.value.validate()) {
            pending = this.value;
        }
        if (pending != null) {
            pending.wait(done);
            return false;
        }
        String[] cols = result.getColumnIds();
        if (cols == null) {
            this.setLabel(result, -1, 16);
        } else {
            IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)this.context.getData();
            i = 0;
            while (i < cols.length) {
                String c = cols[i];
                if (ctx == null) {
                    result.setForeground(rgb_error, i);
                    result.setLabel("N/A", i);
                } else if (c.equals("Name")) {
                    result.setLabel(ctx.getName(), i);
                } else if (c.equals("HexValue")) {
                    this.setLabel(result, i, 16);
                } else if (c.equals("DecValue")) {
                    this.setLabel(result, i, 10);
                } else if (c.equals("Description")) {
                    result.setLabel(ctx.getDescription(), i);
                } else if (c.equals("Readable")) {
                    result.setLabel(this.bool(ctx.isReadable()), i);
                } else if (c.equals("ReadOnce")) {
                    result.setLabel(this.bool(ctx.isReadOnce()), i);
                } else if (c.equals("Writeable")) {
                    result.setLabel(this.bool(ctx.isWriteable()), i);
                } else if (c.equals("WriteOnce")) {
                    result.setLabel(this.bool(ctx.isWriteOnce()), i);
                } else if (c.equals("SideEffects")) {
                    result.setLabel(this.bool(ctx.hasSideEffects()), i);
                } else if (c.equals("Volatile")) {
                    result.setLabel(this.bool(ctx.isVolatile()), i);
                } else if (c.equals("Float")) {
                    result.setLabel(this.bool(ctx.isFloat()), i);
                } else if (c.equals("Menimonic")) {
                    result.setLabel(this.getMnemonic(ctx), i);
                }
                ++i;
            }
        }
        boolean changed = false;
        this.next_value = (byte[])this.value.getData();
        if (this.prev_value != null && this.next_value != null) {
            if (this.prev_value.length != this.next_value.length) {
                changed = true;
            } else {
                i = 0;
                while (i < this.prev_value.length) {
                    if (this.prev_value[i] != this.next_value[i]) {
                        changed = true;
                    }
                    ++i;
                }
            }
        }
        if (changed) {
            result.setBackground(rgb_highlight, 0);
            if (cols != null) {
                i = 1;
                while (i < cols.length) {
                    result.setBackground(rgb_highlight, i);
                    ++i;
                }
            }
        }
        result.setImageDescriptor(ImageCache.getImageDescriptor("icons/full/obj16/genericregister_obj.gif"), 0);
        return true;
    }

    private void setLabel(ILabelUpdate result, int col, int radix) {
        IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)this.context.getData();
        Throwable error = this.context.getError();
        if (error == null) {
            error = this.value.getError();
        }
        byte[] data = (byte[])this.value.getData();
        if (error != null || ctx == null) {
            result.setForeground(rgb_error, col);
            result.setLabel("N/A", col);
        } else if (data != null) {
            String s = this.toNumberString(radix);
            if (col >= 0) {
                result.setLabel(s, col);
            } else {
                result.setLabel(String.valueOf(ctx.getName()) + " = " + s, 0);
            }
        }
    }

    private String toNumberString(int radix) {
        IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)this.context.getData();
        byte[] data = (byte[])this.value.getData();
        if (ctx == null || data == null) {
            return "N/A";
        }
        if (radix == 2) {
            StringBuffer bf = new StringBuffer();
            int i = data.length * 8;
            while (i > 0) {
                if (i % 4 == 0 && bf.length() > 0) {
                    bf.append(',');
                }
                int j = --i / 8;
                if (ctx.isBigEndian()) {
                    j = data.length - j - 1;
                }
                if ((data[j] & 1 << i % 8) != 0) {
                    bf.append('1');
                    continue;
                }
                bf.append('0');
            }
            return bf.toString();
        }
        byte[] temp = new byte[data.length + 1];
        temp[0] = 0;
        if (ctx.isBigEndian()) {
            System.arraycopy(data, 0, temp, 1, data.length);
        } else {
            int i = 0;
            while (i < data.length) {
                temp[temp.length - i - 1] = data[i];
                ++i;
            }
        }
        String s = new BigInteger(temp).toString(radix);
        switch (radix) {
            case 8: {
                if (s.startsWith("0")) break;
                s = "0" + s;
                break;
            }
            case 16: {
                int l = data.length * 2 - s.length();
                if (l < 0) {
                    l = 0;
                }
                if (l > 16) {
                    l = 16;
                }
                s = String.valueOf("0000000000000000".substring(0, l)) + s;
            }
        }
        return s;
    }

    private String bool(boolean b) {
        return b ? "yes" : "no";
    }

    private String getMnemonic(IRegisters.RegistersContext ctx) {
        IRegisters.NamedValue[] arr;
        if (this.value.getData() != null && (arr = ctx.getNamedValues()) != null) {
            IRegisters.NamedValue[] namedValueArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                IRegisters.NamedValue n3 = namedValueArray[n2];
                if (Arrays.equals(n3.getValue(), (byte[])this.value.getData())) {
                    return n3.getName();
                }
                ++n2;
            }
        }
        return "";
    }

    private void postStateChangedDelta() {
        for (TCFModelProxy p : this.model.getModelProxies()) {
            if (!"org.eclipse.debug.ui.RegisterView".equals(p.getPresentationContext().getId())) continue;
            p.addDelta(this, 2048);
        }
    }

    void onValueChanged() {
        this.prev_value = this.next_value;
        this.value.reset();
        TCFNode n = this.parent;
        while (n != null) {
            if (n instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)n).onRegisterValueChanged();
                break;
            }
            if (n instanceof TCFNodeRegister) {
                TCFNodeRegister r = (TCFNodeRegister)n;
                if (r.value.isValid() && r.value.getData() != null) {
                    r.value.reset();
                    r.postStateChangedDelta();
                }
            }
            n = n.parent;
        }
        this.children.onParentValueChanged();
        this.postStateChangedDelta();
    }

    void onParentValueChanged() {
        this.value.reset();
        this.children.onParentValueChanged();
        this.postStateChangedDelta();
    }

    void onSuspended() {
        this.prev_value = this.next_value;
        this.value.reset();
        this.children.onSuspended();
        if (this.is_stack_frame_register) {
            this.children.reset();
        }
    }

    void onRegistersChanged() {
        this.children.onRegistersChanged();
        this.context.reset();
        this.value.reset();
    }

    public CellEditor getCellEditor(IPresentationContext context, String column_id, Object element, Composite parent) {
        assert (element == this);
        if ("HexValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        if ("DecValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        assert (element == this);
        return cell_modifier;
    }

    @Override
    public int compareTo(TCFNode n) {
        if (n instanceof TCFNodeRegister) {
            TCFNodeRegister r = (TCFNodeRegister)n;
            if (this.index < r.index) {
                return -1;
            }
            if (this.index > r.index) {
                return 1;
            }
        }
        return this.id.compareTo(n.id);
    }
}

