/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.actions;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.internal.tcf.debug.actions.TCFAction;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IBreakpoints;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.services.IStackTrace;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCFActionStepOut
extends TCFAction
implements IRunControl.RunControlListener {
    private final boolean step_back;
    private final IRunControl rc;
    private final IBreakpoints bps;
    private IRunControl.RunControlContext ctx;
    private TCFDataCache<TCFContextState> state;
    private int step_cnt;
    private Map<String, Object> bp;
    protected boolean exited;

    public TCFActionStepOut(TCFLaunch launch, IRunControl.RunControlContext ctx, boolean step_back) {
        super(launch, ctx.getID());
        this.rc = this.launch.getService(IRunControl.class);
        this.bps = this.launch.getService(IBreakpoints.class);
        this.ctx = ctx;
        this.step_back = step_back;
    }

    protected abstract TCFDataCache<TCFContextState> getContextState();

    protected abstract TCFDataCache<?> getStackTrace();

    protected abstract TCFDataCache<IStackTrace.StackTraceContext> getStackFrame();

    protected abstract int getStackFrameIndex();

    @Override
    public void run() {
        if (this.exited) {
            return;
        }
        try {
            this.runAction();
        }
        catch (Throwable x) {
            this.exit(x);
        }
    }

    private void runAction() {
        int mode;
        if (this.aborted) {
            this.exit(null);
            return;
        }
        if (this.state == null) {
            this.rc.addListener((IRunControl.RunControlListener)this);
            this.state = this.getContextState();
            if (this.state == null) {
                this.exit(new Exception("Invalid context ID"));
                return;
            }
        }
        if (!this.state.validate((Runnable)this)) {
            return;
        }
        if (this.state.getData() == null || !((TCFContextState)this.state.getData()).is_suspended) {
            Throwable error = this.state.getError();
            if (error == null) {
                error = new Exception("Context is not suspended");
            }
            this.exit(error);
            return;
        }
        TCFDataCache<?> stack_trace = this.getStackTrace();
        if (!stack_trace.validate((Runnable)this)) {
            return;
        }
        int frame_index = this.getStackFrameIndex();
        if (this.step_cnt > 0) {
            boolean ok;
            TCFContextState state_data = (TCFContextState)this.state.getData();
            boolean bl = ok = this.isMyBreakpoint(state_data) || "Step".equals(state_data.suspend_reason);
            if (!ok) {
                this.exit(null, state_data.suspend_reason);
            } else if (frame_index < 0) {
                this.exit(null);
            }
            if (this.exited) {
                return;
            }
        }
        int n = mode = this.step_back ? 11 : 5;
        if (this.ctx.canResume(mode)) {
            int cnt = 1;
            if (this.ctx.canCount(mode)) {
                cnt += frame_index;
            }
            this.ctx.resume(mode, cnt, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TCFActionStepOut.this.exit(error);
                    }
                }
            });
            ++this.step_cnt;
            return;
        }
        if (this.bps != null && this.ctx.canResume(this.step_back ? 6 : 0)) {
            if (this.bp == null) {
                TCFDataCache<IStackTrace.StackTraceContext> frame = this.getStackFrame();
                if (!frame.validate((Runnable)this)) {
                    return;
                }
                Number addr = null;
                if (frame.getData() != null) {
                    addr = ((IStackTrace.StackTraceContext)frame.getData()).getReturnAddress();
                }
                if (addr == null) {
                    this.exit(new Exception("Unknown stack frame return address"));
                    return;
                }
                if (this.step_back) {
                    BigInteger n2 = new BigInteger(addr.toString());
                    addr = n2.subtract(BigInteger.valueOf(1L));
                }
                String id = "Step." + this.ctx.getID();
                this.bp = new HashMap<String, Object>();
                this.bp.put("ID", id);
                this.bp.put("Location", addr.toString());
                this.bp.put("Condition", "$thread==\"" + this.ctx.getID() + "\"");
                this.bp.put("Enabled", Boolean.TRUE);
                this.bps.add(this.bp, new IBreakpoints.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            TCFActionStepOut.this.exit(error);
                        }
                    }
                });
            }
            this.ctx.resume(this.step_back ? 6 : 0, 1, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TCFActionStepOut.this.exit(error);
                    }
                }
            });
            ++this.step_cnt;
            return;
        }
        this.exit(new Exception("Step out is not supported"));
    }

    protected void exit(Throwable error) {
        this.exit(error, "Step Out");
    }

    protected void exit(Throwable error, String reason) {
        if (this.exited) {
            return;
        }
        if (this.bp != null) {
            this.bps.remove(new String[]{(String)this.bp.get("ID")}, new IBreakpoints.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                }
            });
        }
        this.rc.removeListener((IRunControl.RunControlListener)this);
        this.exited = true;
        if (error == null) {
            this.setActionResult(this.getContextID(), reason);
        } else {
            this.launch.removeContextActions(this.getContextID());
        }
        this.done();
    }

    public void containerResumed(String[] context_ids) {
    }

    public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        String[] stringArray = suspended_ids;
        int n = suspended_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!id.equals(context)) {
                this.contextSuspended(id, null, null, null);
            }
            ++n2;
        }
        this.contextSuspended(context, pc, reason, params);
    }

    public void contextAdded(IRunControl.RunControlContext[] contexts) {
    }

    public void contextChanged(IRunControl.RunControlContext[] contexts) {
        IRunControl.RunControlContext[] runControlContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IRunControl.RunControlContext c = runControlContextArray[n2];
            if (c.getID().equals(this.ctx.getID())) {
                this.ctx = c;
            }
            ++n2;
        }
    }

    public void contextException(String context, String msg) {
        if (context.equals(this.ctx.getID())) {
            this.exit(new Exception(msg));
        }
    }

    public void contextRemoved(String[] context_ids) {
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String context = stringArray[n2];
            if (context.equals(this.ctx.getID())) {
                this.exit(null);
            }
            ++n2;
        }
    }

    public void contextResumed(String context) {
    }

    public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
        if (!context.equals(this.ctx.getID())) {
            return;
        }
        Protocol.invokeLater((Runnable)this);
    }

    private boolean isMyBreakpoint(TCFContextState state_data) {
        Collection c;
        Object ids;
        if (this.bp == null) {
            return false;
        }
        if (!"Breakpoint".equals(state_data.suspend_reason)) {
            return false;
        }
        if (state_data.suspend_params != null && (ids = state_data.suspend_params.get("BPs")) != null && (c = (Collection)ids).contains(this.bp.get("ID"))) {
            return true;
        }
        if (state_data.suspend_pc == null) {
            return false;
        }
        BigInteger x = new BigInteger(state_data.suspend_pc);
        BigInteger y = new BigInteger((String)this.bp.get("Location"));
        return x.equals(y);
    }
}

