/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.launch;

import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.tm.internal.tcf.debug.launch.TCFLaunchDelegate;
import org.eclipse.tm.tcf.services.ILineNumbers;

public class TCFSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    private final LinkedHashMap<String, Object[]> cache = new LinkedHashMap<String, Object[]>(511, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1023;
        }
    };

    public void sourceContainersChanged(ISourceLookupDirector director) {
        this.cache.clear();
    }

    public String getSourceName(Object object) throws CoreException {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ILineNumbers.CodeArea) {
            ILineNumbers.CodeArea area = (ILineNumbers.CodeArea)object;
            return TCFSourceLookupParticipant.toFileName(area);
        }
        return null;
    }

    public static String toFileName(ILineNumbers.CodeArea area) {
        if (area.directory != null && area.file != null && !TCFSourceLookupParticipant.isAbsolutePath(area.file)) {
            return String.valueOf(area.directory) + "/" + area.file;
        }
        return area.file;
    }

    private static boolean isAbsolutePath(String fnm) {
        if (fnm.length() == 0) {
            return false;
        }
        char ch = fnm.charAt(0);
        if (ch == '/' || ch == '\\') {
            return true;
        }
        return fnm.length() >= 3 && fnm.charAt(1) == ':' && ((ch = fnm.charAt(2)) == '/' || ch == '\\');
    }

    private String applyPathMap(String fnm) {
        ILaunchConfiguration cfg = this.getDirector().getLaunchConfiguration();
        if (cfg == null) {
            return fnm;
        }
        try {
            String path_map = cfg.getAttribute("org.eclipse.tm.tcf.debug.PathMap", "");
            if (path_map.length() == 0) {
                return fnm;
            }
            ArrayList<TCFLaunchDelegate.PathMapRule> map = TCFLaunchDelegate.parsePathMapAttribute(path_map);
            for (TCFLaunchDelegate.PathMapRule r : map) {
                String dst;
                String host;
                String src = r.getSource();
                if (!fnm.startsWith(src) || (host = r.getHost()) != null && host.length() > 0 && !InetAddress.getLocalHost().equals(InetAddress.getByName(host)) || (dst = r.getDestination()) == null || dst.length() == 0) continue;
                int l = src.length();
                if (dst.endsWith("/") && l < fnm.length() && fnm.charAt(l) == '/') {
                    ++l;
                }
                return String.valueOf(dst) + fnm.substring(l);
            }
            if (fnm.startsWith("/cygdrive/")) {
                fnm = String.valueOf(fnm.substring(10, 11)) + ":" + fnm.substring(11);
            }
            return fnm;
        }
        catch (Exception exception) {
            return fnm;
        }
    }

    private Object[] findSource(String name) throws CoreException {
        Object[] res;
        File file = new File(name = this.applyPathMap(name));
        if (file.isAbsolute() && file.exists() && file.isFile()) {
            res = new Object[]{new LocalFileStorage(file)};
        } else {
            res = super.findSourceElements((Object)name);
            if (res == null || res.length == 0) {
                int j;
                String base = name;
                int i = name.lastIndexOf(47);
                if (i > (j = name.lastIndexOf(92))) {
                    base = name.substring(i + 1);
                }
                if (j > i) {
                    base = name.substring(j + 1);
                }
                res = super.findSourceElements((Object)base);
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] objectArray = res;
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                Object o;
                block11: {
                    IPath path;
                    o = objectArray[n2];
                    if (!(o instanceof IStorage) || o instanceof IFile || (path = ((IStorage)o).getFullPath()) == null) break block11;
                    URI uri = URIUtil.toURI((IPath)path);
                    IFile[] arr = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
                    if (arr == null || arr.length <= 0) break block11;
                    int cnt = list.size();
                    IFile[] iFileArray = arr;
                    int n3 = arr.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IFile fileResource = iFileArray[n4];
                        if (fileResource.isAccessible()) {
                            list.add(fileResource);
                        }
                        ++n4;
                    }
                    if (list.size() > cnt) break block12;
                }
                list.add(o);
            }
            ++n2;
        }
        return list.toArray(new Object[list.size()]);
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        String name = this.getSourceName(object);
        if (name == null) {
            return null;
        }
        if (this.cache.containsKey(name)) {
            return this.cache.get(name);
        }
        Object[] res = this.findSource(name);
        this.cache.put(name, res);
        return res;
    }
}

