/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.tm.internal.tcf.debug.model.ITCFBreakpointListener;
import org.eclipse.tm.internal.tcf.debug.model.TCFBreakpointsModel;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IBreakpoints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFBreakpointsStatus {
    private final IBreakpoints service;
    private final Map<String, Map<String, Object>> status = new HashMap<String, Map<String, Object>>();
    private final Set<ITCFBreakpointListener> listeners = new HashSet<ITCFBreakpointListener>();
    private static final Map<String, Object> status_not_supported = new HashMap<String, Object>();

    static {
        status_not_supported.put("Error", "Not supported");
    }

    TCFBreakpointsStatus(TCFLaunch launch) {
        assert (Protocol.isDispatchThread());
        this.service = (IBreakpoints)launch.getChannel().getRemoteService(IBreakpoints.class);
        if (this.service != null) {
            final IBreakpoints.BreakpointsListener listener = new IBreakpoints.BreakpointsListener(){

                public void breakpointStatusChanged(String id, Map<String, Object> m) {
                    if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                        throw new AssertionError();
                    }
                    if (TCFBreakpointsStatus.this.status.get(id) == null) {
                        return;
                    }
                    TCFBreakpointsStatus.this.status.put(id, m);
                    Iterator i = TCFBreakpointsStatus.this.listeners.iterator();
                    while (i.hasNext()) {
                        ((ITCFBreakpointListener)i.next()).breakpointStatusChanged(id);
                    }
                }

                public void contextAdded(Map<String, Object>[] bps) {
                    Map<String, Object>[] mapArray = bps;
                    int n = bps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Map<String, Object> bp = mapArray[n2];
                        String id = (String)bp.get("ID");
                        if (TCFBreakpointsStatus.this.status.get(id) == null) {
                            TCFBreakpointsStatus.this.status.put(id, new HashMap());
                            Iterator i = TCFBreakpointsStatus.this.listeners.iterator();
                            while (i.hasNext()) {
                                ((ITCFBreakpointListener)i.next()).breakpointStatusChanged(id);
                            }
                        }
                        ++n2;
                    }
                }

                public void contextChanged(Map<String, Object>[] bps) {
                    Map<String, Object>[] mapArray = bps;
                    int n = bps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Map<String, Object> bp = mapArray[n2];
                        String id = (String)bp.get("ID");
                        if (TCFBreakpointsStatus.this.status.containsKey(id)) {
                            Iterator i = TCFBreakpointsStatus.this.listeners.iterator();
                            while (i.hasNext()) {
                                ((ITCFBreakpointListener)i.next()).breakpointChanged(id);
                            }
                        }
                        ++n2;
                    }
                }

                public void contextRemoved(String[] ids) {
                    String[] stringArray = ids;
                    int n = ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        if (TCFBreakpointsStatus.this.status.containsKey(id)) {
                            Iterator i = TCFBreakpointsStatus.this.listeners.iterator();
                            while (i.hasNext()) {
                                ((ITCFBreakpointListener)i.next()).breakpointRemoved(id);
                            }
                            TCFBreakpointsStatus.this.status.remove(id);
                        }
                        ++n2;
                    }
                }
            };
            this.service.addListener(listener);
            this.service.getIDs(new IBreakpoints.DoneGetIDs(){

                public void doneGetIDs(IToken token, Exception error, String[] ids) {
                    if (error != null) {
                        return;
                    }
                    String[] stringArray = ids;
                    int n = ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final String id = stringArray[n2];
                        HashMap<String, String> bpProps = new HashMap<String, String>();
                        bpProps.put("ID", id);
                        listener.contextAdded(new Map[]{bpProps});
                        TCFBreakpointsStatus.this.service.getStatus(id, new IBreakpoints.DoneGetStatus(){

                            public void doneGetStatus(IToken token, Exception error, Map<String, Object> status) {
                                if (error == null) {
                                    listener.breakpointStatusChanged(id, status);
                                }
                            }
                        });
                        ++n2;
                    }
                }
            });
        }
    }

    public Set<String> getStatusIDs() {
        return this.status.keySet();
    }

    public Map<String, Object> getStatus(String id) {
        assert (id != null);
        assert (Protocol.isDispatchThread());
        if (this.service == null) {
            return status_not_supported;
        }
        return this.status.get(id);
    }

    public Map<String, Object> getStatus(IBreakpoint bp) {
        try {
            String id = TCFBreakpointsModel.getBreakpointsModel().getBreakpointID(bp);
            if (id == null) {
                return status_not_supported;
            }
            return this.getStatus(id);
        }
        catch (CoreException coreException) {
            return status_not_supported;
        }
    }

    public void addListener(ITCFBreakpointListener listener) {
        assert (Protocol.isDispatchThread());
        this.listeners.add(listener);
    }

    public void removeListener(ITCFBreakpointListener listener) {
        assert (Protocol.isDispatchThread());
        this.listeners.remove(listener);
    }
}

