/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.tests;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.tm.internal.tcf.debug.tests.ITCFTest;
import org.eclipse.tm.internal.tcf.debug.tests.TCFTestSuite;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IPathMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestPathMap
implements ITCFTest {
    private final TCFTestSuite test_suite;
    private final List<IPathMap.PathMapRule> map;
    private final IPathMap service;
    private final Random rnd = new Random();
    private static final String[] prop_names = new String[]{"Source", "Destination", "Host", "Protocol"};
    private int cnt = 0;

    TestPathMap(TCFTestSuite test_suite, IChannel channel, List<IPathMap.PathMapRule> map) {
        this.test_suite = test_suite;
        this.map = map;
        this.service = (IPathMap)channel.getRemoteService(IPathMap.class);
    }

    @Override
    public void start() {
        if (this.service == null) {
            this.exit(null);
        } else {
            this.test_map();
        }
    }

    private void test_map() {
        if (this.cnt >= 40) {
            if (this.map == null) {
                this.exit(null);
            } else {
                this.service.set(this.map.toArray(new IPathMap.PathMapRule[this.map.size()]), new IPathMap.DoneSet(){

                    public void doneSet(IToken token, Exception error) {
                        TestPathMap.this.exit(error);
                    }
                });
            }
        } else {
            ++this.cnt;
            final IPathMap.PathMapRule[] map_out = new IPathMap.PathMapRule[this.rnd.nextInt(12)];
            int i = 0;
            while (i < map_out.length) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("ID", "PM" + i);
                int l = 0;
                while (l < 2) {
                    String nm = prop_names[this.rnd.nextInt(prop_names.length)];
                    StringBuffer bf = new StringBuffer();
                    int n = this.rnd.nextInt(1024);
                    int j = 0;
                    while (j < n) {
                        char ch = (char)(this.rnd.nextInt(65520) + 1);
                        bf.append(ch);
                        ++j;
                    }
                    String val = bf.toString();
                    props.put(nm, val);
                    ++l;
                }
                map_out[i] = new Rule(props);
                ++i;
            }
            this.service.set(map_out, new IPathMap.DoneSet(){

                public void doneSet(IToken token, Exception error) {
                    if (error != null) {
                        TestPathMap.this.exit(error);
                    } else {
                        TestPathMap.this.service.get(new IPathMap.DoneGet(){

                            public void doneGet(IToken token, Exception error, IPathMap.PathMapRule[] map_inp) {
                                if (error != null) {
                                    TestPathMap.this.exit(error);
                                } else if (map_inp == null) {
                                    TestPathMap.this.exit(new Exception("PathMap.get returned null"));
                                } else if (map_out.length != map_inp.length) {
                                    TestPathMap.this.exit(new Exception("PathMap.get error: wrong map size"));
                                } else {
                                    int i = 0;
                                    while (i < map_out.length) {
                                        if (!TestPathMap.this.map_equ(map_out[i].getProperties(), map_inp[i].getProperties())) {
                                            return;
                                        }
                                        ++i;
                                    }
                                    TestPathMap.this.test_map();
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private boolean map_equ(Map<String, Object> x, Map<String, Object> y) {
        for (String key : x.keySet()) {
            if (this.obj_equ(key, x.get(key), y.get(key))) continue;
            return false;
        }
        for (String key : y.keySet()) {
            if (this.obj_equ(key, x.get(key), y.get(key))) continue;
            return false;
        }
        return true;
    }

    private boolean obj_equ(String nm, Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x != null && x.equals(y)) {
            return true;
        }
        this.exit(new Exception("PathMap.get: wrong map data, " + nm + ": " + x + " != " + y));
        return false;
    }

    private void exit(Throwable x) {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        this.test_suite.done(this, x);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Rule
    implements IPathMap.PathMapRule {
        final Map<String, Object> props;

        public Rule(Map<String, Object> props) {
            this.props = props;
        }

        public Map<String, Object> getProperties() {
            return this.props;
        }

        public String getID() {
            return (String)this.props.get("ID");
        }

        public String getSource() {
            return (String)this.props.get("Source");
        }

        public String getDestination() {
            return (String)this.props.get("Destination");
        }

        public String getHost() {
            return (String)this.props.get("Host");
        }

        public String getProtocol() {
            return (String)this.props.get("Protocol");
        }

        public String toString() {
            return this.props.toString();
        }
    }
}

