/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.tests;

import java.util.Collection;
import java.util.Map;
import java.util.Random;
import org.eclipse.tm.internal.tcf.debug.tests.ITCFTest;
import org.eclipse.tm.internal.tcf.debug.tests.TCFTestSuite;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IProcesses;
import org.eclipse.tm.tcf.services.ITerminals;

class TestTerminals
implements ITCFTest {
    private final TCFTestSuite test_suite;
    private final ITerminals terminals;
    private final IProcesses processes;
    private final Random rnd = new Random();
    private ITerminals.TerminalContext terminal;
    private ITerminals.TerminalContext get_ctx;
    private Map<String, String> environment;
    private Collection<Map<String, Object>> signal_list;
    private boolean signal_sent;
    private final ITerminals.TerminalsListener listener = new ITerminals.TerminalsListener(){

        public void exited(String id, int exit_code) {
            if (TestTerminals.this.terminal != null && id.equals(TestTerminals.this.terminal.getID()) && !TestTerminals.this.signal_sent) {
                TestTerminals.this.exit(new Exception("Terminal exited with code " + exit_code));
            }
        }

        public void winSizeChanged(String id, int w, int h) {
        }
    };

    TestTerminals(TCFTestSuite test_suite, IChannel channel) {
        this.test_suite = test_suite;
        this.terminals = (ITerminals)channel.getRemoteService(ITerminals.class);
        this.processes = (IProcesses)channel.getRemoteService(IProcesses.class);
    }

    public void start() {
        if (this.terminals == null) {
            this.test_suite.done(this, null);
        } else {
            this.terminals.addListener(this.listener);
            this.run();
        }
    }

    private void run() {
        if (this.environment == null && this.processes != null) {
            this.processes.getEnvironment(new IProcesses.DoneGetEnvironment(){

                public void doneGetEnvironment(IToken token, Exception error, Map<String, String> environment) {
                    if (error != null) {
                        TestTerminals.this.exit(error);
                    } else if (environment == null) {
                        TestTerminals.this.exit(new Exception("Default process environment must not be null"));
                    } else {
                        TestTerminals.this.environment = environment;
                        TestTerminals.this.run();
                    }
                }
            });
            return;
        }
        if (this.terminal == null) {
            String[] stringArray = new String[3];
            stringArray[0] = "ansi";
            stringArray[1] = "vt100";
            String[] types = stringArray;
            String[] stringArray2 = new String[3];
            stringArray2[0] = "en_US";
            stringArray2[1] = "en_US.UTF-8";
            String[] langs = stringArray2;
            String[] env = null;
            if (this.environment != null && this.rnd.nextBoolean()) {
                int i = 0;
                env = new String[this.environment.size() + 1];
                for (String s : this.environment.keySet()) {
                    env[i++] = String.valueOf(s) + "=" + this.environment.get(s);
                }
                env[i++] = "TCF_FOO=BAR";
            }
            this.terminals.launch(types[this.rnd.nextInt(types.length)], langs[this.rnd.nextInt(langs.length)], env, new ITerminals.DoneLaunch(){

                public void doneLaunch(IToken token, Exception error, ITerminals.TerminalContext terminal) {
                    if (error != null) {
                        TestTerminals.this.exit(error);
                    } else if (terminal == null) {
                        TestTerminals.this.exit(new Exception("Terminal context must not be null"));
                    } else if (terminal.getID() == null) {
                        TestTerminals.this.exit(new Exception("Terminal context ID must not be null"));
                    } else {
                        TestTerminals.this.terminal = terminal;
                        TestTerminals.this.run();
                    }
                }
            });
            return;
        }
        if (this.get_ctx == null) {
            this.terminals.getContext(this.terminal.getID(), new ITerminals.DoneGetContext(){

                public void doneGetContext(IToken token, Exception error, ITerminals.TerminalContext terminal) {
                    if (error != null) {
                        TestTerminals.this.exit(error);
                    } else if (terminal == null) {
                        TestTerminals.this.exit(new Exception("Terminal context must not be null"));
                    } else if (terminal.getID() == null) {
                        TestTerminals.this.exit(new Exception("Terminal context ID must not be null"));
                    } else if (!TestTerminals.this.terminal.getProperties().equals(terminal.getProperties())) {
                        TestTerminals.this.exit(new Exception("Invalid result of Terminal.getContext"));
                    } else {
                        TestTerminals.this.get_ctx = terminal;
                        TestTerminals.this.run();
                    }
                }
            });
            return;
        }
        if (this.signal_list == null && this.processes != null && this.terminal.getProcessID() != null) {
            this.processes.getSignalList(this.terminal.getProcessID(), new IProcesses.DoneGetSignalList(){

                public void doneGetSignalList(IToken token, Exception error, Collection<Map<String, Object>> list) {
                    if (error != null) {
                        TestTerminals.this.exit(error);
                    } else if (list == null) {
                        TestTerminals.this.exit(new Exception("Signal list must not be null"));
                    } else {
                        TestTerminals.this.signal_list = list;
                        TestTerminals.this.run();
                    }
                }
            });
        }
        if (!this.signal_sent) {
            if (this.signal_list != null && this.rnd.nextBoolean()) {
                int code = 15;
                for (Map<String, Object> m : this.signal_list) {
                    Number n;
                    String nm = (String)m.get("Name");
                    if (nm == null || !nm.equals("SIGTERM") || (n = (Number)m.get("Code")) == null) continue;
                    code = n.intValue();
                }
                this.processes.signal(this.terminal.getProcessID(), (long)code, new IProcesses.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            TestTerminals.this.exit(error);
                        } else {
                            TestTerminals.this.signal_sent = true;
                            TestTerminals.this.run();
                        }
                    }
                });
            } else {
                this.terminals.exit(this.terminal.getID(), new ITerminals.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            TestTerminals.this.exit(error);
                        } else {
                            TestTerminals.this.signal_sent = true;
                            TestTerminals.this.run();
                        }
                    }
                });
            }
            return;
        }
        this.exit(null);
    }

    private void exit(Throwable x) {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        if (this.terminals != null) {
            this.terminals.removeListener(this.listener);
        }
        this.test_suite.done(this, x);
    }
}

