/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.rse.shells;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.terminals.AbstractTerminalShell;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.tm.internal.tcf.rse.ITCFSessionProvider;
import org.eclipse.tm.internal.tcf.rse.Messages;
import org.eclipse.tm.internal.tcf.rse.TCFConnectorService;
import org.eclipse.tm.internal.tcf.rse.TCFRSETask;
import org.eclipse.tm.internal.tcf.rse.shells.TCFTerminalInputStream;
import org.eclipse.tm.internal.tcf.rse.shells.TCFTerminalOutputStream;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IStreams;
import org.eclipse.tm.tcf.services.ITerminals;

public class TCFTerminalShell
extends AbstractTerminalShell {
    private ITCFSessionProvider fSessionProvider;
    private IChannel fChannel;
    private String fPtyType;
    private ITerminals.TerminalContext terminalContext;
    private String fEncoding;
    private InputStream fInputStream;
    private OutputStream fOutputStream;
    private Writer fOutputStreamWriter;
    private int fWidth = 0;
    private int fHeight = 0;
    private String fContextID;
    private String in_id;
    private String out_id;
    private boolean connected = false;
    private ITerminals terminal;
    private int status;
    private IPropertySet tcfPropertySet = null;
    private static String defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
    private ITerminals.TerminalsListener listeners = new ITerminals.TerminalsListener(){

        public void exited(String terminalId, int exitCode) {
            if (!TCFTerminalShell.this.terminalContext.getID().equals(terminalId)) {
                return;
            }
            TCFTerminalShell.this.terminal.removeListener(TCFTerminalShell.this.listeners);
            TCFTerminalShell.this.connected = false;
        }

        public void winSizeChanged(String terminalId, int newWidth, int newHeight) {
        }
    };

    public void write(String value) {
        try {
            this.fOutputStream.write(value.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int login(String username, String password) throws InterruptedException {
        long millisToEnd = System.currentTimeMillis() + 10000L;
        LoginThread checkLogin = new LoginThread(username, password);
        this.status = 100;
        checkLogin.start();
        while (checkLogin.isAlive() && System.currentTimeMillis() < millisToEnd) {
            checkLogin.join(500L);
        }
        this.status = checkLogin.getLoginStatus();
        checkLogin.join();
        return this.status;
    }

    public TCFTerminalShell(final ITCFSessionProvider sessionProvider, final String ptyType, final String encoding, final String[] environment, String initialWorkingDirectory, String commandToRun) throws SystemMessageException {
        Exception nestedException = null;
        try {
            try {
                this.fSessionProvider = sessionProvider;
                this.fEncoding = encoding;
                this.fPtyType = ptyType;
                this.fChannel = this.fSessionProvider.getChannel();
                if (this.fChannel == null || this.fChannel.getState() != 1) {
                    throw new Exception("TCP channel is not connected!");
                }
                if (!((TCFConnectorService)sessionProvider).isSubscribed()) {
                    ((TCFConnectorService)sessionProvider).subscribe();
                }
                assert (((TCFConnectorService)sessionProvider).isSubscribed());
                new TCFRSETask<ITerminals.TerminalContext>(){

                    public void run() {
                        TCFTerminalShell.this.terminal = ((TCFConnectorService)sessionProvider).getService(ITerminals.class);
                        TCFTerminalShell.this.terminal.addListener(TCFTerminalShell.this.listeners);
                        TCFTerminalShell.this.terminal.launch(ptyType, encoding, environment, new ITerminals.DoneLaunch(){

                            public void doneLaunch(IToken token, Exception error, ITerminals.TerminalContext terminal) {
                                TCFTerminalShell.this.terminalContext = terminal;
                                if (error != null) {
                                    this.error(error);
                                } else {
                                    this.done(terminal);
                                }
                            }
                        });
                    }
                }.getS(null, Messages.TCFShellService_Name);
                this.fPtyType = this.terminalContext.getPtyType();
                this.fEncoding = this.terminalContext.getEncoding();
                this.fContextID = this.terminalContext.getID();
                this.fWidth = this.terminalContext.getWidth();
                this.fHeight = this.terminalContext.getHeight();
                Map map_ids = this.terminalContext.getProperties();
                this.in_id = (String)map_ids.get("StdOutID");
                this.out_id = (String)map_ids.get("StdInID");
                String user = this.fSessionProvider.getSessionUserId();
                String password = this.fSessionProvider.getSessionPassword();
                this.status = 100;
                IStreams streams = ((TCFConnectorService)sessionProvider).getService(IStreams.class);
                this.fOutputStream = new TCFTerminalOutputStream(streams, this.out_id);
                this.fInputStream = new TCFTerminalInputStream(streams, this.in_id);
                this.fOutputStreamWriter = this.fEncoding != null ? new BufferedWriter(new OutputStreamWriter(this.fOutputStream, encoding)) : new BufferedWriter(new OutputStreamWriter(this.fOutputStream));
                this.status = this.login(user, password);
                if (this.status == 200) {
                    ((TCFConnectorService)sessionProvider).unsubscribe();
                    ((TCFConnectorService)sessionProvider).subscribe();
                    assert (((TCFConnectorService)sessionProvider).isSubscribed());
                    this.status = this.login(user, password);
                }
                this.connected = true;
                if (initialWorkingDirectory != null && initialWorkingDirectory.length() > 0 && !initialWorkingDirectory.equals(".") && !initialWorkingDirectory.equals("Command Shell")) {
                    this.writeToShell("cd " + PathUtility.enQuoteUnix((String)initialWorkingDirectory));
                }
                if (commandToRun != null && commandToRun.length() > 0) {
                    this.writeToShell(commandToRun);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                nestedException = e;
                if (this.status != 150) {
                    SimpleSystemMessage msg;
                    if (nestedException != null) {
                        msg = new SimpleSystemMessage("org.eclipse.tm.tcf.rse", "RSEG1003", 4, CommonMessages.MSG_EXCEPTION_OCCURRED, (Throwable)nestedException);
                    } else {
                        String strErr = this.status == 200 ? "Connection closed!" : (this.status == 100 ? "Login Incorrect or meet other unknown error!" : "Not identified Errors");
                        msg = new SimpleSystemMessage("org.eclipse.tm.tcf.rse", "RSEC1002", 4, strErr, "Meet error when trying to login in!");
                        msg.makeSubstitution((Object)((TCFConnectorService)this.fSessionProvider).getHost().getAliasName());
                    }
                    throw new SystemMessageException((SystemMessage)msg);
                }
            }
        }
        finally {
            if (this.status != 150) {
                SimpleSystemMessage msg;
                if (nestedException != null) {
                    msg = new SimpleSystemMessage("org.eclipse.tm.tcf.rse", "RSEG1003", 4, CommonMessages.MSG_EXCEPTION_OCCURRED, (Throwable)nestedException);
                } else {
                    String strErr = this.status == 200 ? "Connection closed!" : (this.status == 100 ? "Login Incorrect or meet other unknown error!" : "Not identified Errors");
                    msg = new SimpleSystemMessage("org.eclipse.tm.tcf.rse", "RSEC1002", 4, strErr, "Meet error when trying to login in!");
                    msg.makeSubstitution((Object)((TCFConnectorService)this.fSessionProvider).getHost().getAliasName());
                }
                throw new SystemMessageException((SystemMessage)msg);
            }
        }
    }

    public void writeToShell(String command) throws IOException {
        if (this.isActive()) {
            command = "#break".equals(command) ? "\u0003" : String.valueOf(command) + "\r\n";
            this.fOutputStreamWriter.write(command);
        }
    }

    public void exit() {
        if (this.fChannel == null || this.fChannel.getState() == 2 || !this.connected) {
            return;
        }
        try {
            this.getOutputStream().close();
            this.getInputStream().close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            new TCFRSETask<Object>(){

                public void run() {
                    TCFTerminalShell.this.terminalContext.exit(new ITerminals.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error != null) {
                                this.error(error);
                            } else {
                                this.done(this);
                            }
                        }
                    });
                }
            }.getS(null, Messages.TCFShellService_Name);
        }
        catch (SystemMessageException e) {
            e.printStackTrace();
        }
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    public boolean isActive() {
        if (this.fChannel != null && this.fChannel.getState() != 2 && this.connected) {
            return true;
        }
        this.exit();
        return false;
    }

    public String getPtyType() {
        return this.fPtyType;
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fChannel == null || this.fChannel.getState() == 2 || !this.connected) {
            return;
        }
        this.fWidth = newWidth;
        this.fHeight = newHeight;
        try {
            new TCFRSETask<Object>(){

                public void run() {
                    if (TCFTerminalShell.this.fChannel != null && TCFTerminalShell.this.connected) {
                        TCFTerminalShell.this.terminal.setWinSize(TCFTerminalShell.this.fContextID, TCFTerminalShell.this.fWidth, TCFTerminalShell.this.fHeight, new ITerminals.DoneCommand(){

                            public void doneCommand(IToken token, Exception error) {
                                if (error != null) {
                                    this.error(error);
                                } else {
                                    this.done(this);
                                }
                            }
                        });
                    }
                }
            }.getS(null, Messages.TCFShellService_Name);
        }
        catch (SystemMessageException e) {
            e.printStackTrace();
        }
    }

    public String getDefaultEncoding() {
        if (this.fEncoding != null) {
            return this.fEncoding;
        }
        return defaultEncoding;
    }

    private class LoginThread
    extends Thread {
        private String username;
        private String password;
        private int status = 150;

        public LoginThread(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public void run() {
            TCFTerminalShell.this.tcfPropertySet = ((TCFConnectorService)TCFTerminalShell.this.fSessionProvider).getTCFPropertySet();
            String login_required = TCFTerminalShell.this.tcfPropertySet.getPropertyValue("Login.Required");
            String login_prompt = TCFTerminalShell.this.tcfPropertySet.getPropertyValue("Login.Prompt");
            String password_prompt = TCFTerminalShell.this.tcfPropertySet.getPropertyValue("Password.Prompt");
            String command_prompt = TCFTerminalShell.this.tcfPropertySet.getPropertyValue("Command.Prompt");
            String pwd_required = TCFTerminalShell.this.tcfPropertySet.getPropertyValue("Pwd.Required");
            login_required = String.valueOf(false);
            if (Boolean.valueOf(login_required).booleanValue()) {
                this.status = 150;
                if (login_prompt != null && login_prompt.length() > 0) {
                    this.status = this.readUntil(login_prompt, TCFTerminalShell.this.fInputStream);
                    TCFTerminalShell.this.write(String.valueOf(this.username) + "\n");
                }
                if (Boolean.valueOf(pwd_required).booleanValue() && this.status == 150 && password_prompt != null && password_prompt.length() > 0) {
                    this.status = this.readUntil(password_prompt, TCFTerminalShell.this.fInputStream);
                    TCFTerminalShell.this.write(String.valueOf(this.password) + "\n");
                }
                if (this.status == 150 && command_prompt != null && command_prompt.length() > 0) {
                    this.status = this.readUntil(command_prompt, TCFTerminalShell.this.fInputStream);
                    TCFTerminalShell.this.write("\n");
                }
            } else if (command_prompt != null && command_prompt.length() > 0) {
                this.status = this.readUntil(command_prompt, TCFTerminalShell.this.fInputStream);
                TCFTerminalShell.this.write("\n");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int readUntil(String pattern, InputStream in) {
            try {
                char lastChar = pattern.charAt(pattern.length() - 1);
                StringBuffer sb = new StringBuffer();
                int ch = in.read();
                while (true) {
                    if (ch < 0) {
                        return 200;
                    }
                    char tch = (char)ch;
                    sb.append(tch);
                    if (tch == 't' && sb.indexOf("incorrect") >= 0) {
                        return 100;
                    }
                    if (tch == 'd' && sb.indexOf("closed") >= 0) {
                        return 200;
                    }
                    if (tch == lastChar && sb.toString().endsWith(pattern)) {
                        return 150;
                    }
                    ch = in.read();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                SystemBasePlugin.logError((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()), (Throwable)e);
            }
            return 200;
        }

        public int getLoginStatus() {
            return this.status;
        }
    }
}

