/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.generic;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidator;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidators;
import org.eclipse.wb.internal.core.model.generic.FlowContainer;
import org.eclipse.wb.internal.core.model.util.predicate.ExpressionPredicate;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.association.Associations;
import org.eclipse.wb.internal.core.xml.model.generic.FlowContainerConfigurable;
import org.eclipse.wb.internal.core.xml.model.generic.FlowContainerConfiguration;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlowContainerFactory {
    private final XmlObjectInfo m_object;
    private final boolean m_forCanvas;

    public FlowContainerFactory(XmlObjectInfo object, boolean forCanvas) {
        this.m_object = object;
        this.m_forCanvas = forCanvas;
    }

    public List<FlowContainer> get() {
        List containers = Lists.newArrayList();
        this.addConfigurableContainers(containers);
        return containers;
    }

    private void addConfigurableContainers(List<FlowContainer> containers) {
        List<FlowContainerConfiguration> configurations = this.getConfigurations();
        for (FlowContainerConfiguration configuration : configurations) {
            FlowContainerConfigurable container = new FlowContainerConfigurable(this.m_object, configuration);
            containers.add(container);
        }
    }

    public List<FlowContainerConfiguration> getConfigurations() {
        return (List)ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<List<FlowContainerConfiguration>>(){

            public List<FlowContainerConfiguration> runObject() throws Exception {
                return FlowContainerFactory.this.getConfigurationsEx();
            }
        }, (String)"Exception during reading flow container configurations for %s", (Object[])new Object[]{this.m_object});
    }

    private List<FlowContainerConfiguration> getConfigurationsEx() {
        List configurations = Lists.newArrayList();
        for (String prefix : this.getConfigurationPrefixes()) {
            FlowContainerConfiguration configuration = this.createConfiguration(prefix);
            configurations.add(configuration);
        }
        return configurations;
    }

    private List<String> getConfigurationPrefixes() {
        List prefixes = Lists.newArrayList();
        this.addConfigurationPrefixes(prefixes, "flowContainer");
        if (this.m_forCanvas) {
            this.addConfigurationPrefixes(prefixes, "flowContainer.canvas");
        } else {
            this.addConfigurationPrefixes(prefixes, "flowContainer.tree");
        }
        return prefixes;
    }

    private void addConfigurationPrefixes(List<String> prefixes, String basePrefix) {
        int i = 0;
        while (i < 10) {
            String prefix = String.valueOf(basePrefix) + (i == 0 ? "" : "." + i);
            if ("true".equals(this.getParameter(prefix))) {
                prefixes.add(prefix);
            }
            ++i;
        }
    }

    private FlowContainerConfiguration createConfiguration(String prefix) {
        return new FlowContainerConfiguration(this.getHorizontalPredicate(prefix, true), this.getRtlPredicate(prefix, true), this.getAssociation(prefix), this.getComponentValidator(prefix), this.getReferenceValidator(prefix));
    }

    private ContainerObjectValidator getComponentValidator(String prefix) {
        String validatorExpression = this.getParameter(String.valueOf(prefix) + ".component-validator");
        if (validatorExpression != null) {
            return ContainerObjectValidators.forComponentExpression((String)validatorExpression);
        }
        String componentString = this.getComponentString(prefix);
        Assert.isNotNull((Object)componentString, (String)"No 'component' validator.");
        String[] componentTypes = StringUtils.split((String)componentString);
        return ContainerObjectValidators.forList((String[])componentTypes);
    }

    private String getComponentString(String prefix) {
        String componentString = this.getParameter(String.valueOf(prefix) + ".component");
        if (componentString == null) {
            componentString = this.getParameter("flowContainer.defaultComponent");
        }
        return componentString;
    }

    private ContainerObjectValidator getReferenceValidator(String prefix) {
        String validatorExpression = this.getParameter(String.valueOf(prefix) + ".reference-validator");
        if (validatorExpression != null) {
            return ContainerObjectValidators.forReferenceExpression((String)validatorExpression);
        }
        String referenceString = this.getReferenceString(prefix);
        Assert.isNotNull((Object)referenceString, (String)"No 'reference' validator.");
        String[] referenceTypes = StringUtils.split((String)referenceString);
        return ContainerObjectValidators.forList((String[])referenceTypes);
    }

    private String getReferenceString(String prefix) {
        String referenceString = this.getParameter(String.valueOf(prefix) + ".reference");
        if (referenceString == null) {
            referenceString = this.getParameter(String.valueOf(prefix) + ".component");
        }
        if (referenceString == null) {
            referenceString = this.getParameter("flowContainer.defaultReference");
        }
        return referenceString;
    }

    private Predicate<Object> getHorizontalPredicate(String prefix, boolean def) {
        String horizontalString = this.getParameter(String.valueOf(prefix) + ".horizontal");
        if (horizontalString == null) {
            return Predicates.alwaysTrue();
        }
        return new ExpressionPredicate(horizontalString);
    }

    private Predicate<Object> getRtlPredicate(String prefix, boolean def) {
        String rtlString = this.getParameter(String.valueOf(prefix) + ".rtl");
        if (rtlString == null) {
            return Predicates.alwaysFalse();
        }
        return new ExpressionPredicate(rtlString);
    }

    private Association getAssociation(String prefix) {
        String associationString = this.getParameter(String.valueOf(prefix) + ".x-association");
        if (StringUtils.isEmpty((String)associationString)) {
            return Associations.direct();
        }
        if (associationString.startsWith("inter ")) {
            associationString = StringUtils.removeStart((String)associationString, (String)"inter ");
            String tag = StringUtils.substringBefore((String)associationString, (String)" ");
            associationString = StringUtils.substringAfter((String)associationString, (String)" ");
            Map<String, String> attributes = FlowContainerFactory.parseAttributes(associationString);
            return Associations.intermediate(tag, attributes);
        }
        Assert.isTrue((boolean)associationString.startsWith("property "));
        String property = StringUtils.removeStart((String)associationString, (String)"property ");
        return Associations.property(property);
    }

    private static Map<String, String> parseAttributes(String s) {
        Map attributes = Maps.newHashMap();
        while (s.length() != 0) {
            s = s.trim();
            int attrNameEnd = s.indexOf("='");
            int attrValueEnd = s.indexOf("'", attrNameEnd + 2);
            String attrName = s.substring(0, attrNameEnd);
            String attrValue = s.substring(attrNameEnd + 2, attrValueEnd);
            attributes.put(attrName, attrValue);
            s = s.substring(attrValueEnd + 1);
        }
        return attributes;
    }

    private String getParameter(String name) {
        return XmlObjectUtils.getParameter(this.m_object, name);
    }
}

