/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.Tool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TargetingTool
extends Tool {
    private EditPart m_target;
    private Request m_request;
    private boolean m_isLockTarget;
    private boolean m_isShowingFeedback;

    @Override
    public void deactivate() {
        this.eraseTargetFeedback();
        this.m_isLockTarget = false;
        this.m_target = null;
        this.m_request = null;
        super.deactivate();
    }

    protected EditPart getTargetEditPart() {
        return this.m_target;
    }

    protected void setTargetEditPart(EditPart target) {
        if (this.m_target != target) {
            this.getTargetRequest().setTarget(target);
            if (this.m_target != null) {
                this.handleExitingEditPart();
            }
            this.m_target = target;
            this.handleEnteredEditPart();
        }
    }

    protected void handleExitingEditPart() {
        this.eraseTargetFeedback();
    }

    protected void handleEnteredEditPart() {
        this.updateTargetRequest();
        this.showTargetFeedback();
    }

    protected void handleInvalidInput() {
        this.eraseTargetFeedback();
        this.setCommand(null);
    }

    @Override
    protected void handleViewerExited() {
        this.setTargetEditPart(null);
    }

    protected void lockTargetEditPart(EditPart editpart) {
        if (editpart == null) {
            this.unlockTargetEditPart();
        } else {
            this.m_isLockTarget = true;
            this.setTargetEditPart(editpart);
        }
    }

    protected void unlockTargetEditPart() {
        this.m_isLockTarget = false;
        this.updateTargetUnderMouse();
    }

    protected Collection<EditPart> getExclusionSet() {
        return Collections.emptyList();
    }

    protected IEditPartViewer.IConditional getTargetingConditional() {
        return new IEditPartViewer.IConditional(){

            public boolean evaluate(EditPart target) {
                TargetingTool.this.updateTargetRequest(target);
                return target.getTargetEditPart(TargetingTool.this.getTargetRequest()) != null;
            }
        };
    }

    protected void updateTargetUnderMouse() {
        if (!this.m_isLockTarget) {
            EditPart editPart = this.getViewer().findTargetEditPart(this.m_currentScreenX, this.m_currentScreenY, this.getExclusionSet(), this.getTargetingConditional());
            if (editPart != null) {
                editPart = editPart.getTargetEditPart(this.getTargetRequest());
            }
            this.setTargetEditPart(editPart);
        }
    }

    protected Request getTargetRequest() {
        if (this.m_request == null) {
            this.m_request = this.createTargetRequest();
        }
        return this.m_request;
    }

    protected Request createTargetRequest() {
        return new Request();
    }

    protected void updateTargetRequest() {
        this.getTargetRequest().setStateMask(this.m_stateMask);
    }

    protected void updateTargetRequest(EditPart target) {
    }

    @Override
    protected Command getCommand() {
        return this.m_target == null ? null : this.m_target.getCommand(this.getTargetRequest());
    }

    protected void showTargetFeedback() {
        if (this.m_target != null) {
            this.m_target.showTargetFeedback(this.getTargetRequest());
        }
        this.m_isShowingFeedback = true;
    }

    protected void eraseTargetFeedback() {
        if (this.m_isShowingFeedback) {
            this.m_isShowingFeedback = false;
            if (this.m_target != null) {
                Request targetRequest = this.getTargetRequest();
                targetRequest.setEraseFeedback(true);
                try {
                    this.m_target.eraseTargetFeedback(targetRequest);
                }
                finally {
                    targetRequest.setEraseFeedback(false);
                }
            }
        }
    }
}

