/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors.report2;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.errors.BrowserMessageDialog;
import org.eclipse.wb.internal.core.editor.errors.report2.Messages;
import org.eclipse.wb.internal.core.editor.errors.report2.ZipFileErrorReport;
import org.eclipse.wb.internal.core.utils.dialogfields.AbstractValidationTitleAreaDialog;
import org.eclipse.wb.internal.core.utils.dialogfields.BooleanDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogFieldUtils;
import org.eclipse.wb.internal.core.utils.dialogfields.IDialogFieldListener;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public final class CreateReportDialog
extends AbstractValidationTitleAreaDialog {
    private final ZipFileErrorReport m_errorReport;
    private Composite m_container;
    private BooleanDialogField m_screenshotsField;
    private Composite m_screenshotsComposite;
    private BooleanDialogField m_filesField;
    private Composite m_filesComposite;
    private BooleanDialogField m_projectField;
    private BooleanDialogField m_cuField;
    private ProgressMonitorPart m_progressMonitorPart;

    public CreateReportDialog(Shell parentShell, Image screenshot, ZipFileErrorReport errorReport) {
        super(parentShell, DesignerPlugin.getDefault(), Messages.CreateReportDialog_title, Messages.CreateReportDialog_message, DesignerPlugin.getImage("actions/errors/support_banner.png"), "");
        this.m_errorReport = errorReport;
    }

    protected void createControls(Composite container) {
        this.m_container = container;
        boolean addDefaultScreenshot = this.m_errorReport.hasDefaultScreenshot();
        GridLayoutFactory.create(container).columns(1);
        Group additionalDataGroup = new Group(container, 0);
        additionalDataGroup.setText(Messages.CreateReportDialog_additionalGroup);
        GridDataFactory.create((Control)additionalDataGroup).grabH().fillH();
        GridLayoutFactory.create((Composite)additionalDataGroup).columns(2);
        Composite groupComposite1 = new Composite((Composite)additionalDataGroup, 0);
        GridDataFactory.create((Control)groupComposite1).fillH().alignVT();
        GridLayoutFactory.create(groupComposite1).columns(3).marginsH(0);
        BooleanDialogField logInfoField = new BooleanDialogField(true);
        this.doCreateBooleanField(groupComposite1, logInfoField, Messages.CreateReportDialog_additionalLogs, 3);
        this.selectAndDisable(groupComposite1, logInfoField);
        this.m_screenshotsField = new BooleanDialogField(true);
        this.doCreateBooleanField(groupComposite1, this.m_screenshotsField, String.valueOf(Messages.CreateReportDialog_additionalScreenshots) + (addDefaultScreenshot ? ":" : ""), 2);
        GridDataFactory.modify((Control)this.m_screenshotsField.getLabelControl(groupComposite1)).grabH();
        if (addDefaultScreenshot) {
            this.m_screenshotsField.setSelection(true);
        }
        this.m_screenshotsField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                boolean fieldSelected = CreateReportDialog.this.m_screenshotsField.getSelection();
                GridDataFactory.modify((Control)CreateReportDialog.this.m_screenshotsComposite).exclude(!fieldSelected);
                if (fieldSelected) {
                    if (!CreateReportDialog.this.addScreenshot()) {
                        CreateReportDialog.this.m_screenshotsField.setSelection(false);
                    }
                } else {
                    CreateReportDialog.this.removeAllScreenshots();
                }
            }
        });
        Link link = new Link(groupComposite1, 0);
        link.setText(Messages.CreateReportDialog_addLink);
        GridDataFactory.create((Control)link).alignHL().hintHC(link.getText().length());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateReportDialog.this.addScreenshot()) {
                    CreateReportDialog.this.m_screenshotsField.setSelection(true);
                }
            }
        });
        this.m_screenshotsComposite = new Composite(groupComposite1, 0);
        GridDataFactory.create((Control)this.m_screenshotsComposite).spanH(3).exclude(!addDefaultScreenshot);
        GridLayoutFactory.create(this.m_screenshotsComposite).marginsH(10).marginsV(0).columns(2);
        if (addDefaultScreenshot) {
            this.selectAndDisable(this.m_screenshotsComposite, this.addDefaultScreenshotControl(this.m_screenshotsComposite));
        }
        this.m_cuField = new BooleanDialogField(true);
        this.doCreateBooleanField(groupComposite1, this.m_cuField, Messages.CreateReportDialog_additionalSourceFile, 3);
        this.m_cuField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                CreateReportDialog.this.m_errorReport.setIncludeSourceFile(CreateReportDialog.this.m_cuField.getSelection());
            }
        });
        if (!this.m_errorReport.hasSourceFile()) {
            this.m_cuField.setSelection(false);
            this.m_cuField.setEnabled(false);
        } else {
            this.m_cuField.setSelection(true);
        }
        this.m_projectField = new BooleanDialogField(true);
        this.doCreateBooleanField(groupComposite1, this.m_projectField, Messages.CreateReportDialog_additionalProject, 3);
        this.m_projectField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                boolean selected = CreateReportDialog.this.m_projectField.getSelection();
                if (selected) {
                    boolean dialogResult = MessageDialog.openConfirm((Shell)CreateReportDialog.this.getShell(), (String)Messages.CreateReportDialog_additionalProjectTitle, (String)Messages.CreateReportDialog_additionalProjectMessage);
                    if (dialogResult) {
                        CreateReportDialog.this.m_errorReport.setIncludeProject(selected);
                        CreateReportDialog.this.m_cuField.setSelection(true);
                        CreateReportDialog.this.m_errorReport.setIncludeSourceFile(true);
                    } else {
                        CreateReportDialog.this.m_errorReport.setIncludeProject(false);
                        CreateReportDialog.this.m_projectField.setSelection(false);
                    }
                }
            }
        });
        Composite groupComposite2 = new Composite((Composite)additionalDataGroup, 0);
        GridDataFactory.create((Control)groupComposite2).fillH().alignVT();
        GridLayoutFactory.create(groupComposite2).columns(3).marginsH(0);
        BooleanDialogField compInfoField = new BooleanDialogField(true);
        this.doCreateBooleanField(groupComposite2, compInfoField, Messages.CreateReportDialog_softHardSummary, 2);
        this.selectAndDisable(groupComposite2, compInfoField);
        link = new Link(groupComposite2, 0);
        link.setText(Messages.CreateReportDialog_viewLink);
        GridDataFactory.create((Control)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserMessageDialog.openMessage(CreateReportDialog.this.getShell(), Messages.CreateReportDialog_softHardSummaryTitle, CreateReportDialog.this.m_errorReport.getComputerInfo());
            }
        });
        BooleanDialogField preferencesInfoField = new BooleanDialogField(true);
        this.doCreateBooleanField(groupComposite2, preferencesInfoField, Messages.CreateReportDialog_preferences, 3);
        this.selectAndDisable(groupComposite2, preferencesInfoField);
        this.m_filesField = new BooleanDialogField(true);
        this.doCreateBooleanField(groupComposite2, this.m_filesField, Messages.CreateReportDialog_fileAttachments, 2);
        this.m_filesField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                boolean fieldSelected = CreateReportDialog.this.m_filesField.getSelection();
                GridDataFactory.modify((Control)CreateReportDialog.this.m_filesComposite).exclude(!fieldSelected);
                if (fieldSelected) {
                    if (!CreateReportDialog.this.addFile()) {
                        CreateReportDialog.this.m_filesField.setSelection(false);
                    }
                } else {
                    CreateReportDialog.this.removeAllFiles();
                }
            }
        });
        link = new Link(groupComposite2, 0);
        link.setText(Messages.CreateReportDialog_addLink);
        GridDataFactory.create((Control)link).alignHL();
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateReportDialog.this.addFile()) {
                    CreateReportDialog.this.m_filesField.setSelection(true);
                }
            }
        });
        this.m_filesComposite = new Composite(groupComposite2, 0);
        GridDataFactory.create((Control)this.m_filesComposite).spanH(3).exclude(true);
        GridLayoutFactory.create(this.m_filesComposite).marginsH(10).marginsV(0).columns(2);
        this.m_filesComposite.setVisible(false);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        this.m_progressMonitorPart = new ProgressMonitorPart(container, (Layout)layout);
        GridDataFactory.modify((Control)this.m_progressMonitorPart).alignHF();
    }

    private boolean addScreenshot() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.png", "*.jpg", "*.bmp", "*.tiff", "*.tga"});
        String fileName = fileDialog.open();
        if (fileName != null) {
            if (!this.m_errorReport.hasScreenshot(fileName)) {
                this.m_errorReport.includeScreenshot(fileName, true);
                this.m_screenshotsComposite.setVisible(true);
                GridDataFactory.modify((Control)this.m_screenshotsComposite).exclude(false);
                this.addScreenshotControl(fileName);
            }
            return true;
        }
        return false;
    }

    private void removeAllScreenshots() {
        this.removeAllControls(this.m_screenshotsComposite);
        this.m_errorReport.setupScreenshots();
        GridDataFactory.modify((Control)this.m_screenshotsComposite).exclude(true);
        this.m_screenshotsComposite.setVisible(false);
        this.m_container.layout(true, true);
    }

    private boolean addFile() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.*"});
        String fileName = fileDialog.open();
        if (fileName != null) {
            if (!this.m_errorReport.hasFile(fileName)) {
                this.m_errorReport.includeFile(fileName, true);
                this.m_filesComposite.setVisible(true);
                GridDataFactory.modify((Control)this.m_filesComposite).exclude(false);
                this.addFileControl(fileName);
            }
            return true;
        }
        return false;
    }

    private void removeAllFiles() {
        this.removeAllControls(this.m_filesComposite);
        this.m_errorReport.setupFiles();
        GridDataFactory.modify((Control)this.m_filesComposite).exclude(true);
        this.m_filesComposite.setVisible(false);
        this.m_container.layout(true, true);
    }

    private void selectAndDisable(Composite parent, BooleanDialogField booleanField) {
        booleanField.setSelection(true);
        booleanField.getButtonControl(parent).setEnabled(false);
    }

    private BooleanDialogField addScreenshotControl(final String filePath) {
        final BooleanDialogField dialogField = this.addControl(this.m_screenshotsComposite, filePath);
        dialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                CreateReportDialog.this.m_errorReport.includeScreenshot(filePath, dialogField.getSelection());
            }
        });
        return dialogField;
    }

    private BooleanDialogField addFileControl(final String filePath) {
        final BooleanDialogField dialogField = this.addControl(this.m_filesComposite, filePath);
        dialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                CreateReportDialog.this.m_errorReport.includeFile(filePath, dialogField.getSelection());
            }
        });
        return dialogField;
    }

    private BooleanDialogField addControl(Composite parent, String filePath) {
        BooleanDialogField selectableField = new BooleanDialogField(true);
        selectableField.setSelection(true);
        this.doCreateBooleanField(parent, selectableField, FilenameUtils.getName((String)filePath), 2);
        this.m_container.layout(true, true);
        return selectableField;
    }

    protected void removeAllControls(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    private BooleanDialogField addDefaultScreenshotControl(Composite parent) {
        BooleanDialogField screenShotField = new BooleanDialogField(true);
        this.doCreateBooleanField(parent, screenShotField, Messages.CreateReportDialog_beforeErrorScreenshot, 2);
        return screenShotField;
    }

    protected final void doCreateField(Composite fieldsContainer, DialogField dialogField, String labelText, int chars) {
        dialogField.setLabelText(labelText);
        dialogField.setDialogFieldListener(this.m_validateListener);
        DialogFieldUtils.fillControls(fieldsContainer, dialogField, 2, chars);
    }

    protected final void doCreateBooleanField(Composite fieldsContainer, DialogField dialogField, String labelText, int columns) {
        dialogField.setLabelText(labelText);
        dialogField.setDialogFieldListener(this.m_validateListener);
        dialogField.doFillIntoGrid(fieldsContainer, columns);
    }

    private void showSuccessMessage() {
        Button cancelButton = this.getButton(1);
        cancelButton.setText(IDialogConstants.CLOSE_LABEL);
        Composite containerParent = this.m_container.getParent();
        this.m_container.dispose();
        Composite successComposite = new Composite(containerParent, 0);
        GridDataFactory.create((Control)successComposite).grab().fill();
        GridLayoutFactory.create(successComposite);
        Label successLabel = new Label(successComposite, 0);
        successLabel.setText(Messages.CreateReportDialog_successLabel);
        GridDataFactory.create((Control)successLabel).grab().alignVB().alignHC();
        successLabel = new Label(successComposite, 0);
        successLabel.setText(Messages.CreateReportDialog_pressClosebutton);
        GridDataFactory.create((Control)successLabel).grab().alignVT().alignHC();
        containerParent.layout(true, true);
        String message = Messages.CreateReportDialog_successMessage;
        this.setMessage(message, 1);
        this.setTitle(Messages.CreateReportDialog_successTitle);
    }

    protected void okPressed() {
        Button cancelButton = this.getButton(1);
        Button okButton = this.getButton(0);
        this.m_progressMonitorPart.attachToCancelComponent((Control)cancelButton);
        okButton.setEnabled(false);
        try {
            try {
                this.m_errorReport.reportProblem((IProgressMonitor)this.m_progressMonitorPart);
            }
            catch (Throwable e) {
                okButton.setEnabled(true);
                this.showError(e);
                this.m_progressMonitorPart.done();
                this.m_progressMonitorPart.removeFromCancelComponent((Control)cancelButton);
                return;
            }
        }
        finally {
            this.m_progressMonitorPart.done();
            this.m_progressMonitorPart.removeFromCancelComponent((Control)cancelButton);
        }
        this.showSuccessMessage();
    }

    private void showError(final Throwable e) {
        Status status = new Status(4, DesignerPlugin.getDefault().toString(), 4, Messages.CreateReportDialog_errorUseDetails, e);
        ErrorDialog dialog = new ErrorDialog(DesignerPlugin.getShell(), Messages.CreateReportDialog_errorTitle, Messages.CreateReportDialog_errorMessage, (IStatus)status, 4){
            private Clipboard clipboard;

            protected List createDropDownList(Composite parent) {
                final List list = super.createDropDownList(parent);
                list.removeAll();
                PrintWriter printWriter = new PrintWriter(new Writer(){

                    public void write(char[] cbuf, int off, int len) throws IOException {
                        if (len != 2 && cbuf[0] != '\r' && cbuf[0] != '\n') {
                            list.add(StringUtils.replace((String)new String(cbuf, off, len), (String)"\t", (String)"    "));
                        }
                    }

                    public void flush() throws IOException {
                    }

                    public void close() throws IOException {
                    }
                });
                e.printStackTrace(printWriter);
                Menu menu = list.getMenu();
                menu.dispose();
                Menu copyMenu = new Menu((Control)list);
                MenuItem copyItem = new MenuItem(copyMenu, 0);
                copyItem.setText(Messages.CreateReportDialog_copyAction);
                copyItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        this.copyList(list);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.copyList(list);
                    }
                });
                list.setMenu(copyMenu);
                return list;
            }

            private void copyList(List list) {
                if (this.clipboard != null) {
                    this.clipboard.dispose();
                }
                StringBuffer statusBuffer = new StringBuffer();
                int i = 0;
                while (i < list.getItemCount()) {
                    statusBuffer.append(list.getItem(i));
                    statusBuffer.append("\r\n");
                    ++i;
                }
                this.clipboard = new Clipboard(list.getDisplay());
                this.clipboard.setContents(new Object[]{statusBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
            }

            public boolean close() {
                if (this.clipboard != null) {
                    this.clipboard.dispose();
                }
                return super.close();
            }
        };
        dialog.open();
    }
}

