/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.eval.evaluators.AnonymousEvaluationError;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.IMethodParameterEvaluator;
import org.eclipse.wb.internal.core.model.creation.IThisMethodParameterEvaluator;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public abstract class JavaInfoEvaluationHelper {
    public static final String KEY_EDITOR = "KEY_EXPRESSION_VALUE";
    public static final String KEY_PARAMETER_HAS_VALUE = "KEY_PARAMETER_HAS_VALUE";
    public static final String KEY_PARAMETER_VALUE = "KEY_PARAMETER_VALUE";
    private static final String KEY_EXPRESSION_VALUE = "KEY_EXPRESSION_VALUE";
    private static final Object NULL_VALUE = new Object(){

        public String toString() {
            return "NULL_VALUE";
        }
    };
    private static final String KEY_RETURN_VALUE = "KEY_RETURN_VALUE";
    private static final String KEY_EVALUATE_RETURN_VALUE = "KEY_EVALUATE_RETURN_VALUE";
    private final AstEditor m_editor;
    private final EditorState m_state;
    private final ExecutionFlowUtils.ExecutionFlowFrameVisitor m_visitor;
    private final EvaluationContext m_context;
    private final Set<MethodInvocation> m_impossibleJavaInfo = Sets.newHashSet();
    private final Set<Expression> m_evaluatedExpressions = Sets.newHashSet();

    public static boolean hasValue(Expression expression) {
        return expression.properties().containsKey("KEY_EXPRESSION_VALUE");
    }

    public static Object getValue(Expression expression) {
        Object value = expression.getProperty("KEY_EXPRESSION_VALUE");
        if (value == NULL_VALUE) {
            return null;
        }
        return value;
    }

    public static void setValue(Expression expression, Object value) {
        if (value == null) {
            value = NULL_VALUE;
        }
        if (expression != null) {
            expression.setProperty("KEY_EXPRESSION_VALUE", value);
        }
    }

    public static Object getReturnValue(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getProperty(KEY_RETURN_VALUE);
    }

    private static void setReturnValue(MethodDeclaration methodDeclaration, Object value) {
        methodDeclaration.setProperty(KEY_RETURN_VALUE, value);
    }

    public static void shouldEvaluateReturnValue(MethodDeclaration methodDeclaration, boolean evaluate) {
        methodDeclaration.setProperty(KEY_EVALUATE_RETURN_VALUE, (Object)(evaluate ? Boolean.TRUE : null));
    }

    private static boolean shouldEvaluateReturnValue(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getProperty(KEY_EVALUATE_RETURN_VALUE) == Boolean.TRUE;
    }

    public JavaInfoEvaluationHelper(AstEditor editor, ExecutionFlowUtils.ExecutionFlowFrameVisitor visitor) {
        this.m_editor = editor;
        this.m_state = EditorState.get(editor);
        this.m_visitor = visitor;
        this.m_context = this.createEvaluationContext();
        this.m_context.putArbitraryValue("KEY_EXPRESSION_VALUE", editor);
        this.m_context.addEvaluator(new IExpressionEvaluator(){

            public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
                Object object;
                if (JavaInfoEvaluationHelper.this.m_impossibleJavaInfo.contains(expression)) {
                    return AstEvaluationEngine.UNKNOWN;
                }
                if (this.isChainedInvocation(expression)) {
                    return AstEvaluationEngine.UNKNOWN;
                }
                JavaInfo javaInfo = JavaInfoEvaluationHelper.this.getJavaInfoRepresentedBy(expression);
                if (javaInfo != null && (object = javaInfo.getObject()) != null) {
                    return object;
                }
                return AstEvaluationEngine.UNKNOWN;
            }

            private boolean isChainedInvocation(Expression expression) {
                MethodInvocation invocation;
                JavaInfo javaInfo;
                if (expression instanceof MethodInvocation && (javaInfo = JavaInfoEvaluationHelper.this.getJavaInfoRepresentedBy((invocation = (MethodInvocation)expression).getExpression())) != null) {
                    String signature = AstNodeUtils.getMethodSignature(invocation);
                    MethodDescription method = javaInfo.getDescription().getMethod(signature);
                    return method != null && method.hasTrueTag("returnThis");
                }
                return false;
            }
        });
    }

    private EvaluationContext createEvaluationContext() {
        return new EvaluationContext(this.m_state.getEditorLoader(), this.m_state.getFlowDescription()){
            private MethodInvocation m_invocation;

            public String getSource(ASTNode node) {
                if (node == null) {
                    return "<null>";
                }
                return JavaInfoEvaluationHelper.this.m_editor.getSource(node);
            }

            public void evaluationRequested(Expression expression) throws Exception {
                super.evaluationRequested(expression);
                JavaInfoEvaluationHelper.this.m_state.getVisitedNodes().add((ASTNode)expression);
            }

            public void evaluationSuccessful(Expression expression, Object value) throws Exception {
                QualifiedName leftQualifiedName;
                Name leftQualifier;
                JavaInfo javaInfo;
                Assignment assignment;
                Expression leftHandExpression;
                super.evaluationSuccessful(expression, value);
                JavaInfoEvaluationHelper.setValue(expression, value);
                JavaInfo javaInfo2 = JavaInfoEvaluationHelper.this.getJavaInfoRepresentedBy(expression);
                if (javaInfo2 != null) {
                    boolean noObjectYet;
                    boolean bl = noObjectYet = javaInfo2.getObject() == null;
                    if (noObjectYet) {
                        javaInfo2.setObject(value);
                    }
                }
                if (expression instanceof Assignment && (leftHandExpression = (assignment = (Assignment)expression).getLeftHandSide()) instanceof QualifiedName && (javaInfo = JavaInfoEvaluationHelper.this.getJavaInfoRepresentedBy((Expression)(leftQualifier = (leftQualifiedName = (QualifiedName)leftHandExpression).getQualifier()))) != null) {
                    Object javaInfoObject = javaInfo.getObject();
                    Assert.isNotNull(javaInfoObject);
                    String fieldName = leftQualifiedName.getName().getIdentifier();
                    ReflectionUtils.setField(javaInfoObject, fieldName, value);
                }
            }

            public Object evaluationFailed(Expression expression, Throwable e) throws Exception {
                if (DesignerExceptionUtils.isFatal(e)) {
                    return AstEvaluationEngine.UNKNOWN;
                }
                if (!JavaInfoEvaluationHelper.isStrictEvaluationMode() && JavaInfoEvaluationHelper.this.getJavaInfoRepresentedBy(expression) == null) {
                    JavaInfoEvaluationHelper.this.m_state.getBadRefreshNodes().add((ASTNode)expression, e);
                    ITypeBinding binding = AstNodeUtils.getTypeBinding(expression);
                    return JavaInfoEvaluationHelper.getDefaultValue(binding);
                }
                return super.evaluationFailed(expression, e);
            }

            public void addException(ASTNode node, Throwable e) {
                JavaInfoEvaluationHelper.this.m_state.getBadRefreshNodes().add(node, e);
            }

            public Object evaluate(Expression expression) throws Exception {
                CreationSupport creationSupport;
                JavaInfo javaInfo;
                if ((expression == null || expression instanceof ThisExpression) && (javaInfo = JavaInfoEvaluationHelper.this.getThisJavaInfo()) != null) {
                    if (expression == null) {
                        JavaInfoEvaluationHelper.this.thisJavaInfoNodeProcessed(javaInfo, (ASTNode)this.m_invocation);
                    }
                    return javaInfo.getObject();
                }
                javaInfo = JavaInfoEvaluationHelper.this.getJavaInfoRepresentedBy(expression);
                if (javaInfo != null && !(creationSupport = javaInfo.getCreationSupport()).canBeEvaluated()) {
                    Object object = javaInfo.getObject();
                    if (object != null) {
                        return object;
                    }
                    return JavaInfoEvaluationHelper.this.evaluateJavaInfoUsingCreationSupport(javaInfo);
                }
                this.m_invocation = expression instanceof MethodInvocation ? (MethodInvocation)expression : null;
                return AstEvaluationEngine.UNKNOWN;
            }

            public Object evaluateUnknownParameter(MethodDeclaration methodDeclaration, SingleVariableDeclaration parameter) throws Exception {
                Object value = JavaInfoEvaluationHelper.this.evaluateUnknownParameter0(methodDeclaration, parameter);
                if (value != AstEvaluationEngine.UNKNOWN) {
                    return value;
                }
                return super.evaluateUnknownParameter(methodDeclaration, parameter);
            }
        };
    }

    private Object evaluateUnknownParameter0(MethodDeclaration method, SingleVariableDeclaration parameter) throws Exception {
        IThisMethodParameterEvaluator iThisMethodParameterEvaluator;
        Object value;
        if (parameter.getProperty(KEY_PARAMETER_HAS_VALUE) == Boolean.TRUE) {
            return parameter.getProperty(KEY_PARAMETER_VALUE);
        }
        Object value2 = JavaInfoEvaluationHelper.evaluateJavadocTagExpression(this.m_editor, this.m_context, method.getJavadoc(), "@wbp.eval.method.parameter", parameter.getName().getIdentifier());
        if (value2 != AstEvaluationEngine.UNKNOWN) {
            return value2;
        }
        String signature = AstNodeUtils.getMethodSignature(method);
        int index = DomGenerics.parameters(method).indexOf(parameter);
        JavaInfo thisJavaInfo = this.getThisJavaInfo();
        if (thisJavaInfo instanceof IThisMethodParameterEvaluator && (value = (iThisMethodParameterEvaluator = (IThisMethodParameterEvaluator)((Object)thisJavaInfo)).evaluateParameter(this.m_context, method, signature, parameter, index)) != AstEvaluationEngine.UNKNOWN) {
            return value;
        }
        List<IMethodParameterEvaluator> evaluators = ExternalFactoriesHelper.getElementsInstances(IMethodParameterEvaluator.class, "org.eclipse.wb.core.unknownParameterEvaluators", "evaluator");
        for (IMethodParameterEvaluator iMethodParameterEvaluator : evaluators) {
            Object value3 = iMethodParameterEvaluator.evaluateParameter(this.m_context, method, signature, parameter, index);
            if (value3 == AstEvaluationEngine.UNKNOWN) continue;
            return value3;
        }
        if (!JavaInfoEvaluationHelper.isStrictEvaluationMode()) {
            ITypeBinding binding = AstNodeUtils.getTypeBinding(parameter);
            return JavaInfoEvaluationHelper.getDefaultValue(binding);
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    public static Object getDefaultValue(ITypeBinding binding) {
        if (binding == null) {
            return null;
        }
        if (binding.isPrimitive()) {
            String className = AstNodeUtils.getFullyQualifiedName(binding, true);
            return ReflectionUtils.getDefaultValue(className);
        }
        if (AstNodeUtils.isSuccessorOf(binding, "java.lang.String")) {
            return "<dynamic>";
        }
        if (AstNodeUtils.isSuccessorOf(binding, "java.util.LinkedList")) {
            return Lists.newLinkedList();
        }
        if (AstNodeUtils.isSuccessorOf(binding, "java.util.Vector")) {
            return new Vector();
        }
        if (AstNodeUtils.isSuccessorOf(binding, "java.util.List")) {
            return Lists.newArrayList();
        }
        if (AstNodeUtils.isSuccessorOf(binding, "java.util.Set")) {
            return Sets.newHashSet();
        }
        if (AstNodeUtils.isSuccessorOf(binding, "java.util.Map")) {
            return Maps.newHashMap();
        }
        return null;
    }

    private static boolean isStrictEvaluationMode() {
        return DesignerPlugin.getDefault().getPreferenceStore().getBoolean("evaluation.strictMode");
    }

    public final EvaluationContext getContext() {
        return this.m_context;
    }

    public final void evaluate(ASTNode node) {
        try {
            Expression expression;
            ReturnStatement returnStatement;
            Expression expression2;
            JavaInfo javaInfo;
            if (JavaInfoEvaluationHelper.isPossibleJavaInfoCreationExpression(node) && (javaInfo = this.getJavaInfoRepresentedBy(expression2 = (Expression)node)) != null) {
                this.evaluateExpression(expression2);
                return;
            }
            if (node instanceof ReturnStatement && this.shouldEvaluateReturnStatement(returnStatement = (ReturnStatement)node)) {
                expression = returnStatement.getExpression();
                Object object = this.evaluateExpression(expression);
                JavaInfoEvaluationHelper.setReturnValue(AstNodeUtils.getEnclosingMethod((ASTNode)returnStatement), object);
            }
            if (node instanceof ExpressionStatement) {
                MethodInvocation invocation;
                JavaInfo javaInfo2;
                ExpressionStatement expressionStatement = (ExpressionStatement)node;
                expression = expressionStatement.getExpression();
                if (expression instanceof MethodInvocation && (javaInfo2 = this.getJavaInfoRepresentedBy((invocation = (MethodInvocation)expression).getExpression())) != null) {
                    Class<?> componentClass;
                    if (invocation.getExpression() == null && ReflectionUtils.getMethodBySignature(componentClass = javaInfo2.getDescription().getComponentClass(), AstNodeUtils.getMethodSignature(invocation)) != null) {
                        javaInfo2.addRelatedNode((ASTNode)invocation);
                    }
                    if (!javaInfo2.shouldEvaluateInvocation(invocation)) {
                        return;
                    }
                    this.m_impossibleJavaInfo.add(invocation);
                    this.evaluateMethodInvocation(javaInfo2, invocation);
                    return;
                }
                if (expression instanceof SuperMethodInvocation) {
                    invocation = (SuperMethodInvocation)expression;
                    this.evaluateExpression((Expression)invocation);
                }
                if (expression instanceof Assignment) {
                    this.evaluateAssignment(expression);
                }
            }
        }
        catch (Throwable e) {
            ReflectionUtils.propagate(e);
        }
    }

    private static boolean isPossibleJavaInfoCreationExpression(ASTNode node) {
        if (node instanceof CastExpression) {
            CastExpression castExpression = (CastExpression)node;
            return JavaInfoEvaluationHelper.isPossibleJavaInfoCreationExpression((ASTNode)castExpression.getExpression());
        }
        return node instanceof ClassInstanceCreation || node instanceof MethodInvocation || node instanceof SuperMethodInvocation;
    }

    private void evaluateAssignment(Expression expression) throws Exception {
        JavaInfo javaInfo;
        Expression leftQualifier;
        Assignment assignment = (Assignment)expression;
        Expression leftHandExpression = assignment.getLeftHandSide();
        Expression rightHandExpression = assignment.getRightHandSide();
        if (this.getJavaInfoRepresentedBy(rightHandExpression) != null) {
            this.evaluateExpression(rightHandExpression);
        }
        if ((leftQualifier = AstNodeUtils.getFieldAccessQualifier(leftHandExpression)) != null && (javaInfo = this.getJavaInfoRepresentedBy(leftQualifier)) != null) {
            this.evaluateExpression(leftQualifier);
            Object javaInfoObject = javaInfo.getObject();
            Assert.isNotNull(javaInfoObject);
            String fieldName = AstNodeUtils.getFieldAccessName(leftHandExpression).getIdentifier();
            Field field = ReflectionUtils.getFieldByName(javaInfoObject.getClass(), fieldName);
            if (field != null) {
                Object value = this.evaluateExpression(rightHandExpression);
                field.set(javaInfoObject, value);
            }
        }
    }

    public final void evaluateMethodInvocation(JavaInfo javaInfo, MethodInvocation invocation) throws Exception {
        block2: {
            try {
                this.evaluateExpression((Expression)invocation);
            }
            catch (Error e) {
                if (AnonymousEvaluationError.is(e)) break block2;
                throw e;
            }
        }
    }

    public final Object evaluateExpression(Expression expression) throws Exception {
        if (this.m_evaluatedExpressions.contains(expression)) {
            return JavaInfoEvaluationHelper.getValue(expression);
        }
        this.m_evaluatedExpressions.add(expression);
        Object result = AstEvaluationEngine.evaluate(this.m_context, expression);
        Assert.isTrue(result != AstEvaluationEngine.UNKNOWN);
        return result;
    }

    public final Object evaluateJavaInfoUsingCreationSupport(JavaInfo javaInfo) throws Exception {
        Object object = javaInfo.getCreationSupport().create(this.m_context, this.m_visitor);
        Assert.isNotNull(object);
        javaInfo.setObject(object);
        return object;
    }

    protected JavaInfo getRootJavaInfo() {
        throw new NotImplementedException(this.getClass());
    }

    protected void thisJavaInfoNodeProcessed(JavaInfo javaInfo, ASTNode node) throws Exception {
        throw new NotImplementedException(this.getClass());
    }

    protected abstract JavaInfo getJavaInfoRepresentedBy(Expression var1);

    private JavaInfo getThisJavaInfo() {
        JavaInfo rootJavaInfo = this.getRootJavaInfo();
        if (rootJavaInfo != null && rootJavaInfo.getCreationSupport() instanceof ThisCreationSupport) {
            return rootJavaInfo;
        }
        return null;
    }

    private boolean shouldEvaluateReturnStatement(ReturnStatement returnStatement) throws Exception {
        MethodDeclaration enclosingMethod = AstNodeUtils.getEnclosingMethod((ASTNode)returnStatement);
        if (JavaInfoEvaluationHelper.shouldEvaluateReturnValue(enclosingMethod)) {
            return true;
        }
        Expression expression = returnStatement.getExpression();
        return this.getJavaInfoRepresentedBy(expression) != null;
    }

    public static Object evaluateJavadocTagExpression(AstEditor editor, EvaluationContext context, Javadoc javadoc, String tagName, String expectedName) throws Exception {
        if (javadoc != null) {
            for (TagElement tag : DomGenerics.tags(javadoc)) {
                if (!tagName.equals(tag.getTagName())) continue;
                String errorMessage = "'" + tagName + " <name> = <expression>' expected but '" + tag + "' found.";
                Assert.isLegal(tag.fragments().size() == 1, errorMessage);
                TextElement textElement = (TextElement)tag.fragments().get(0);
                String text = textElement.getText().trim();
                String[] parts = StringUtils.split((String)text);
                Assert.isLegal(parts.length >= 2, errorMessage);
                String name = parts[0];
                String expressionText = text.substring(name.length()).trim();
                if (!name.equals(expectedName)) continue;
                Object value = tag.getProperty("KEY_EXPRESSION_VALUE");
                if (value == null) {
                    Expression expression = editor.getParser().parseExpression(javadoc.getStartPosition(), expressionText);
                    value = AstEvaluationEngine.evaluate(context, expression);
                    tag.setProperty("KEY_EXPRESSION_VALUE", value);
                }
                return value;
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }
}

