/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.clipboard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.utils.ui.ImageUtils;

public final class ComponentInfoMemento
extends JavaInfoMemento {
    private static final long serialVersionUID = 0L;
    private final Rectangle m_bounds;
    private final byte[] m_imageBytes;
    private transient Image m_image;

    protected ComponentInfoMemento(AbstractComponentInfo component) throws Exception {
        super(component);
        this.m_bounds = component.getAbsoluteBounds();
        Image image = component.getImage();
        this.m_imageBytes = (byte[])(image != null ? ImageUtils.getBytesPNG(image) : null);
    }

    public Image getImage() {
        if (this.m_image == null && this.m_imageBytes != null) {
            this.m_image = new Image(null, (InputStream)new ByteArrayInputStream(this.m_imageBytes));
        }
        return this.m_image;
    }

    public JavaInfo create(JavaInfo existingHierarchyObject) throws Exception {
        AbstractComponentInfo component = (AbstractComponentInfo)super.create(existingHierarchyObject);
        component.setBounds(this.m_bounds);
        component.setModelBounds(this.m_bounds);
        return component;
    }

    public void apply() throws Exception {
        super.apply();
        if (this.m_image != null) {
            this.m_image.dispose();
        }
    }

    public static Image getImage(AbstractComponentInfo component) {
        ComponentInfoMemento memento = (ComponentInfoMemento)component.getArbitraryValue("KEY_MEMENTO");
        if (memento != null) {
            return memento.getImage();
        }
        return null;
    }
}

